import"../../es-global-bridge/es-global-bridge.js";class SimpleLoginCamera extends HTMLElement{static get tag(){return"simple-login-camera"}constructor(){super(),this.windowControllers=new AbortController,globalThis.WCGlobalBasePath?this.basePath=globalThis.WCGlobalBasePath:this.basePath=new URL("./simple-login-camera.js",import.meta.url).href+"/../../../../",this.t={record:"Record",pause:"Pause record",stopSave:"Stop & Save",clickToTakePhoto:"Click to take photo"},globalThis.dispatchEvent(new CustomEvent("i18n-manager-register-element",{detail:{context:this,namespace:"simple-login",localesPath:new URL("../locales/simple-login.es.json",import.meta.url).href+"/../",updateCallback:"render",locales:["es"]}}));const e=`${this.basePath}msr/MediaStreamRecorder.min.js`;globalThis.ESGlobalBridge.requestAvailability().load("msr",e),globalThis.addEventListener("es-bridge-msr-loaded",this._msrLoaded.bind(this),{signal:this.windowControllers.signal}),this.template=globalThis.document.createElement("template"),this._shadow=this.attachShadow({mode:"closed"}),this.render(),this._video=this._shadow.querySelector("video"),this._error=this._shadow.querySelector("p"),this._record=this._shadow.querySelector("button.record"),this._pauseRecord=this._shadow.querySelector("button.pause-record"),globalThis.document.addEventListener("DOMContentLoaded",this.documentLoaded.bind(this),{signal:this.windowControllers.signal}),this.hasAttribute("record")?(this._record.addEventListener("click",(()=>this._record.hasAttribute("recording")?(this._record.innerText=this.t.record,this._record.removeAttribute("recording"),this._stopRecording()):(this._record.innerText=this.t.stopSave,this._record.setAttribute("recording",""),this._startRecording()))),this._pauseRecord.addEventListener("click",(()=>this._pauseRecord.hasAttribute("resume")?(this._pauseRecord.innerText="Pause record",this._pauseRecord.removeAttribute("resume"),this._resumeRecording()):(this._pauseRecord.innerText="Resume record",this._pauseRecord.setAttribute("resume",""),this._pauseRecording())))):(this._record.remove(),this._pauseRecord.remove())}render(){this._shadow.innerHTML=null,this.template.innerHTML=this.html,globalThis.ShadyCSS&&globalThis.ShadyCSS.prepareTemplate(this.template,this.tag),this._shadow.appendChild(this.template.content.cloneNode(!0))}static get observedAttributes(){return["autoplay","controls","audio"]}_startRecording(){this._pauseRecord.removeAttribute("hidden"),this.MediaStreamRecorder.start(100)}_stopRecording(){this._pauseRecord.setAttribute("hidden",""),this._pauseRecord.removeAttribute("resume"),this.MediaStreamRecorder.stop()}_pauseRecording(){this._record.setAttribute("disabled",""),this.MediaStreamRecorder.pause()}_resumeRecording(){this._record.removeAttribute("disabled"),this.MediaStreamRecorder.resume()}_saveVideo(e){const t=e.type.split("/").pop();this.MediaStreamRecorder.save(e,`my-camera-${(new Date).toISOString().replace(/:|\./g,"-")}.${t}`)}_cameraStream(){return navigator.mediaDevices.getUserMedia?globalThis.navigator.mediaDevices.getUserMedia({video:{width:{min:320,ideal:1280,max:1920},height:{min:240,ideal:720,max:1080},facingMode:"user"},audio:this.hasAttribute("audio")}):Promise.reject(new Error("getUserMedia is not implemented in this browser"))}async takeASnap(){const e=globalThis.document.createElement("canvas"),t=e.getContext("2d");return e.width=this._video.videoWidth,e.height=this._video.videoHeight,t.drawImage(this._video,0,0),await new Promise(((t,r)=>{e.toBlob(t,"image/jpeg")}))}renderImage(e){let t=globalThis.document.createElement("img");return t.src=URL.createObjectURL(e),t}imageBlob(e){return e}download(e){let t=globalThis.document.createElement("a");t.href=URL.createObjectURL(e),t.download="screenshot.jpg",globalThis.document.body.appendChild(t),t.click()}_addVideoAtributes(){this._video.autoplay=this.hasAttribute("autoplay"),this._video.controls=this.hasAttribute("controls")}_msrLoaded(e){this._applyMSR(),this._shadow.querySelector("#wrapper").addEventListener("click",(()=>{this.dispatchEvent(new CustomEvent("site-listing-video-activate",{detail:this,bubbles:!0,composed:!0}))}))}async _applyMSR(){globalThis.addEventListener("site-listing-video-activate",(async()=>{try{this._video.srcObject=await this._cameraStream(),globalThis.stream=this._video.srcObject,this._addVideoAtributes(),this.hasAttribute("record")&&(this.MediaStreamRecorder=new MediaStreamRecorder(this._video.srcObject),this.MediaStreamRecorder.ondataavailable=this._saveVideo.bind(this)),setTimeout((()=>{this.dispatchEvent(new CustomEvent("simple-login-camera-icon-click",{detail:this,bubbles:!0,composed:!0}))}),100),this._error.remove()}catch(e){if(this._video.remove(),this._record.remove(),this._pauseRecord.remove(),"ConstraintNotSatisfiedError"===e.name)this._error.innerText="The resolution is not supported by your device.";else{if("NotAllowedError"!==e.name)throw this._error.innerText=e.message,Error(e);this._error.innerText="Permissions have not been granted to use your camera and microphone, you need to allow the page access to your devices in order for the demo to work."}}}),{signal:this.windowControllers.signal})}connectedCallback(){!0===globalThis.ESGlobalBridge.requestAvailability().imports.msr&&this._applyMSR(),this._t={...this.t}}documentLoaded(e){!0===globalThis.ESGlobalBridge.requestAvailability().imports.msr&&this._applyMSR()}disconnectedCallback(){this.windowControllers.abort()}attributeChangedCallback(e,t,r){}get html(){return`\n      <style>\n        :host {\n          display: flex;\n        }\n        #wrapper {\n          overflow: hidden;\n          display: flex;\n          justify-content: center;\n          align-items: center;\n          flex-direction: column;\n          flex-wrap: wrap;\n          position: relative;\n          background-color: var(--simple-login-camera-background, var(--background-color, #ccc));\n        }\n        video {\n          margin-left: calc(100% * var(--simple-login-camera-aspect, 1) / 2 - 177.77777777777% / 2);          \n          width: calc(177.77777777777% / var(--simple-login-camera-aspect, 1));\n          background-color: rgba(0, 0, 0, 0);\n        }\n        .error {\n          color: black;\n          background-color: white;\n          font-size: 26px;\n          text-align: center;\n          padding: 10px;\n          position: absolute;\n        }\n        .custom-controls {\n          top: 8px;\n          right: 8px;\n          position: absolute;\n        }\n        .custom-controls button {\n          padding: 8px 10px;\n        }\n        [hidden] {\n          display: none;\n        }\n      </style>\n      <div id="wrapper" part="wrapper">\n        <video part="video"></video>\n        <p class="error" part="error">${this.t.clickToTakePhoto}</p>\n        <div class="custom-controls" part="controls">\n          <button class="record" part="record">${this.t.record}</button>\n          <button class="pause-record" hidden part="pause">${this.t.pause}</button>\n        </div>\n      </div>\n    `}}navigator.mediaDevices&&customElements.define(SimpleLoginCamera.tag,SimpleLoginCamera);export{SimpleLoginCamera};