/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,svg as e,css as i,LitElement as o}from"../../../lit/index.js";import"./simple-icon-lite.js";import"./simple-icons.js";import{SimpleIconsetStore as s}from"./simple-iconset.js";import{SimpleIconIconsetsManifest as n}from"./simple-iconset-manifest.js";import{HaxIconsetManifest as c}from"../../hax-iconset/lib/hax-iconset-manifest.js";class SimpleIconsetDemo extends o{static get tag(){return"simple-iconset-demo"}static get styles(){return[i`
        :host {
          display: block;
          box-shadow:
            0 2px 2px 0 rgba(0, 0, 0, 0.14),
            0 1px 5px 0 rgba(0, 0, 0, 0.12),
            0 3px 1px -2px rgba(0, 0, 0, 0.2);
          margin-bottom: 40px;
          padding: 20px 40px;
        }

        ul {
          list-style-type: none;
          padding: 0;
        }

        li {
          display: inline-block;
          width: 160px;
          margin: 16px 8px;
          text-align: center;
          font-size: 10px;
        }

        simple-icon-lite {
          display: inline-block;
        }

        .iconset:not(:first-of-type) {
          border-top: 1px solid #ddd;
        }

        .iconset:nth-of-type(9n + 1) {
          color: #444444;
        }

        .iconset:nth-of-type(9n + 2) {
          color: #be3300;
        }

        .iconset:nth-of-type(9n + 3) {
          color: #0000b5;
        }

        .iconset:nth-of-type(9n + 4) {
          color: #750075;
        }

        .iconset:nth-of-type(9n + 5) {
          color: #aa5d00;
        }

        .iconset:nth-of-type(9n + 6) {
          color: #db0a5b;
        }

        .iconset:nth-of-type(9n + 7) {
          color: #005500;
        }

        .iconset:nth-of-type(9n + 8) {
          color: #cf000f;
        }

        .iconset:nth-of-type(9n) {
          color: #005f8b;
        }
      `]}render(){return this.iconsets.length<1?"Looking for iconsets...":this.iconsets.map((e=>t`<div class="iconset">
              <p><strong>${e.name}</strong></p>
              <ul>
                ${e.icons.map((i=>t`
                    <li>
                      <div id="icon">
                        <simple-icon-lite
                          icon="${e.name}:${i}"
                        ></simple-icon-lite>
                        <div id="icon-text">
                          ${"icons"===e.name?"":`${e.name}:`}${i}
                        </div>
                      </div>
                    </li>
                  `))}
              </ul>
            </div> `))}static get properties(){return{exclude:{attribute:"exclude",type:String},iconsets:{type:Array},include:{attribute:"include",type:String},imports:{type:Array}}}constructor(){super(),globalThis.SimpleIconset.requestAvailability(),this.imports=[],this._getIconsets()}updated(t){t.forEach(((t,e)=>{"imports"==e&&this._getIconsets()}))}_getIconsets(){let t=(this.imports.length<1?[n,c]:this.imports).flat(),e=(this.exclude||"").split(" "),i=(this.include||"").split(" ");this.iconsets=t.filter((t=>!!t&&!e.includes(t)&&(!this.include||i.includes(t))))}}customElements.define(SimpleIconsetDemo.tag,SimpleIconsetDemo);export{SimpleIconsetDemo};