/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,svg as e,css as i,LitElement as r}from"../../../lit/index.js";import{SimpleIconsetStore as o}from"./simple-iconset.js";export const SimpleIconBehaviors=function(r){return class extends r{static get styles(){return[super.styles||[],i`
          :host {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            position: relative;
            vertical-align: middle;
            height: var(--simple-icon-height, 24px);
            width: var(--simple-icon-width, 24px);
            color: var(--simple-icon-color, currentColor);
          }
          :host([dir="rtl"]) svg {
            direction: rtl;
          }
          :host([hidden]) {
            display: none;
          }
          #svg-polyfill {
            background-color: var(--simple-icon-color, currentColor);
            height: var(--simple-icon-height, 24px);
            width: var(--simple-icon-width, 24px);
          }
          svg {
            height: var(--simple-icon-height, 24px);
            width: var(--simple-icon-width, 24px);
            max-height: var(--simple-icon-height, 24px);
            max-width: var(--simple-icon-width, 24px);
            filter: var(--simple-icon-color, initial);
            pointer-events: none;
          }
          feFlood {
            flood-color: var(--simple-icon-color, currentColor);
          }
        `]}render(){return this.useSafariPolyfill?t`
            <div
              id="svg-polyfill"
              style="mask:${this.safariMask};-webkit-mask:${this.safariMask}"
            ></div>
          `:e`
        <svg xmlns="http://www.w3.org/2000/svg" part="simple-icon-svg" viewBox="0 0 24 24" preserveAspectRatio="xMidYMid meet">
          <filter
            color-interpolation-filters="sRGB"
            x="0"
            y="0"
            height="24px"
            width="24px"
          >
            ${this.feFlood}
            <feComposite operator="in" in="COLOR" in2="SourceAlpha" />
          </filter>
          <image
            xlink:href=""
            width="24px"
            height="24px"
            focusable="false"
            preserveAspectRatio="xMidYMid meet"
          ></image>
        </svg>
      `}get feFlood(){return this.noColorize?"":e`<feFlood result="COLOR"/>`}static get properties(){return{...super.properties,dir:{type:String,reflect:!0},src:{type:String},noColorize:{type:Boolean,attribute:"no-colorize"},icon:{type:String,attribute:"icon",reflect:!0}}}constructor(){super(),this.noColorize=!1,this.dir=this.documentDir}get documentDir(){return globalThis.document&&globalThis.document.body&&(globalThis.document.body.getAttribute("xml:dir")||globalThis.document.body.getAttribute("dir")||globalThis.document.documentElement.getAttribute("xml:dir")||globalThis.document.documentElement.getAttribute("dir"))||"ltr"}get useSafariPolyfill(){return globalThis.navigator&&globalThis.navigator.userAgent.indexOf("Safari")>-1}get safariMask(){return this.src&&this.useSafariPolyfill?`url(${this.src}) no-repeat center / contain`:""}firstUpdated(t){if(super.firstUpdated&&super.firstUpdated(t),this.useSafariPolyfill)return;const e="f-"+Math.random().toString().slice(2,10);this.shadowRoot.querySelector("image").style.filter=`url(#${e})`,this.shadowRoot.querySelector("filter").setAttribute("id",e)}setSrcByIcon(t){return this.src=o.getIcon(this.icon,t),this.src}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"icon"===e&&(this[e]?this.setSrcByIcon(this):this.src=null),"src"===e&&this[e]&&!this.useSafariPolyfill&&this.shadowRoot.querySelector("image").setAttribute("xlink:href",`${this[e]}`)}))}}};class SimpleIconLite extends(SimpleIconBehaviors(r)){static get tag(){return"simple-icon-lite"}}customElements.define(SimpleIconLite.tag,SimpleIconLite);export{SimpleIconLite};