/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as o}from"../../../lit/index.js";import{SimpleColors as e}from"../../simple-colors/simple-colors.js";import{SimpleIconButtonBehaviors as i}from"./simple-icon-button-lite.js";import"./simple-icons.js";import"../simple-icon.js";class SimpleIconButton extends(i(e)){static get tag(){return"simple-icon-button"}constructor(){super(),this.accentColor="grey",this.contrast=4,this.dark=!1}render(){return t`
      <button
        ?autofocus="${this.autofocus}"
        .aria-labelledby="${this.ariaLabelledby}"
        .aria-pressed="${this.toggles||this.toggled?"true":this.toggles?"false":void 0}"
        controls="${this.controls}"
        part="button"
        ?disabled="${this.disabled}"
        form="${this.form}"
        label="${this.label}"
        aria-label="${this.label}"
        name="${this.fieldName}"
        .type="${this.type}"
        value="${this.value}"
      >
        <simple-icon
          part="icon"
          icon="${this.icon}"
          accent-color="${this.accentColor}"
          contrast="${this.contrast}"
          ?dark="${this.dark}"
          ?no-colorize="${this.noColorize}"
        ></simple-icon>
      </button>
    `}static get properties(){return{...super.properties,contrast:{type:Number,reflect:!0}}}}customElements.define(SimpleIconButton.tag,SimpleIconButton);export{SimpleIconButton};