/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../lit/index.js";import{SimpleFieldsLite as s}from"./lib/simple-fields-lite.js";import"./lib/simple-fields-field.js";class SimpleFields extends s{static get styles(){return[super.styles,i`
        :host {
          display: block;
          --simple-picker-background-color: var(
            --simple-fields-background-color,
            transparent
          );
          --simple-picker-border-width: 0;
          --simple-picker-focus-border-width: 0;
          --simple-picker-display: block;
          --simple-picker-listbox-border-width: 1px;
          --simple-picker-listbox-outline: none;
        }

        :host([hidden]) {
          display: none;
        }
      `]}render(){return t` <div id="schema-fields" aria-live="polite" part="fields-list">
      <slot></slot>
    </div>`}static get haxProperties(){return{}}static get properties(){return{...super.properties,disableResponsive:{type:Boolean,reflect:!0,attribute:"disable-responsive"},fields:{type:Array},schematizer:{type:Object,attribute:"schematizer"},label:{type:String},__activeTabs:{type:Object,attribute:"active-path"},codeTheme:{type:String,attribute:"code-theme"}}}static get tag(){return"simple-fields"}constructor(){super(),this.activeTabs={},this.__codeElements=[],this.disableResponsive=!1,setTimeout((()=>{this.addEventListener("a11y-tabs-active-changed",this._handleActiveTab)}),0)}get convertedSchema(){return{$schema:"http://json-schema.org/schema#",title:this.label,type:"object",required:[],properties:this.fieldsToSchema(this.fields)}}get schemaConversion(){return this.elementizer||{defaultSettings:{element:"simple-fields-field",errorProperty:"errorMessage",invalidProperty:"invalid",noWrap:!0,attributes:{type:"text"},properties:{minLength:"minlength",maxLength:"maxlength"}},format:{radio:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"radio"},properties:{options:"options"},child:{element:"simple-fields-array-item",noWrap:!0,descriptionProperty:"description",properties:{previewBy:"previewBy"}}}},select:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"select"},properties:{options:"options",items:"itemsList"}}},"simple-picker":{defaultSettings:{import:"@haxtheweb/simple-picker/simple-picker.js",element:"simple-picker",attributes:{autofocus:!0,justify:!0},properties:{options:"options",justify:"justify"}}}},type:{array:{defaultSettings:{element:"simple-fields-array",noWrap:!0,descriptionProperty:"description",child:{element:"simple-fields-array-item",noWrap:!0,descriptionProperty:"description",properties:{previewBy:"previewBy",sortable:!0}}}},boolean:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"checkbox",value:!1}}},file:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"file"},properties:{accepts:"accepts"}}},integer:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,step:1,type:"number"},properties:{minimum:"min",maximum:"max",multipleOf:"step"}}},"html-block":{defaultSettings:{import:"@haxtheweb/simple-fields/lib/simple-fields-html-block.js",element:"simple-fields-html-block",noWrap:!0,attributes:{autofocus:!1,required:!1}}},markup:{defaultSettings:{import:"@haxtheweb/simple-fields/lib/simple-fields-code.js",element:"simple-fields-code",setValueProperty:"editorValue",noWrap:!0,properties:{theme:"theme"}},format:{"md-block":{defaultSettings:{element:"md-block",setValueProperty:"source",noWrap:!0}}}},number:{defaultSettings:{element:"simple-fields-field",noWrap:!0,type:"number",attributes:{autofocus:!0,type:"number"},properties:{minimum:"min",maximum:"max",multipleOf:"step"}}},object:{defaultSettings:{element:"simple-fields-fieldset",noWrap:!0},format:{tabs:{defaultSettings:{import:"@haxtheweb/simple-fields/lib/simple-fields-tabs.js",element:"simple-fields-tabs",noWrap:!0,child:{import:"@haxtheweb/simple-fields/lib/simple-fields-tab.js",element:"simple-fields-tab",noWrap:!0,labelSlot:"label",descriptionSlot:""},properties:{layoutBreakpoint:"layoutBreakpoint",iconBreakpoint:"iconBreakpoint",sticky:"sticky",disableResponsive:this.disableResponsive}}},collapse:{defaultSettings:{import:"@haxtheweb/a11y-collapse/lib/a11y-collapse-group.js",element:"a11y-collapse-group",noWrap:!0,child:{import:"@haxtheweb/a11y-collapse/a11y-collapse.js",element:"a11y-collapse",noWrap:!0,labelSlot:"heading",descriptionSlot:""},attributes:{accordion:"accordion"}}},fields:{defaultSettings:{element:"simple-fields",noWrap:!0,descriptionProperty:"description",properties:{schema:"schema"}}}}},string:{format:{alt:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,required:!0}}},color:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"color"}}},colorpicker:{defaultSettings:{import:"@haxtheweb/simple-colors/lib/simple-colors-picker.js",element:"simple-colors-picker",attributes:{autofocus:!0}}},combo:{defaultSettings:{import:"@haxtheweb/simple-fields/lib/simple-fields-combo.js",element:"simple-fields-combo",noWrap:!0,attributes:{autofocus:!0,justify:!0}},properties:{autocomplete:"autocomplete",justify:"justify"}},date:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"date"}}},"date-time":{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"datetime-local"}}},date:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"date"}}},email:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"email"}}},fileupload:{defaultSettings:{import:"@haxtheweb/simple-fields/lib/simple-fields-upload.js",element:"simple-fields-upload",noWrap:!0,attributes:{autofocus:!0}},properties:{autocomplete:"autocomplete"}},iconpicker:{defaultSettings:{import:"@haxtheweb/simple-icon-picker/simple-icon-picker.js",element:"simple-icon-picker",attributes:{autofocus:!0},properties:{options:"icons",exclude:"exclude",excludeSets:"excludeSets",includeSets:"includeSets"}}},month:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"month"}}},textarea:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"textarea"}}},time:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"time"}}},uri:{defaultSettings:{element:"simple-fields-field",noWrap:!0,attributes:{autofocus:!0,type:"file"}}},url:{defaultSettings:{import:"@haxtheweb/simple-fields/lib/simple-fields-url-combo.js",element:"simple-fields-url-combo",noWrap:!0,attributes:{autofocus:!0,justify:!0},properties:{autocomplete:"autocomplete",alwaysExpanded:"alwaysExpanded",displayAs:"displayAs",options:"options"}}}}}}}}get fieldsConversion(){return this.schematizer||{defaultSettings:{type:"string"},format:{"simple-fields":{defaultSettings:{type:"object",format:"simple-fields"}}},inputMethod:{alt:{defaultSettings:{type:"string",format:"alt"}},array:{defaultSettings:{type:"array"},properties:{label:"itemLabel"}},boolean:{defaultSettings:{type:"boolean"}},code:{defaultSettings:{type:"markup"}},"code-editor":{defaultSettings:{type:"markup"}},color:{defaultSettings:{type:"string",format:"color"}},colorpicker:{defaultSettings:{type:"string",format:"colorpicker"}},combo:{defaultSettings:{type:"string",format:"combo"}},"date-time":{defaultSettings:{type:"string",format:"date-time"}},datepicker:{defaultSettings:{type:"string",format:"date"}},fieldset:{defaultSettings:{type:"object"}},fileupload:{defaultSettings:{type:"string",format:"fileupload"}},haxupload:{defaultSettings:{type:"string",format:"fileupload"}},"html-block":{defaultSettings:{type:"html-block"}},iconpicker:{defaultSettings:{type:"string",format:"iconpicker"}},markup:{defaultSettings:{type:"markup"}},"md-block":{defaultSettings:{type:"markup"}},monthpicker:{defaultSettings:{type:"string",format:"month"}},number:{defaultSettings:{type:"number"}},object:{defaultSettings:{type:"object"}},select:{defaultSettings:{type:"string",format:"select"}},slider:{defaultSettings:{type:"number",format:"slider"}},tabs:{defaultSettings:{type:"object",format:"tabs"}},collapse:{defaultSettings:{type:"object",format:"collapse"}},textarea:{defaultSettings:{type:"string",format:"textarea"}},timepicker:{defaultSettings:{type:"string",format:"time"}},url:{defaultSettings:{type:"string",format:"url"}},weekpicker:{defaultSettings:{type:"string",format:"week"}}}}}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{["fields","fieldsConversion"].includes(t)&&(this.schema=this.convertedSchema),"__activeTabs"===t&&this.activeTabs!==e&&this._handleActiveTabs()}))}setActiveTab(e){let t=e.replace(/\.[0-9a-z]+$/,""),i=this.querySelector(`#${t}`),s=i.querySelector(`#${e}`);i&&s&&(i.activeTab=e)}setActivePath(e){let t=e.split("/"),i="";t.forEach((e=>{this.setActiveTab(e),i+=e}))}_convertField(e,t=this.fieldsConversion,i={}){let s=Object.keys(e||{}),l=Object.keys(t||{}).filter((e=>s.includes(e)));return t.defaultSettings&&(i=t.defaultSettings),l.forEach((s=>{let l=e[s],a=t?t[s]:void 0,r=a?Array.isArray(l)?a[l[0]]:a[l]:void 0;r&&(i=this._convertField(e,r,a,i))})),i}_fieldToSchema(e){let t={};return Object.keys(e||{}).forEach((i=>{!e.inputMethod&&e.properties&&(e.inputMethod="object");let s=this._convertField(e);s.type&&(t.type=s.type),s.format&&(t.format=s.format),"pattern"===i?".*"!=e.validation&&(t.pattern=e.validation):"properties"===i?"array"===s.type&&Array.isArray(e.properties)?t.items={type:"object",properties:this.fieldsToSchema(e.properties)}:"array"===s.type?t.items=this._fieldToSchema(e.properties):t.properties=this.fieldsToSchema(e.properties):["items","inputMethod","property","properties","required","type","validation"].includes(i)||(t[i]=e[i])})),"markup"!=t.type||t.theme||(t.theme=this.codeTheme),t}fieldsToSchema(e){let t={};return e&&e.forEach&&e.forEach((e=>{let i=e.property?e.property:e.attribute?e.attribute:"";t[i]=this._fieldToSchema(e)})),t}_handleActiveTabs(){this.dispatchEvent(new CustomEvent("active-tabs-changed",{bubbles:!0,cancelable:!0,composed:!1,detail:this}))}_handleActiveTab(e){e&&e.detail&&e.detail.id&&(this.activeTabs[e.detail.id]=e.detail.activeTab)}}customElements.define(SimpleFields.tag,SimpleFields);export{SimpleFields};