/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as i,css as t}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";import"../../hax-iconset/lib/simple-hax-iconset.js";class SimpleFieldsUrlComboItem extends e{static get styles(){return[t`
        :host {
          display: flex;
          align-items: center;
          padding: var(--simple-fields-button-padding, 2px);
          font-size: var(--simple-fields-detail-font-size, 12px);
        }

        :host([hidden]) {
          display: none;
        }
        *[part="preview"] {
          width: var(--simple-fields-url-combo-preview-size, 26px);
          height: var(--simple-fields-url-combo-preview-size, 26px);
          --simple-icon-height: var(
            --simple-fields-url-combo-preview-size,
            26px
          );
          --simple-icon-width: var(
            --simple-fields-url-combo-preview-size,
            26px
          );
          margin-right: var(--simple-fields-button-padding, 2px);
        }
        span[part="preview"] {
          background-position: center;
          background-size: cover;
          background-repeat: no-repeat;
          border-radius: var(--simple-fields-border-radius, 2px);
        }
        span[part="label"] {
          max-width: 100%;
          flex: 1 1 auto;
        }
        span[part="label"] span {
          display: block;
          line-height: 100%;
          margin: 0;
          overflow-wrap: break-word;
          word-wrap: break-word;
        }
        span[part="label-secondary"] {
          font-size: var(--simple-fields-meta-font-size, 10px);
          opacity: var(--simple-fields-meta-opacity, unset);
          color: var(--simple-fields-meta-color);
        }
      `]}render(){return i`${this.previewTemplate}${this.labelTemplate}`}get iconTypes(){return{anchor:"hax:anchor",page:"lrn:content",pdf:"hax:file-pdf",doc:"hax:file-doc",docx:"hax:file-docx",ppt:"hax:file-ppt",pptx:"hax:file-ppt",csv:"hax:file-csv",xls:"hax:file-xls",xlsx:"hax:file-xls",url:"icons:language",file:"hax:file-blank",mp4:"av:movie",mov:"av:movie",webm:"av:movie",mp3:"av:volume-up",wav:"av:volume-up",html:"icons:language",tel:"communication:phone",email:"icons:mail"}}get currentLocation(){return globalThis.location}get resourceURL(){return new URL(this.value||"./",this.currentLocation)}get isLocal(){return!!this.resourceURL.hostname&&this.resourceURL.hostname==this.currentLocation.hostname}get isSamePage(){return this.isLocal&&`${this.resourceURL.pathname}${this.resourceURL.search}`==`${this.currentLocation.pathname}${this.currentLocation.search}`}get isAnchor(){return this.isSamePage&&!!this.resourceURL.hash}get fileExtension(){let e=(this.resourceURL&&this.resourceURL.pathname?this.resourceURL.pathname:"").match(/\.\w+$/);return((e&&e[0]?e[0].replace(/^\./,""):this.type?this.type:"")||"").toLowerCase()}get imageTypes(){return["gif","svg","png","jpg","jpeg"]}get pageTypes(){return["html","htm","php",""]}get isPage(){return this.pageTypes.includes(this.fileExtension)}get isEmail(){return!!this.resourceURL&&"mailto:"===this.resourceURL.protocol}get isPhone(){return!!this.resourceURL&&"tel:"===this.resourceURL.protocol}get isImage(){return this.imageTypes.includes(this.fileExtension)}get previewSrc(){return this.preview&&""!==this.preview.trim()?this.preview:void 0}get iconName(){return this.icon&&""!==this.icon.trim()?this.icon:this.isAnchor?this.iconTypes.anchor:this.isLocal&&this.isPage?this.iconTypes.page:this.isPage?this.iconTypes.html:this.isEmail?this.iconTypes.email:this.isPhone?this.iconTypes.tel:this.fileExtension&&""!==this.fileExtension?this.iconTypes[this.fileExtension]:this.iconTypes.file}get iconTemplate(){return i`<simple-icon-lite
      part="preview"
      icon="${this.iconName}"
    ></simple-icon-lite>`}get imageTemplate(){return i`<span
      part="preview"
      style="background-image: url(${this.previewSrc})"
    ></span>`}get previewTemplate(){return this.preview&&""!==this.preview?this.imageTemplate:this.icon&&""!==this.icon?this.iconTemplate:this.previewSrc&&""!==this.previewSrc?this.imageTemplate:this.iconName&&""!==this.iconName?this.iconTemplate:""}get labelTemplate(){return i`<span part="label">
      ${this.primaryLabelTemplate}
      ${this.name&&""!==this.name.trim()?this.secondaryLabelTemplate:""}
    </span>`}get primaryLabelTemplate(){return this.name&&""!==this.name.trim()?i`<span part="label-primary">${this.name}</span>`:this.value&&""!==this.value.trim()?i`<span part="label-primary">${this.value}</span>`:""}get secondaryLabelTemplate(){return this.value&&""!==this.value.trim()?i`<span part="label-secondary">${this.value}</span>`:""}static get properties(){return{...super.properties,name:{name:"name",type:String,reflectToAttribute:!0},icon:{name:"icon",type:String,reflectToAttribute:!0},preview:{name:"preview",type:String,reflectToAttribute:!0},type:{name:"type",type:String,reflectToAttribute:!0},value:{name:"value",type:String,reflectToAttribute:!0}}}static get tag(){return"simple-fields-url-combo-item"}constructor(){super()}firstUpdated(e){}updated(e){e.forEach(((e,i)=>{}))}}customElements.define(SimpleFieldsUrlComboItem.tag,SimpleFieldsUrlComboItem);export{SimpleFieldsUrlComboItem};