import{html as e,css as i,LitElement as t}from"../../../lit/index.js";import"./simple-fields-field.js";import{SimpleFieldsButtonStyles as o}from"./simple-fields-ui.js";import{SimpleFieldsFieldsetBehaviors as a}from"./simple-fields-fieldset.js";import"./simple-fields-url-combo.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";import"../../simple-toolbar/simple-toolbar.js";import"../../simple-toolbar/lib/simple-toolbar-button.js";import"../../../@vaadin/vaadin-upload/vaadin-upload.js";import"../../responsive-utility/responsive-utility.js";import{I18NMixin as s}from"../../i18n-manager/lib/I18NMixin.js";class SimpleFieldsUpload extends(s(a(t))){static get tag(){return"simple-fields-upload"}static get styles(){return[super.styles,...o,i`
        :host {
          pointer-events: all;
          overflow: visible;
          --simple-login-camera-aspect: 1.777777777777;
          --simple-camera-snap-color: var(--simple-fields-color, currentColor);
          --simple-camera-snap-background: var(
            --simple-fields-background-color,
            unset
          );
          --simple-camera-snap-border-radius: 2px;
          --lumo-font-family: var(--simple-fields-font-family, sans-serif);
          --lumo-error-color: var(--simple-fields-error-color, #b40000);
          --lumo-primary-font-color: var(--simple-fields-color, currentColor);
          --lumo-base-color: var(--simple-fields-background-color, transparent);
        }
        :host([responsive-size="xs"]),
        div[part="description"] {
          font-size: 10px;
          --simple-fields-font-size: 10px;
          --simple-fields-button-font-size: 11px;
          --simple-fields-legend-font-size: 11px;
          --simple-fields-detail-font-size: 10px;
        }
        fieldset {
          padding: 0px;
          max-width: 100%;
        }
        #upload,
        div[slot="drop-label"] {
          display: flex;
          align-items: center;
          justify-content: center;
          flex-wrap: wrap;
          width: 100%;
        }
        #upload {
          border-radius: var(--simple-fields-border-radius, 2px);
          border: 1px dashed var(--simple-fields-border-color-light, #ccc);
        }
        #url {
          flex: 1 1 100%;
          margin: var(--simple-fields-margin-small, 8px) 0;
          background-color: transparent;
        }
        #upload-options {
          position: relative;
        }
        div[slot="drop-label"] > * {
          flex: 0 1 auto;
        }
        simple-fields-url-combo[always-expanded]::part(listbox) {
          background-color: transparent;
        }
        simple-toolbar-button {
          font-family: var(--simple-fields-font-family, sans-serif);
          color: var(--simple-fields-color, currentColor);
          margin: calc(0.5 * var(--simple-fields-margin-small, 8px))
            calc(0.25 * var(--simple-fields-margin-small, 8px));
        }
        simple-toolbar-button[part="cancel-media"] {
          position: absolute;
          right: 0;
          top: 0;
          z-index: 2;
          --simple-fields-button-padding-sm: 0;
          background-color: var(--simple-fields-background-color, white);
          opacity: 0.7;
        }
        span[part="drop-area-text"] {
          font-family: var(--simple-fields-button-font-family, sans-serif);
          font-size: var(--simple-fields-button-font-size, 10px);
          white-space: nowrap;
          margin: calc(0.5 * var(--simple-fields-margin-small, 8px))
            calc(0.25 * var(--simple-fields-margin-small, 8px));
        }
        vaadin-upload {
          padding: var(--simple-fields-margin-small, 8px);
          position: relative;
          overflow: visible;
          border: none !important;
          --lumo-font-size-s: 10px;
        }
        vaadin-upload::part(file-list) {
          max-height: 140px;
          overflow-x: hidden;
          overflow-y: auto;
        }
        vaadin-upload[dragover] {
          border-color: var(
            --simple-fields-secondary-accent-color,
            var(--simple-colors-default-theme-accent-3, #77e2ff)
          );
        }
        vaadin-upload::part(drop-label) {
          font-family: var(--simple-fields-font-family, sans-serif);
          color: var(--simple-fields-color, currentColor);
          display: flex;
          align-items: center;
          justify-content: center;
          flex-wrap: wrap;
          padding: 0;
          width: 100%;
          margin-top: -16px;
        }
        vaadin-upload.option-selfie::part(drop-label) {
          display: block;
        }
        vaadin-upload::part(drop-label-icon) {
          display: none;
        }
        vaadin-upload-file {
          --disabled-text-color: #var(--simple-fields-border-color, #999);
        }
        simple-camera-snap {
          --simple-camera-snap-button-container-bottom: 2px;
          --simple-camera-snap-button-container-z-index: 5;
          --simple-camera-snap-button-border-radius: 100%;
          --simple-camera-snap-button-opacity: 0.7;
          max-width: 250px;
          margin: 0 auto;
        }

        /** voice stuff which is in lite dom below */
        .vmsg-button {
          border: 1px solid #ccc;
          border-radius: 0;
          padding: 4px;
          margin: 0 4px;
        }
        .vmsg-timer {
          padding: 4px;
        }
        #add-hidden {
          display: none;
        }
        /** account for mobile devices not sending this event accurately */
        @media (max-width: 640px) {
          #browse {
            display: none;
          }
          #add-hidden {
            display: block;
            float: right;
            width: 100%;
            margin: 0 0 16px 0;
          }
          vaadin-upload::part(file-list) {
            max-height: 48px;
            font-size: 8px;
          }
        }
      `]}constructor(){super(),this.voice=null,this.t=this.t||{},this.t={...this.t,dropMediaHereOr:"drop media here or",upload:"Upload",takePhoto:"Take photo",recordAudio:"Record audio",cancel:"Cancel",uploadMedia:"Upload media"},this.registerLocalization({context:this,namespace:"simple-fields",localesPath:new URL("../locales/simple-fields.es.json",import.meta.url).href+"/../",locales:["es"]}),this.hideInput=!1,this.itemsList=[],this.autocomplete="off",this.noCamera=!1,this.noVoiceRecord=!1,this.responsiveSize="sm"}render(){return e`
      <fieldset part="fieldset">${this.legend} ${this.fields}</fieldset>
    `}get sources(){return e`
      <simple-toolbar-button
        id="browse"
        ?disabled="${this.disabled}"
        label="${this.t.upload}.."
        ?show-text-label="${this.responsiveSize.indexOf("s")<0}"
        icon="icons:file-upload"
        show-text-label
        @click="${this._handleBrowse}"
        controls="fieldset"
        part="browse"
      >
      </simple-toolbar-button>
      <simple-toolbar-button
        icon="image:camera-alt"
        ?disabled="${this.disabled}"
        label="${this.t.takePhoto}.."
        ?show-text-label="${this.responsiveSize.indexOf("s")<0}"
        @mousedown="${e=>e.preventDefault()}"
        @focus="${e=>e.preventDefault()}"
        @click="${this._handleCameraOption}"
        controls="fieldset"
        part="take-photo"
        ?hidden="${!navigator.mediaDevices||this.noCamera}"
      >
      </simple-toolbar-button>
      <simple-toolbar-button
        icon="hardware:keyboard-voice"
        ?disabled="${this.disabled}"
        label="${this.t.recordAudio}.."
        ?show-text-label="${this.responsiveSize.indexOf("s")<0}"
        @mousedown="${e=>e.preventDefault()}"
        @focus="${e=>e.preventDefault()}"
        @click="${this._handleAudioOption}"
        controls="fieldset"
        part="record-audio"
        ?hidden="${!navigator.mediaDevices||this.noVoiceRecord}"
      >
      </simple-toolbar-button>
    `}get fields(){return e`
      <div id="upload-options">
        <vaadin-upload
          capture=""
          class="option-${this.option}"
          form-data-name="file-upload"
          id="fileupload"
          @upload-before="${this._fileAboutToUpload}"
          @upload-response="${this._fileUploadResponse}"
          part="upload"
          ?nodrop="${this.disabled}"
        >
          <button
            ?disabled="${this.disabled}"
            id="add-hidden"
            slot="add-button"
          >
            ${this.t.upload}..
          </button>
          <div
            part="browse-area"
            ?hidden="${"selfie"==this.option||"audio"==this.option||this.hideInput}"
          >
            <simple-fields-url-combo
              id="url"
              ?autofocus="${this.autofocus}"
              autocomplete="both"
              value="${this.value||""}"
              label="URL"
              type="url"
              auto-validate=""
              part="url"
              ?disabled="${this.disabled}"
              ?always-expanded="${this.responsiveSize.indexOf("s")<0}"
              display-as="${this.responsiveSize.indexOf("l")>-1?"grid":""}"
              .itemsList="${this.itemsList}"
              @click="${e=>e.stopImmediatePropagation()}"
              @mousedown="${e=>e.stopImmediatePropagation()}"
              @focus="${e=>e.stopImmediatePropagation()}"
              @value-changed="${this.valueChanged}"
            >
            </simple-fields-url-combo>
          </div>
          <div id="upload">
            <span part="drop-area-text">${this.t.dropMediaHereOr}</span>
            ${this.sources}
          </div>
          <simple-toolbar-button
            id="cancel"
            icon="icons:clear"
            ?disabled="${this.disabled}"
            label="${this.t.cancel}"
            @mousedown="${e=>e.preventDefault()}"
            @focus="${e=>e.preventDefault()}"
            @click="${this._handleCancel}"
            controls="fieldset"
            slot="drop-label"
            part="cancel-media"
            ?hidden="${"selfie"!==this.option&&"audio"!==this.option}"
          >
          </simple-toolbar-button>
          <div
            id="camerahole"
            ?hidden="${"selfie"!==this.option}"
            part="camera"
            part="camera-preview"
          ></div>
          <div
            id="voicerecorder"
            ?hidden="${"audio"!==this.option}"
            part="voice-preview"
          ></div>
          ${this.desc}
        </vaadin-upload>
      </div>
    `}_handleCameraOption(e){e.preventDefault(),this.option="selfie",this._takeSelfie(e)}_handleAudioOption(e){e.preventDefault(),this.option="audio",this._voiceRecorder(e)}_handleCancel(e){e.preventDefault(),this.option="fileupload"}_handleBrowse(e){e.preventDefault(),this.shadowRoot.querySelector("#add-hidden").dispatchEvent(new CustomEvent("click",e))}valueChanged(e){this.value=e.detail.value}updated(e){super.updated&&super.updated(e),e.forEach(((e,i)=>{"value"==i&&this.dispatchEvent(new CustomEvent("value-changed",{detail:{value:this[i]}}))})),this.field&&this.__delayedFocus&&this.focus()}static get properties(){return{...super.properties,accept:{type:String},hideInput:{type:Boolean,attribute:"hide-input"},autocomplete:{type:String},autofocus:{type:Boolean},value:{type:String},option:{type:String},noCamera:{type:Boolean,attribute:"no-camera"},noVoiceRecord:{type:Boolean,attribute:"no-voice-record"},responsiveSize:{type:String,attribute:"responsive-size",reflect:!0},responsiveWidth:{type:Number,attribute:"responsive-width",reflect:!0},itemsList:{type:Object,attribute:"items-list"}}}get field(){if(this.shadowRoot)return"selfie"==this.option&&this.shadowRoot.querySelector("#cancel")||"audio"==this.option&&this.shadowRoot.querySelector("#cancel")?this.shadowRoot.querySelector("#cancel"):!!this.shadowRoot.querySelector("#url")&&this.shadowRoot.querySelector("#url")}focus(){this.field?(this.field.focus(),this.__delayedFocus=!1):this.__delayedFocus=!0}_fileAboutToUpload(e){this.dispatchEvent(new CustomEvent("upload-before",{bubbles:!0,cancelable:!0,composed:!1,detail:e.detail})),this.dispatchEvent(new CustomEvent("upload-response",{bubbles:!0,cancelable:!0,composed:!1,detail:e.detail}))}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),this.value?this.option="url":this.option="fileupload",globalThis.ResponsiveUtility.requestAvailability(),globalThis.dispatchEvent(new CustomEvent("responsive-element",{detail:{element:this,attribute:"responsive-size",relativeToParent:!0,sm:150,md:300,lg:600,xl:1200}}))}__newPhotoShowedUp(e){let i=new File([e.detail.raw],"headshot"+e.timeStamp+".jpg");this.shadowRoot.querySelector("#fileupload")._addFile(i)}__newAudioShowedUp(e){let i=new File([e.detail.value],"voice-recording-"+e.timeStamp+".mp3");this.shadowRoot.querySelector("#fileupload")._addFile(i),this.voice.remove(),setTimeout((()=>{this.voice=null}),0)}_takeSelfie(e){this.camera||import("../../simple-login/lib/simple-camera-snap.js").then((()=>{this.camera=globalThis.document.createElement("simple-camera-snap"),this.camera.autoplay=!0,this.camera.addEventListener("simple-camera-snap-image",this.__newPhotoShowedUp.bind(this)),this.shadowRoot.querySelector("#camerahole").appendChild(this.camera)}))}_voiceRecorder(e){this.voice||import("../../voice-recorder/voice-recorder.js").then((()=>{this.voice=globalThis.document.createElement("voice-recorder"),this.voice.addEventListener("voice-recorder-recording-blob",this.__newAudioShowedUp.bind(this)),this.voice.recording=!0,this.shadowRoot.querySelector("#voicerecorder").appendChild(this.voice)}))}_resolveObjectPath(e,i){return e.split(".").reduce((function(e,i){return e?e[i]:null}),i||self)}}customElements.define(SimpleFieldsUpload.tag,SimpleFieldsUpload);export{SimpleFieldsUpload};