import{LitElement as e,html as t,css as s}from"../../../lit/index.js";import{SimpleFieldsFieldBehaviors as i}from"./simple-fields-field.js";import{SimpleColors as a}from"../../simple-colors/simple-colors.js";import"./simple-tag.js";class SimpleFieldsTagList extends(i(a)){static get tag(){return"simple-fields-tag-list"}static get styles(){return[super.styles,s`
        :host {
          display: block;
          --simple-fields-tag-list-height: 24px;
        }
        #field-main-inner {
          align-items: center;
          flex-wrap: wrap;
        }
        simple-tag {
          flex: 0 1 auto;
          margin: calc(0.5 * var(--simple-fields-button-padding, 2px))
            var(--simple-fields-button-padding, 2px);
          height: var(--simple-fields-tag-list-height);
        }
        :host(.drop-possible) [part="option-inner"] {
          --simple-fields-accent-color: var(
            --simple-fields-tag-list-possible,
            var(--simple-colors-default-theme-accent-2, #eeffee)
          );
          background-color: var(--simple-fields-accent-color);
          outline: 2px dashed
            var(--simple-colors-default-theme-accent-12, #eeffee);
          outline-offset: 1px;
        }
        :host(.drag-focus) [part="option-inner"] {
          --simple-fields-accent-color: var(
            --simple-fields-tag-list-focus,
            var(--simple-colors-default-theme-accent-8, #44ff44)
          );
          background-color: var(--simple-fields-accent-color);
          outline: 2px dashed
            var(--simple-colors-default-theme-accent-10, #44ff44);
          outline-offset: 1px;
        }
        [part="option-inner"] {
          height: var(--simple-fields-tag-list-height);
        }
      `]}static get properties(){return{...super.properties,requiredMessage:{type:String},tagList:{type:Array,attribute:"tag-list"},value:{reflect:!0},label:{type:String},singleValueOnly:{type:Boolean,attribute:"single-value-only"}}}constructor(){super(),this.windowControllers=new AbortController,this.label="Tags",this.singleValueOnly=!1,this.value="",this.tagList=[],this.id=this._generateUUID(),this.addEventListener("dragleave",this._handleDragLeave),this.addEventListener("dragover",this._handleDragEnter),this.addEventListener("drop",this._handleDragDrop)}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),setTimeout((()=>{this._updateTaglist()}),0)}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"id"!==t||this.id||(this.id=this._generateUUID()),"value"===t&&this._fireValueChanged(),"tagList"===t&&this._fireTagListChanged()}))}_handleGlobalTagDrop(e){this.classList.remove("drop-possible")}_handleGlobalTagDrag(e){this.classList.add("drop-possible")}get prefixTemplate(){return t`
      ${super.prefixTemplate}
      <slot name="taglist">
        ${this.tagList.map((e=>t`
            <simple-tag
              cancel-button
              .data=${e}
              value="${e.term}"
              accent-color="${e.color}"
              @simple-tag-clicked="${this.removeTag}"
            ></simple-tag>
          `))}
      </slot>
    `}getInput(){return t`
      <span class="input-option" part="option-inner">
        <input
          @keydown="${this._handleKeydown}"
          @keyup="${this._handleKeyup}"
          ?autofocus="${this.autofocus}"
          .aria-descrbedby="${this.describedBy||""}"
          .aria-invalid="${this.error?"true":"false"}"
          @blur="${this._onFocusout}"
          @change="${this._handleFieldChange}"
          class="field box-input"
          ?disabled="${this.disabled}"
          @focus="${this._onFocusin}"
          ?hidden="${this.hidden}"
          id="${this.id}"
          @input="${this._handleFieldChange}"
          name="${this.id}"
          .placeholder="${this.placeholder||""}"
          ?readonly="${this.readonly}"
          ?required="${this.required}"
          tabindex="0"
          type="text"
          value="${this.value}"
          part="option-input"
        />
      </span>
    `}removeTag(e){this.tagList=[...this.tagList.filter((t=>t.term!==e.detail.value))]}_handleDragLeave(e){this.classList.remove("drag-focus"),this.classList.add("drop-possible")}_handleDragEnter(e){e.preventDefault(),this.classList.add("drag-focus"),this.classList.remove("drop-possible")}_handleDragDrop(e){if(e.preventDefault(),this.classList.remove("drop-possible"),this.classList.remove("drag-focus"),JSON.parse(e.dataTransfer.getData("text"))){let t=JSON.parse(e.dataTransfer.getData("text"));this.tagList=[...this.tagList.filter((e=>e.term!==t.term))];let s=this.tagList;s.push(t),this.tagList=[...s]}}_handleKeydown(e){"Enter"===e.key&&""!=this.shadowRoot.querySelector("input").value&&this._updateTaglist()}_handleKeyup(e){","===e.key&&""!=this.shadowRoot.querySelector("input").value&&this._updateTaglist()}_updateTaglist(){let e=this.shadowRoot.querySelector("input").value;e=e.replace(/,$/,"").trim(),this.tagList=[...this.tagList.filter((e=>e.term!==this.shadowRoot.querySelector("input").value&&""!=e.term&&null!==e.term))];let t=this.tagList;""!==e&&(this.singleValueOnly&&(t=[]),t.push({term:e,color:"grey"}),this.tagList=[...t]),this.shadowRoot.querySelector("input").value=""}get slottedFieldObserver(){}validate(){return!this.value&&this.required&&(this.error=!0,this.errorMessage=this.requiredMessage||"required"),!this.error}_fireValueChanged(){setTimeout((()=>{this._updateTaglist()}),0),this.dispatchEvent(new CustomEvent("value-changed",{bubbles:!1,cancelable:!1,composed:!1,detail:this}))}_fireTagListChanged(e){this.dispatchEvent(new CustomEvent("simple-fields-tag-list-changed",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}_onFocusout(e){super._onFocusout(e),""!=this.shadowRoot.querySelector("input").value&&this._updateTaglist()}_observeAndListen(e=!0){e?(this.addEventListener("click",this.focus),this.addEventListener("focusout",this._onFocusout),this.addEventListener("focusin",this._onFocusin)):(this.removeEventListener("click",this.focus),this.removeEventListener("focusout",this._onFocusout),this.removeEventListener("focusin",this._onFocusin))}connectedCallback(){super.connectedCallback(),globalThis.addEventListener("simple-tag-dragstart",this._handleGlobalTagDrag.bind(this),{signal:this.windowControllers.signal}),globalThis.addEventListener("simple-tag-drop",this._handleGlobalTagDrop.bind(this),{signal:this.windowControllers.signal})}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback()}}customElements.define(SimpleFieldsTagList.tag,SimpleFieldsTagList);export{SimpleFieldsTagList};