import{LitElement as e,html as t,css as i}from"../../../lit/index.js";import{SimpleFieldsContainerBehaviors as s}from"./simple-fields-container.js";import"../../code-editor/code-editor.js";import{normalizeEventPath as o}from"../../utils/utils.js";class SimpleFieldsCode extends(s(e)){static get tag(){return"simple-fields-code"}static get styles(){return[super.styles,i`
        #options {
          display: var(--simple-fields-radio-option-display, block);
          flex-wrap: var(--simple-fields-radio-option-flex-wrap, wrap);
        }
        code-editor {
          margin: 0;
          transition: height 0.5s ease-in-out;
          box-sizing: border-box;
          vertical-align: bottom;
        }
        code-editor:focus {
          outline: none;
        }
      `]}render(){return this.hasFieldSet?this.fieldsetTemplate:super.render()}static get properties(){return{...super.properties,autofocus:{type:Boolean},editorValue:{type:String,attribute:"editor-value"},focused:{type:Boolean,reflect:!0},fontSize:{type:Number,attribute:"font-size"},language:{type:String},mode:{type:Number},readonly:{type:Boolean,reflect:!0},requiredMessage:{type:String},theme:{type:String,reflect:!0},value:{reflect:!0}}}constructor(){super(),this.autofocus=!1,this.fontSize=14,this.id=this._generateUUID(),this.language="html",this.mode="html",this.readonly=!1}disconnectedCallback(){this.removeEventListener("click",(e=>this.focus())),super.disconnectedCallback()}updated(e){e.forEach(((e,t)=>{"id"!==t||this.id||(this.id=this._generateUUID()),"field"!==t||this.field||this._updateField(),"value"===t&&this._fireValueChanged()}))}get fieldMainTemplate(){return t`
      <div class="field-main" part="field-main">
        ${this.labelTemplate}
        <code-editor
          ?autofocus="${this.autofocus}"
          ?disabled="${this.disabled}"
          font-size="${this.fontSize}"
          editor-value="${this.editorValue||""}"
          theme="${this.theme||"auto"}"
          language="${this.language}"
          mode="${this.mode}"
          ?read-only="${this.readonly||this.disabled}"
          @value-changed="${this._onChange}"
          @focused-changed="${this._onFocusChange}"
          @code-editor-focus="${e=>1==this.focused}"
          @code-editor-blur="${e=>0==this.focused}"
          part="editor"
        >
        </code-editor>
        <input name="${this.id}" type="hidden" value="${this.value}" />
      </div>
    `}_onChange(e){var t=o(e)[0];t&&this.value!==t.value&&(this.value=t.value)}get slottedFieldObserver(){}validate(){return!this.value&&this.required&&(this.error=!0,this.errorMessage=this.requiredMessage||"required"),!this.error}_fireValueChanged(){this.dispatchEvent(new CustomEvent("value-changed",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}_onFocusChange(e){this.focused=e.detail.focused}_observeAndListen(e=!0){e?(this.addEventListener("click",this.focus),this.addEventListener("focusout",this._onFocusout),this.addEventListener("focusin",this._onFocusin)):(this.removeEventListener("click",this.focus),this.removeEventListener("focusout",this._onFocusout),this.removeEventListener("focusin",this._onFocusin))}_updateField(){this.field=this.shadowRoot&&this.shadowRoot.querySelector("code-editor")?this.shadowRoot.querySelector("code-editor"):void 0}_generateUUID(){return"ss-s-s-s-sss".replace(/s/g,Math.floor(65536*(1+Math.random())).toString(16).substring(1))}}customElements.define(SimpleFieldsCode.tag,SimpleFieldsCode);export{SimpleFieldsCode};