import{LitElement as e,html as t,css as i}from"../../../lit/index.js";import{SimpleFieldsFieldsetBehaviors as s}from"./simple-fields-fieldset.js";import{SimpleFieldsButtonStyles as d}from"./simple-fields-ui.js";import"../../simple-toolbar/lib/simple-toolbar-button.js";import"../../simple-icon/simple-icon.js";import"../../simple-icon/lib/simple-icons.js";import"./simple-fields-array-item.js";import"../../responsive-utility/responsive-utility.js";class SimpleFieldsArray extends(s(e)){static get tag(){return"simple-fields-array"}static get styles(){return[super.styles,...d,i`
        :host([expanded]) #expand::part(icon) {
          transform: rotate(90deg);
          transition: all 0.5s ease;
        }
        #item-fields {
          margin: var(--simple-fields-margin-small, 8px) 0;
          clear: both;
          z-index: 3;
        }
        #top {
          display: flex;
          align-items: flex-end;
          justify-content: flex-end;
        }
        #add {
          float: right;
        }
      `]}static get properties(){return{...super.properties,count:{type:Number},disableAdd:{type:Boolean,reflect:!0,attribute:"disable-add"},hideExpand:{type:Boolean,reflect:!0,attribute:"hide-expand"},hideReorder:{type:Boolean,reflect:!0,attribute:"hide-reorder"},hideDuplicate:{type:Boolean,reflect:!0,attribute:"hide-duplicate"},expanded:{type:Boolean,reflect:!0},responsiveSize:{type:String,attribute:"responsive-size",reflect:!0},__dragging:{type:Boolean}}}render(){return t`
      <fieldset part="fieldset">${this.legend}${this.fields}</fieldset>
    `}get fields(){return t`
      <div id="top" part="top">
        ${this.descriptionTemplate}
        <simple-toolbar-button
          id="expand"
          controls="item-fields"
          icon="more-vert"
          ?disabled="${this.disabled}"
          @click="${e=>this.toggle()}"
          ?toggled="${this.expanded}"
          ?hidden="${this.hideExpand}"
          toggles
          ?show-text-label="${"xs"!==this.responsiveSize}"
          label="${this.expanded?"Collapse All":"Expand All"}"
          part="expand"
        >
        </simple-toolbar-button>
      </div>
      <div id="item-fields" aria-live="polite" part="items">
        <slot></slot>
        <simple-toolbar-button
          id="add"
          icon="add"
          ?disabled="${this.disabled||this.disableAdd}"
          controls="item-fields"
          @click="${e=>this._handleAdd()}"
          part="add"
          icon="more-vert"
          ?toggled="${this.expanded}"
          toggles
          ?show-text-label="${"xs"!==this.responsiveSize}"
          label="Add Item"
        >
        </simple-toolbar-button>
      </div>
    `}constructor(){super(),this.hideExpand=!1,this.hideReorder=!1,this.hideDuplicate=!1,this.count=0,this.expanded=!1,this.disableAdd=!1,this.responsiveSize="sm"}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),globalThis.ResponsiveUtility.requestAvailability(),globalThis.dispatchEvent(new CustomEvent("responsive-element",{detail:{element:this,attribute:"responsive-size",relativeToParent:!0,sm:250,md:500,lg:1e3,xl:2e3}}))}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"expanded"===t&&this.querySelectorAll("simple-fields-array-item").forEach((e=>{e.expanded=this.expanded})),"hideDuplicate"===t&&this.querySelectorAll("simple-fields-array-item").forEach((e=>{e.hideDuplicate=this.hideDuplicate})),"hideReorder"===t&&this.querySelectorAll("simple-fields-array-item").forEach((e=>{e.hideReorder=this.hideReorder}))}))}buildItem(e){let t=globalThis.document.createElement("simple-fields-array-item");return t.id=e,t.hideReorder=this.hideReorder,t.hideDuplicate=this.hideDuplicate,t.expanded=this.expanded,t.innerHTML='\n      <slot name="sort"></slot>\n      <slot name="preview"></slot>\n      <slot></slot>',this.appendChild(t),t.addEventListener("remove",(e=>this._handleRemove(e))),t}_handleAdd(){this.dispatchEvent(new CustomEvent("add",{detail:this}))}_handleRemove(e){e.stopPropagation(),e.stopImmediatePropagation(),this.dispatchEvent(new CustomEvent("remove",{detail:e.detail}))}collapse(){this.toggle(!1)}expand(){this.toggle(!0)}focus(e){if(this.childNodes&&e)this.childNodes.length<e&&(e=this.childNodes.length-1),-1==e&&(e=0),0!=this.childNodes.length&&this.childNodes[e].focus();else if(this.shadowRoot){let e=this.childNodes?"expand":"add";this.shadowRoot.getElementById(e).focus()}}toggle(e=!this.expanded){this.expanded=e,this._handleToggle()}_handleToggle(){this.dispatchEvent(new CustomEvent("toggle",{detail:this})),this.expanded?this.dispatchEvent(new CustomEvent("expand",{detail:this})):this.dispatchEvent(new CustomEvent("collapse",{detail:this}))}}customElements.define(SimpleFieldsArray.tag,SimpleFieldsArray);export{SimpleFieldsArray};