import{LitElement as e,html as t,css as i}from"../../../lit/index.js";import{SimpleFieldsFieldsetBehaviors as o}from"./simple-fields-fieldset.js";import{SimpleFieldsButtonStyles as s}from"./simple-fields-ui.js";import"../../simple-icon/simple-icon.js";import"../../simple-icon/lib/simple-icons.js";import"../../simple-toolbar/lib/simple-toolbar-button.js";import"../../simple-toolbar/lib/simple-toolbar-menu.js";import"../../simple-toolbar/lib/simple-toolbar-menu-item.js";import"../../responsive-utility/responsive-utility.js";class SimpleFieldsArrayItem extends(o(e)){static get styles(){return[super.styles,...s,i`
        :host {
          padding: 0;
          border-radius: var(--simple-fields-border-radius, 2px);
          display: block;
          border: none;
          transform: rotate(0deg);
          transition: all 0.5s ease;
          z-index: 1;
          position: relative;
        }
        :host([disabled]) {
          opacity: 0.5;
        }
        :host([aria-expanded="true"]) {
          padding: var(--simple-fields-margin, 16px)
            var(--simple-fields-margin-small, 8px);
          outline: 1px solid var(--simple-fields-border-color-light, #ccc);
          transition: all 0.5s ease;
        }
        :host([error]) {
          outline: 1px solid var(--simple-fields-error-color, #b40000);
          transition: border 0.5s ease;
        }
        *[aria-controls="content"][disabled] {
          cursor: not-allowed;
        }
        #drag-handle {
          flex: 0 1 auto;
          position: relative;
          overflow: visible;
        }
        :host([hide-reorder]) #drag-handle {
          display: none;
        }
        #preview {
          flex: 1 0 auto;
          margin: 0;
          margin-right: calc(0 - var(--simple-fields-margin-small, 8px) / 2);
          margin-left: calc(50px + var(--simple-fields-margin-small, 8px) / 2);
          max-width: calc(
            100% - 72px - 2 * var(--simple-fields-margin-small, 8px) / 2
          );
        }
        :host([hide-reorder]) #preview {
          margin: 0 4px;
          max-width: unset;
        }
        #heading,
        .heading-inner {
          display: flex;
          justify-content: space-between;
          align-items: flex-start;
        }
        #content {
          overflow: hidden;
          max-height: 0;
        }
        :host #content-inner {
          display: flex;
          align-items: flex-end;
          justify-content: space-between;
          flex-wrap: wrap;
          overflow: hidden;
          max-height: 0;
          transition: max-height 0.75s ease;
        }
        :host([aria-expanded="true"]) #content {
          max-height: 20000vh;
          transition: max-height 0.75s ease;
        }
        :host([aria-expanded="true"]) #content-inner {
          max-height: 20000vh;
        }
        #content-inner > * {
          flex: 1 1 auto;
        }
        #copy-delete {
          display: flex;
          flex: 0 0 auto;
        }
        #copy,
        #remove {
          flex: 0 0 auto;
        }
        #expand {
          margin-left: calc(var(--simple-fields-margin-small, 8px) / 2);
        }
        #drag-handle {
          position: absolute;
          left: 2px;
          top: 2px;
          --simple-toolbar-button-white-space: normal !important;
        }
        :host([aria-expanded="true"]) #drag-handle {
          top: var(--simple-fields-margin, 16px);
          left: var(--simple-fields-margin-small, 8px);
        }
        #dropzone {
          height: 0px;
        }
        :host(.dragging) #heading {
          opacity: 0.5;
        }
        :host(.dragging) #content,
        :host(.dragging) #expand {
          display: none;
        }
        #content:hover,
        #content:focus-within,
        #content:hover #content-inner,
        #content:focus-within #content-inner {
          overflow: visible;
        }
        :host(.dragging) #preview,
        :host(.droppable) #preview {
          margin-left: calc(var(--simple-fields-margin-small, 8px) / 2);
        }
        :host(.dropzone) #dropzone {
          background-color: var(
            --simple-fields-button-focus-background-color,
            var(--simple-fields-accent-color-light, #d9eaff)
          );
          height: 80px;
        }

        :host([aria-expanded="true"]) #expand::part(icon) {
          transform: rotate(90deg);
          transition: all 0.5s ease;
        }
        ::slotted([slot="preview"]),
        ::slotted(*:first-child) {
          margin-top: 0;
        }
        ::slotted([slot="preview"]),
        ::slotted(*:last-child) {
          margin-bottom: 0;
        }
        :host(:hover),
        :host(:focus),
        :host(:focus-within) {
          z-index: 100000;
        }
        :host(.dropzone) {
          z-index: 1;
        }
        [hidden],
        :host(:first-child) #move-up-outer,
        :host(:last-child) #move-down-outer,
        :host(:first-child):last-child #drag-handle {
          display: none;
        }
      `]}render(){return t`
      <div id="dropzone"></div>
      <simple-toolbar-menu
        id="drag-handle"
        controls="${this.id}"
        icon="icons:reorder"
        label="Reorder this item"
        ?disabled="${this.disabled}"
        ?hidden="${this.__dropAccepts||this.__dragging||this.hideReorder}"
        part="drag"
        tooltip-direction="right"
        @mousedown="${e=>this.draggable="true"}"
        @mouseup="${e=>this.draggable="false"}"
      >
        <simple-toolbar-menu-item id="move-up-outer">
          <simple-toolbar-button
            id="move-up"
            align-horizontal="left"
            role="menuitem"
            icon="arrow-upward"
            show-text-label
            label="Up"
            @click="${this._moveUp}"
          >
          </simple-toolbar-button>
        </simple-toolbar-menu-item>
        <simple-toolbar-menu-item id="move-down-outer">
          <simple-toolbar-button
            align-horizontal="left"
            id="move-up"
            role="menuitem"
            icon="arrow-downward"
            show-text-label
            label="Down"
            @click="${this._moveDown}"
          >
          </simple-toolbar-button>
        </simple-toolbar-menu-item>
      </simple-toolbar-menu>
      <div id="heading" part="heading" .item="${this}">
        <div id="preview" part="preview"><slot name="preview"></slot></div>
        <simple-toolbar-button
          id="expand"
          controls="${this.id}"
          icon="more-vert"
          label="Toggle expand"
          ?disabled="${this.disabled}"
          @click="${this.toggle}"
          toggles
          ?toggled="${this.expanded}"
          part="expand"
          tooltip-direction="left"
        >
        </simple-toolbar-button>
      </div>
      <div id="content" part="content">
        <div id="content-inner" part="content-inner">
          <div><slot></slot></div>
          <div id="copy-delete">
            <simple-toolbar-button
              id="copy"
              ?hidden="${this.hideDuplicate}"
              controls="${(this.parentNode||{}).id}"
              icon="content-copy"
              label="Copy this item"
              ?disabled="${this.disabled}"
              @click="${this._handleCopy}"
              part="copy"
              tooltip-direction="left"
            >
            </simple-toolbar-button>
            <simple-toolbar-button
              id="confirm-remove"
              class="danger"
              tooltip-direction="left"
              align-horizontal="left"
              role="menuitem"
              controls="${this.id}"
              icon="delete"
              label="Remove"
              ?disabled="${this.disabled}"
              @click="${this._handleRemove}"
              part="confirm-remove"
            >
            </simple-toolbar-button>
          </div>
        </div>
      </div>
    `}static get tag(){return"simple-fields-array-item"}static get properties(){return{expanded:{type:Boolean,reflect:!0},hideReorder:{type:Boolean,reflect:!0,attribute:"hide-reorder"},hideDuplicate:{type:Boolean,reflect:!0,attribute:"hide-duplicate"},disabled:{type:Boolean,reflect:!0,attribute:"disabled"},draggable:{type:String,reflect:!0},preview:{type:Boolean},previewBy:{type:Array,reflect:!0,attribute:"preview-by"},responsiveSize:{type:String,attribute:"responsive-size",reflect:!0},__dragging:{type:Boolean},__dropAccepts:{type:Object},__prev:{type:Object},__next:{type:Object}}}constructor(){super(),this.hideReorder=!1,this.hideDuplicate=!1,this.disabled=!1,this.draggable="truest",this.previewBy=[],this.expanded=!1,this.responsiveSize="sm",this.addEventListener("dragenter",this._dragEnter),this.addEventListener("dragleave",this._dragLeave),this.addEventListener("dragover",this._dragMoving),this.addEventListener("dragstart",this._dragStart),this.addEventListener("dragend",this._dragEnd),this.addEventListener("drop",this._dragDrop)}get isArrayItem(){return!0}_dragMoving(e){this.__dragMoving=!0,e.preventDefault()}_dragEnd(e){[...this.parentNode.childNodes].forEach((e=>{e.isArrayItem&&e._setDropzone(!1)})),this._setDragging(!1)}_dragStart(e){let t=this.shadowRoot.querySelector("#heading");e.dataTransfer.setDragImage(t,0,0),this._setDragging(),e.stopPropagation(),e.stopImmediatePropagation()}_dragEnter(e){this._setDropzone()}_dragLeave(e){this._setDropzone(!1)}_dragDrop(e){this._moveBefore(e,this.__dropAccepts,this)}_moveUp(e){let t=this.previousElementSibling;t&&this._moveBefore(e,this,t)}_moveDown(e){let t=this.nextElementSibling;t&&this._moveBefore(e,this,t.nextElementSibling)}_moveBefore(e,t,i){!this.parentNode.disabled&&t&&(i?this.parentNode.insertBefore(t,i):this.parentNode.append(t),[...this.parentNode.childNodes].forEach((e=>{e.isArrayItem&&e._setDragging(!1)})),this.dispatchEvent(new CustomEvent("reorder",{bubbles:!0,cancelable:!0,composed:!1,detail:this.parentNode})))}_setDragging(e=!0){this.parentNode.disabled||(this.__dragging=e),e?([...this.parentNode.childNodes].forEach((e=>{e!==this&&e.isArrayItem&&(e.__dropAccepts=this,e.classList.add("droppable"))})),this.classList.add("dragging")):([...this.parentNode.childNodes].forEach((e=>{e!==this&&e.isArrayItem&&(e.__dropAccepts=void 0,e.classList.remove("droppable"))})),this.classList.remove("dragging"))}_setDropzone(e=!0){e&&!this.__dragging&&this.__dropAccepts?this.classList.add("dropzone"):this.classList.remove("dropzone")}connectedCallback(){super.connectedCallback(),setTimeout((()=>{this.dispatchEvent(new CustomEvent("added",{bubbles:!0,cancelable:!0,composed:!1,detail:this}))}),0)}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),globalThis.ResponsiveUtility.requestAvailability(),globalThis.dispatchEvent(new CustomEvent("responsive-element",{detail:{element:this,attribute:"responsive-size",relativeToParent:!0,sm:250,md:500,lg:1e3,xl:2e3}}))}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"error"!==t&&"expanded"!==t||this.setAttribute("aria-expanded",this.error||this.expanded)}))}get slots(){let e={};return this.previewBy.forEach((t=>e[t]="preview")),e}toggle(){this.expanded=!this.expanded}_handleCopy(){this.dispatchEvent(new CustomEvent("copy",{bubbles:!0,cancelable:!0,composed:!1,detail:this}))}_handleRemove(){this.dispatchEvent(new CustomEvent("remove",{bubbles:!0,cancelable:!0,composed:!1,detail:this}))}disconnectedCallback(){this.dispatchEvent(new CustomEvent("removed",{bubbles:!0,cancelable:!0,composed:!1,detail:this})),super.disconnectedCallback()}}customElements.define(SimpleFieldsArrayItem.tag,SimpleFieldsArrayItem);export{SimpleFieldsArrayItem};