/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../lit/index.js";import{remoteLinkBehavior as o}from"../utils/lib/remoteLinkBehavior.js";import{activeStateBehavior as i}from"../utils/lib/activeStateBehavior.js";import{DDD as r,DDDPulseEffectSuper as a}from"../d-d-d/d-d-d.js";import"../simple-icon/lib/simple-icon-lite.js";class SimpleCta extends(a(i(o(r)))){static get styles(){return[super.styles,e`
        /* With data-primary & data-accent applied, abstract to just
        * hidden (display: none)
        * transparent (no background) 
        * light (invert primary & accent)
        * hotline (uppercase, italic)
        */

        :host {
          display: inline-block;
          width: fit-content;
          height: fit-content;
          margin: var(--ddd-spacing-4) 0 0;
          border-radius: var(--ddd-radius-xs);
          --component-color: var(
            --lowContrast-override,
            var(
              --ddd-theme-accent,
              var(--ddd-theme-bgContrast, var(--ddd-theme-default-white))
            )
          );
          --component-background-color: var(
            --ddd-theme-primary,
            var(--ddd-theme-default-link)
          );
          --component-border-color: var(--component-color);
        }

        :host(:not([saturate]):hover),
        :host(:not([saturate]):focus-within),
        :host(:not([saturate]):active) {
          --component-color: var(
            --ddd-theme-primary,
            var(--ddd-theme-default-link)
          );
          --component-border-color: var(--component-color);
          --component-background-color: var(
            --lowContrast-override,
            var(--ddd-theme-accent, var(--ddd-theme-bgContrast, white))
          );
        }

        :host([hidden]) {
          display: none;
        }

        :host([light]) {
          --component-color: var(
            --ddd-theme-primary,
            var(--ddd-theme-default-link)
          );
          --component-border-color: var(--component-color);
          --component-background-color: var(
            --lowContrast-override,
            var(
              --ddd-theme-accent,
              var(--ddd-theme-bgContrast, var(--ddd-theme-default-white))
            )
          );
        }
        :host([light]:focus-within),
        :host([light]) a:hover,
        :host([light]) a:active {
          --component-color: var(
            --lowContrast-override,
            var(--ddd-theme-accent, var(--ddd-theme-bgContrast, white))
          );
          --component-border-color: var(--component-color);
          --component-background-color: var(
            --ddd-theme-primary,
            var(--ddd-theme-default-link)
          );
        }

        :host([hotline]) .btn {
          text-transform: uppercase;
          font-style: italic;
          font-weight: var(--ddd-font-weight-black);
        }

        a,
        a:any-link,
        a:link,
        a:visited {
          display: block;
          text-decoration: none;
          box-sizing: border-box;
        }

        :host(:focus-within),
        a:hover,
        a:active {
          text-decoration: none;
        }

        .btn {
          justify-content: center;
          align-items: center;
          cursor: pointer;
          display: flex;
          text-decoration: none;
          height: fit-content;
          width: max-content;
          border-radius: var(--ddd-radius-xs);
          color: var(--component-color, var(--ddd-theme-default-link));
          border: var(--ddd-border-sm);
          border-color: var(
            --component-border-color,
            var(--ddd-theme-default-link)
          );
          padding: var(
            --simple-cta-button-padding,
            0.75rem 0.75rem 0.75rem 1.5rem
          );
          transition: all 0.3s ease-in-out;
          transition-delay: 0.1s;
          background-color: var(--component-background-color, transparent);
          font-weight: var(--ddd-font-weight-black);
        }

        .hideIcon {
          padding: 0.75rem 1.5rem;
        }

        .large {
          padding: 1rem 2.75rem 1rem 3.25rem;
        }
        .large.hideIcon {
          padding: 1rem 3.25rem;
        }

        .icon {
          display: inline-flex;
          --simple-icon-width: var(--simple-cta-font-size, var(--ddd-icon-3xs));
          --simple-icon-height: var(
            --simple-cta-font-size,
            var(--ddd-icon-3xs)
          );
        }

        label {
          font-weight: var(--ddd-font-weight-black);
        }

        :host([saturate]:hover) .btn,
        :host([saturate]:focus-within) .btn,
        :host([saturate]:active) .btn {
          filter: saturate(200%);
        }

        :host([data-primary="19"][data-accent="11"]) .btn,
        :host([data-primary="11"][data-accent="11"]) .btn {
          --ddd-theme-accent: black;
        }
      `]}render(){return t` <a
      href="${this.link?this.link:"#"}"
      role="button"
      part="simple-cta-link"
      @click="${this._clickCard}"
    >
      <span
        class="btn ${this.large?"large":""} ${this.hideIcon?"hideIcon":""} "
        ><span class="label">${this.label}</span><slot></slot>${this.hideIcon?"":t`<simple-icon-lite
              class="icon"
              icon="${this.icon}"
            ></simple-icon-lite>`}</span
      >
    </a>`}static get haxProperties(){return{type:"element",canScale:!0,canEditSource:!0,gizmo:{title:"Call to action",description:"A simple button with a link to take action.",icon:"image:crop-16-9",color:"orange",tags:["Layout","marketing","button","link","url","design","cta"],handles:[{type:"link",source:"link",title:"label"}],meta:{author:"HAXTheWeb core team"}},settings:{configure:[{property:"label",title:"Label",description:"Link label",inputMethod:"textfield",required:!0},{property:"link",title:"Link",description:"Enter a link to any resource",inputMethod:"haxupload",noVoiceRecord:!0,noCamera:!0,required:!0},{property:"accentColor",title:"Accent Color",description:"An optional accent color.",inputMethod:"colorpicker",icon:"editor:format-color-fill"},{property:"hideIcon",title:"Hide icon",description:"Hide the icon used to accent text",inputMethod:"boolean"}],advanced:[{property:"icon",title:"Icon",description:"Action link icon",inputMethod:"iconpicker"}]},saveOptions:{unsetAttributes:["colors","element-visible"]},demoSchema:[{tag:"simple-cta",properties:{label:"Click to learn more",link:"https://haxtheweb.org/"},content:""}]}}static get properties(){return{...super.properties,link:{type:String},label:{type:String},icon:{type:String},editMode:{type:Boolean},hideIcon:{type:Boolean,attribute:"hide-icon"},large:{type:Boolean,reflect:!0},light:{type:Boolean,reflect:!0},hotline:{type:Boolean,reflect:!0},saturate:{type:Boolean,reflect:!0},disabled:{type:Boolean,reflect:!0}}}static get tag(){return"simple-cta"}constructor(){super(),this.link=null,this.icon="icons:chevron-right",this.hideIcon=!1,this.label=null,this.hotline=null,this.large=null,this.light=null,this.disabled=!1,this.saturate=null,this.querySelector&&this.querySelector("a")&&(this.link=this.querySelector("a").getAttribute("href"),this.label=this.querySelector("a").innerText,this.innerHTML=null)}haxHooks(){return{editModeChanged:"haxeditModeChanged",activeElementChanged:"haxactiveElementChanged"}}haxeditModeChanged(t){this.editMode=t}_clickCard(t){this.editMode&&(t.preventDefault(),t.stopPropagation(),t.stopImmediatePropagation())}haxactiveElementChanged(t,e){return this.editMode=e,!1}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.remoteLinkTarget=this.shadowRoot.querySelector("a")}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"link"==e&&(this.remoteLinkURL=this[e])}))}}customElements.define(SimpleCta.tag,SimpleCta);export{SimpleCta};