/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as s}from"../../../../lit/index.js";import{SimpleColors as e}from"../../simple-colors.js";class simpleColorsSwatches extends e{static get styles(){return[super.styles,s`
        :host {
          display: block;
          margin: 15px 0;
        }
        :host([hidden]) {
          display: none;
        }
        :host simple-modal-template {
          --simple-modal-titlebar-color: var(--simple-colors-swatch-contrast);
          --simple-modal-titlebar-background: var(--simple-colors-swatch-color);
        }
        :host .row {
          display: flex;
          align-items: stretch;
        }
        :host button {
          width: calc(8% - 6px);
          height: 80px;
          margin: 3px;
          border: 1px solid black;
          border-radius: 3px;
          padding: 0;
          display: flex;
          flex-direction: column;
          justify-content: flex-end;
          align-items: stretch;
        }
        :host button div {
          margin: 0;
          padding: 2px;
          font-size: 10px;
          background: black;
          color: white;
          width: calc(100% - 4px);
        }
        :host button:focus,
        :host button:hover {
          opacity: 0.7;
          cursor: pointer;
        }
      `]}render(){return t`
      <div>
        <p>Click on the swatches above to learn more.</p>
        <div class="rows">
          ${Object.keys(this.colors).map((s=>t`
              <div class="row">
                ${this.colors.grey.map(((e,o)=>t`
                    <button
                      id="${this._getId(s,o)}"
                      controls="swatchinfo"
                      style="background-color: ${this.colors[s][o]};"
                      title="${this._getTitle(s,o)}"
                      @click="${t=>this._handleClick(s,o)}"
                    >
                      <div>${this._getTitle(s,o)}</div>
                    </button>
                  `))}
              </div>
            `))}
        </div>
        <simple-modal-template id="modal" title="${this.swatchName}">
          <p slot="content">
            <simple-colors-swatch-info
              swatch-id="${this.swatchId}"
              swatch-name="${this.swatchName}"
            >
            </simple-colors-swatch-info>
          </p>
        </simple-modal-template>
      </div>
    `}static get properties(){return{swatchId:{attribute:"swatch-id",type:String},swatchName:{attribute:"swatch-name",type:String}}}static get tag(){return"simple-colors-swatches"}updated(t){t.forEach(((t,s)=>{"swatchId"===s&&this.shadowRoot.querySelector("#modal")&&this.shadowRoot.querySelector("#modal").openModal&&this.shadowRoot.querySelector("#modal").openModal(this.shadowRoot.querySelector("#"+this.swatchId))}))}constructor(){super(),this.swatchId="grey_0",this.swatchName="grey-1",import("./simple-colors-swatch-info.js"),import("../../../simple-modal/lib/simple-modal-template.js")}_getTitle(t,s){return`${t}-${this._getShade(s)}`}_getId(t,s){return`${t}_${s}`}_getShade(t){return parseInt(t)+1}_handleClick(t,s){this.swatchId=this._getId(t,s),this.swatchName=this._getTitle(t,s)}}export{simpleColorsSwatches};customElements.define(simpleColorsSwatches.tag,simpleColorsSwatches);