/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../../../lit/index.js";import{SimpleColors as s}from"../../simple-colors.js";class simpleColorsSwatchInfo extends s{static get styles(){return[super.styles,e`
        :host {
          display: block;
          margin: 15px 0;
        }
        :host([hidden]) {
          display: none;
        }
        :host table {
          width: 100%;
          border: 1px solid black;
          border-radius: 3px;
          border-collapse: collapse;
          margin: 0 0 15px;
        }
        :host table caption {
          font-weight: bold;
          background-color: #222;
          color: white;
        }
        :host table th {
          background-color: #e0e0e0;
        }
        :host table caption,
        :host table th,
        :host table td {
          padding: 5px;
          border: 1px solid black;
          text-align: left;
          line-height: 160%;
        }
        :host table td span {
          padding: 5px;
          white-space: nowrap;
          margin: 5px 0;
        }
      `]}render(){return t`
      <table
        summary="Each row represents a CSS variable or class with a description of what it does without the dark attribute and with the attribute."
      >
        <caption>
          CSS Variables and Classes for ${this.swatchName}
        </caption>
        <thead>
          <tr>
            <th scope="col">Variable Name</th>
            <th scope="col">Color</th>
            <th scope="col">With <tt>dark</tt> Attribute</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <th scope="row">
              --simple-colors-default-theme-${this.swatchName}
            </th>
            <td style="${this._getBg(this.swatchId)}">default color</td>
            <td style="${this._getInverseBg(this.swatchId)}">inverted color</td>
          </tr>
          <tr>
            <th scope="row">--simple-colors-fixed-theme-${this.swatchName}</th>
            <td style="${this._getBg(this.swatchId)}">default color</td>
            <td style="${this._getBg(this.swatchId)}">fixed color</td>
          </tr>
        </tbody>
      </table>

      <table
        summary="A list of colors that meet WCAG 2.0 AA contrast requirements. Each contains all the contrasting shades for a given color, based on whether or not the text is regular or large."
      >
        <caption>
          WCAG 2.0 AA Contrast with ${this.swatchName}
        </caption>
        <thead>
          <tr>
            <th scope="col">Color Name</th>
            <th scope="col">Regular Text</th>
            <th scope="col">Large Text*</th>
          </tr>
        </thead>
        <tbody>
          ${this._getOptions(this.colors).map((e=>t`
              <tr>
                <th scope="row">${e}</th>
                <td>
                  ${this._getAa(this.swatchId,e).map((s=>t`
                      <span
                        class="contrast"
                        style="${this._getContrastBg(e,s)}"
                        >${e}-${s}</span
                      >
                    `))}
                </td>
                <td>
                  ${this._getAaLarge(this.swatchId,e).map((s=>t`
                      <span
                        class="contrast"
                        style="${this._getContrastBg(e,s)}"
                        >${e}-${s}</span
                      >
                    `))}
                </td>
              </tr>
            `))}
        </tbody>
      </table>
      <p>
        <small
          >* Large text is defined as bold text at least 14pt or normal text at
          least 18pt</small
        >
      </p>
    `}constructor(){super(),this.swatchId="grey_0",this.swatchName="grey-1"}static get properties(){return{swatchId:{attribute:"swatch-id",type:String,reflect:!0},swatchName:{attribute:"swatch-name",type:String,reflect:!0}}}static get tag(){return"simple-colors-swatch-info"}_getAa(t,e,s=!1){let a=t.split("_"),r=parseInt(a[1]);return this.getContrastingShades(!1,a[0],r,e)}_getAaLarge(t,e){return this._getAa(t,e,!0)}_getBg(t,e=!1){let s=this._getColors(t,e);return"background: "+s[0]+"; color: "+s[1]+";"}_getInverseBg(t){return this._getBg(t,!0)}_getOptions(t){return Object.keys(t)}_getContrastBg(t,e){return this._getBg(t+"_"+(parseInt(e)-1))}_getColors(t,e=!1){let s=t.split("_"),a=e?11-parseInt(s[1]):parseInt(s[1]);return[this.colors[s[0]][a],this.colors.grey[a>5?0:11]]}}export{simpleColorsSwatchInfo};customElements.define(simpleColorsSwatchInfo.tag,simpleColorsSwatchInfo);