import{html as t,css as e}from"../../../lit/index.js";import{SimpleColors as i}from"../../simple-colors/simple-colors.js";class SimpleBlogOverview extends i{static get styles(){return[super.styles,e`
        :host {
          display: block;
          outline: none;
          text-transform: none;
        }
        div.card {
          box-shadow: 0 5px 5px rgba(0, 0, 0, 0.7);
          padding: 32px 16px;
          margin: 0;
          min-width: unset;
          width: 100%;
          background-color: transparent;
        }
        .post-title {
          letter-spacing: -0.32px;
          font-weight: 700;
          font-style: normal;
          display: block;
          font-size: 28px;
          line-height: 1.1;
          margin: 0;
        }
        .post-title a {
          text-decoration: none;
          color: #333332;
        }
        .post-excerpt,
        simple-datetime {
          letter-spacing: -0.32px;
          font-weight: 300;
          font-style: normal;
          font-size: 16px;
          line-height: 1.3;
          color: var(--simple-colors-default-theme-grey-10);
        }
        .post-excerpt p {
          text-transform: none;
        }
        :host([elevation="2"]) .post-excerpt,
        :host([elevation="2"]) simple-datetime {
          color: var(--simple-colors-default-theme-grey-12);
          box-shadow: 0 10px 10px rgba(0, 0, 0, 0.7);
        }
        .post-meta {
          font-size: 14px;
          color: #b3b3b1;
          line-height: 30px;
        }
        a,
        a:visited,
        a:hover,
        a:focus,
        a:active {
          color: inherit;
        }
      `]}static get tag(){return"simple-blog-overview"}constructor(){super(),this.elevation=0,import("../../simple-datetime/simple-datetime.js"),setTimeout((()=>{this.addEventListener("mousedown",this.tapEventOn.bind(this)),this.addEventListener("mouseover",this.tapEventOn.bind(this)),this.addEventListener("mouseout",this.tapEventOff.bind(this)),this.addEventListener("focusin",this.tapEventOn.bind(this)),this.addEventListener("focusout",this.tapEventOff.bind(this))}),0)}render(){return t`
      <a href="${this.link}" itemprop="url" title="${this.title}">
        <div class="card">
          <article
            class="post"
            itemtype="http://schema.org/BlogPosting"
            role="article"
          >
            <div class="article-item">
              <header class="post-header">
                <h3 class="post-title" itemprop="name">${this.title}</h3>
              </header>
              <section class="post-excerpt" itemprop="description">
                <p>${this.description}</p>
              </section>
              <div class="post-meta">
                <simple-datetime
                  format="M jS, Y"
                  timestamp="${this.changed}"
                  unix=""
                ></simple-datetime>
              </div>
            </div>
          </article>
        </div>
      </a>
    `}static get properties(){return{...super.properties,itemId:{type:String,reflect:!0,attribute:"item-id"},title:{type:String},body:{type:String},link:{type:String},changed:{type:Number},elevation:{type:Number,reflect:!0}}}tapEventOn(t){this.elevation=2}tapEventOff(t){this.elevation=0}}customElements.define(SimpleBlogOverview.tag,SimpleBlogOverview);export{SimpleBlogOverview};