import{LitElement as e,html as i,css as t,svg as d}from"../../lit/index.js";import{SchemaBehaviors as r}from"../schema-behaviors/schema-behaviors.js";import{lazyImageLoader as a}from"../lazy-image-helpers/lazy-image-helpers.js";import{I18NMixin as s}from"../i18n-manager/lib/I18NMixin.js";import"../simple-icon/simple-icon.js";import"../simple-icon/lib/simple-icons.js";import"../simple-icon/lib/simple-icon-button.js";import{DDD as o}from"../d-d-d/d-d-d.js";class SelfCheck extends(s(a(r(o)))){constructor(){super(),this.correct=!1,this.alt="",this.image="",this.question="",this.accentColor="blue",this.title="Self-Check",this.fullWidthImage=!1,this.t={revealAnswer:"Reveal Answer",close:"Close",moreInformation:"More information"},this.registerLocalization({context:this,basePath:import.meta.url,locales:["he","ja","es"]})}static get styles(){return[super.styles,t`
        :host {
          display: block;
          margin: var(--ddd-spacing-4) 0;
        }
        :host([hidden]),
        *[hidden] {
          display: none !important;
        }

        div.card {
          overflow: hidden;
          container-type: inline-size;
          container-name: card;
          border: var(--ddd-border-xs);
          border-radius: var(--ddd-radius-lg);
          box-shadow: var(--ddd-boxShadow-sm);
        }

        simple-icon-button {
          display: flex;
          --simple-icon-width: var(--ddd-icon-sm);
          --simple-icon-height: var(--ddd-icon-sm);
          height: var(--ddd-icon-xl);
          width: var(--ddd-icon-xl);
          margin: 0 var(--ddd-spacing-4) 0 var(--ddd-spacing-3);
          padding: var(--ddd-spacing-1);
        }

        .check_button {
          display: flex;
          justify-content: flex-end;
        }
        :host([link]) .close_button {
          display: flex;
          justify-content: space-between;
          align-items: center;
        }
        .close_button {
          display: flex;
          justify-content: flex-end;
        }

        simple-icon#questionmark {
          --simple-icon-width: var(--ddd-icon-lg);
          --simple-icon-height: var(--ddd-icon-lg);
          margin: 0 var(--ddd-spacing-4) 0 var(--ddd-spacing-3);
          padding: var(--ddd-spacing-2);
          color: var(
            --ddd-component-self-check-title-color,
            var(
              --ddd-theme-font-color,
              var(--simple-colors-default-theme-accent-1, #000)
            )
          );
        }

        .heading {
          display: flex;
          align-items: center;
          text-transform: uppercase;
          font-size: var(--ddd-font-size-ms);
          font-weight: var(--ddd-font-weight-medium);
          color: var(
            --ddd-component-self-check-title-color,
            var(
              --ddd-theme-font-color,
              var(--simple-colors-default-theme-accent-1, #000)
            )
          );
        }

        #header_wrap {
          background-color: var(
            --ddd-component-self-check-title-background,
            var(
              --ddd-theme-accent,
              var(--simple-colors-default-theme-accent-8, #fff)
            )
          );
          display: flex;
          align-items: center;
          margin: calc(var(--ddd-spacing-7) * -1) 0 0;
          padding: 0 var(--ddd-spacing-3);
        }

        #question_wrap {
          color: var(
            --ddd-component-self-check-question-text,
            var(--ddd-theme-default-coalyGray)
          );
          background-color: var(
            --ddd-component-self-check-question-background,
            var(--ddd-theme-default-white)
          );
          position: relative;
        }

        .question {
          display: grid;
          grid-template-columns: 1fr 0.1fr;
          font-size: var(--ddd-theme-body-font-size);
          line-height: var(--ddd-lh-120);
          padding: var(--ddd-spacing-5) var(--ddd-spacing-3)
            var(--ddd-spacing-5) var(--ddd-spacing-6);
        }

        :host([correct]) .question {
          display: none;
        }

        #answer_wrap {
          visibility: hidden;
          opacity: 0;
          color: var(--ddd-component-self-check-answer-text, #000);
          background-color: var(
            --ddd-component-self-check-answer-background,
            var(--ddd-theme-default-successLight)
          );
          width: 100%;
          top: 0;
          left: calc(100%);
          transition: all 0.3s ease-in-out;
          position: absolute;
        }

        :host([correct]) #answer_wrap {
          visibility: visible;
          opacity: 1;
          position: relative;
          left: 0;
        }

        .answer {
          display: grid;
          grid-template-columns: 1fr 0.1fr;
          font-size: var(--ddd-font-size-3xs);
          padding: var(--ddd-spacing-5) var(--ddd-spacing-3)
            var(--ddd-spacing-5) var(--ddd-spacing-6);
          line-height: var(--ddd-lh-120);
        }

        #quote_start {
          display: inline-flex;
          transform: rotateY(180deg);
        }

        #quote_end {
          display: inline-flex;
        }

        .triangle {
          width: 0;
          height: 0;
          border-left: var(--ddd-spacing-6) solid transparent;
          border-right: var(--ddd-spacing-6) solid transparent;
          border-bottom: var(--ddd-spacing-6) solid
            var(
              --ddd-component-self-check-title-background,
              var(
                --ddd-theme-accent,
                var(--simple-colors-default-theme-accent-8, #fff)
              )
            );
          position: relative;
          top: calc(var(--ddd-spacing-5) * -1);
          left: var(--ddd-spacing-9);
        }

        .more_info {
          display: inline;
        }

        .more_info a:hover {
          text-decoration: none;
        }
        .image-wrap {
          max-height: 400px;
          overflow: hidden;
          min-height: 20px;
        }
        ::slotted([slot="heading"]) {
          margin: 0;
        }
        ::slotted(p:first-child) {
          margin-top: 0;
        }
        ::slotted(p:last-child) {
          margin-top: 0;
        }

        .r-circle {
          border-radius: var(--ddd-radius-circle);
        }

        @container card (width < 585px) {
          #header_wrap {
            margin: calc(var(--ddd-spacing-9) * -1) 0 0;
          }
        }
        @container card (width > 790px) {
          #header_wrap {
            margin: calc(var(--ddd-spacing-8) * -1) 0 0;
          }
          .image-wrap {
            max-height: 600px;
          }
        }
      `]}render(){return i`
      <div class="card">
        <div class="image-wrap">
          ${this.image?i` ${this.renderSVGLoader()}
                <img
                  src="${this.image}"
                  alt="${this.alt}"
                  aria-describedby="${this.describedBy||""}"
                  loading="lazy"
                />`:""}
        </div>
        <div class="triangle"></div>
        <div id="header_wrap">
          <simple-icon
            class="r-circle"
            id="questionmark"
            icon="icons:help"
            ?dark="${!this.dark}"
            contrast="4"
          ></simple-icon>
          <div class="heading" id="title">
            <slot name="heading">${this.title}</slot>
          </div>
        </div>
        <div id="question_wrap">
          <div
            class="question"
            aria-hidden="${this.correct?"true":"false"}"
          >
            <slot name="question"></slot>
            <div class="check_button">
              <simple-icon-button
                controls="answer_wrap"
                label="${this.t.revealAnswer}"
                id="checkBtn"
                class="check-btn"
                icon="image:remove-red-eye"
                @click="${this.openAnswer}"
              ></simple-icon-button>
              <simple-tooltip aria-hidden="true" for="checkBtn" position="left">
                ${this.t.revealAnswer}
              </simple-tooltip>
            </div>
          </div>
          <div
            id="answer_wrap"
            aria-hidden="${this.correct?"false":"true"}"
            aria-live="polite"
          >
            <div class="answer">
              <user-action track="visibility">
                <slot></slot>
              </user-action>
              <div class="close_button">
                <simple-icon-button
                  label="${this.t.close}"
                  id="closeBtn"
                  icon="icons:close"
                  @click="${this.openAnswer}"
                >
                </simple-icon-button>
                <simple-tooltip
                  aria-hidden="true"
                  for="closeBtn"
                  position="left"
                >
                  ${this.t.close}
                </simple-tooltip>
              </div>
              ${this.link?i`
                    <div class="more_info">
                      <user-action track="click" every="every"
                        ><a href="${this.link}" target="_blank" rel="noopener"
                          >${this.t.moreInformation}..</a
                        ></user-action
                      >
                    </div>
                  `:""}
            </div>
          </div>
        </div>
      </div>
    `}updated(e){super.updated&&super.updated(e),e.forEach(((e,i)=>{"elementVisible"==i&&this.elementVisible&&(import("../user-action/user-action.js"),import("../simple-tooltip/simple-tooltip.js"))}))}static get tag(){return"self-check"}static get properties(){return{...super.properties,title:{type:String},question:{type:String},image:{type:String,reflect:!0},alt:{type:String,reflect:!0},describedBy:{type:String,attribute:"described-by"},link:{type:String},correct:{type:Boolean,reflect:!0}}}haxHooks(){return{activeElementChanged:"haxactiveElementChanged"}}haxactiveElementChanged(e,i){let t=this.shadowRoot.querySelector("#title");return i?t.setAttribute("contenteditable",!0):(t.removeAttribute("contenteditable"),this.title=t.innerText),!1}openAnswer(e){this.correct=!this.correct}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}customElements.define(SelfCheck.tag,SelfCheck);export{SelfCheck};