/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as o,css as l}from"../../lit/index.js";import"../simple-icon/lib/simple-icons.js";import"../simple-icon/lib/simple-icon-button-lite.js";class ScrollButton extends t{constructor(){super(),this.icon="icons:expand-less",this.t={backToTop:"Back to top"},globalThis.dispatchEvent(new CustomEvent("i18n-manager-register-element",{detail:{context:this,namespace:"scroll-button",localesPath:new URL("./locales/scroll-button.es.json",import.meta.url).href+"/../",updateCallback:"render",locales:["es"]}})),this._label=this.t.backToTop,this.label="",this.position="top",import("../simple-tooltip/simple-tooltip.js")}static get tag(){return"scroll-button"}static get styles(){return[l`
        :host {
          display: block;
          --scroll-button-z-index: 99;
          z-index: var(--scroll-button-z-index);
        }

        :host([hidden]) {
          display: none;
        }

        simple-icon-button-lite {
          background-color: var(
            --scroll-button-background-color,
            rgba(0, 0, 0, 0.6)
          );
          color: var(--scroll-button-color, white);
        }

        simple-icon-button-lite:hover,
        simple-icon-button-lite:active,
        simple-icon-button-lite:focus {
          color: var(--scroll-button-background-color, rgba(0, 0, 0, 1));
          background-color: var(--scroll-button-color, white);
        }

        simple-tooltip {
          --simple-tooltip-background: var(
            --scroll-button-tooltip-background-color,
            #000000
          );
          --simple-tooltip-opacity: 1;
          --simple-tooltip-text-color: var(
            --scroll-button-tooltip-color,
            #ffffff
          );
          --simple-tooltip-delay-in: 0;
          --simple-tooltip-border-radius: 0;
        }
      `]}updated(t){super.updated&&super.updated(t),t.forEach(((t,o)=>{"t"===o&&""===this.label&&(this._label=this.t.backToTop),"label"===o&&""!==this.label&&(this._label=this.label)}))}render(){return o` <simple-icon-button-lite
        @click="${this.scrollEvent}"
        id="btn"
        icon="${this.icon}"
        label="${this._label}"
      ></simple-icon-button-lite>
      <simple-tooltip for="btn" position="${this.position}" offset="14">
        ${this._label}
      </simple-tooltip>`}static get properties(){return{target:{type:Object},icon:{type:String},label:{type:String},_label:{type:String},position:{type:String},t:{type:Object}}}scrollEvent(t){this.target?this.target.scrollIntoView({behavior:"smooth",block:"start",inline:"nearest"}):globalThis.scrollTo({top:0,left:0,behavior:"smooth"})}}customElements.define(ScrollButton.tag,ScrollButton);export{ScrollButton};