/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../lit/index.js";import{RichTextStyles as o}from"./lib/buttons/rich-text-editor-button.js";import"./lib/toolbars/rich-text-editor-toolbar.js";import"./lib/toolbars/rich-text-editor-toolbar-mini.js";import"./lib/toolbars/rich-text-editor-toolbar-full.js";const RichTextEditorBehaviors=function(t){return class extends t{static get styles(){return[...o,i`
          :host {
            display: block;
          }
          :host([hidden]) {
            display: none;
          }
          :host([disabled]) {
            cursor: not-allowed;
          }
          :host(:empty) {
            opacity: 0.7;
          }
          :host(:focus) {
            outline: none;
          }

          :host(.heightmax[contenteditable="true"]) {
            max-height: calc(100vh - 200px);
            overflow-y: scroll;
          }

          #container,
          #wysiwyg {
            display: block;
            width: 100%;
          }
          #source,
          #wysiwyg {
            margin: 0;
            padding: 0;
            min-height: var(--rich-text-editor-min-height, 20px);
            cursor: pointer;
            outline: none;
            flex: 1 1 100%;
            width: 100%;
          }
          :host(:empty) {
            min-height: 20px;
          }
          :host(:empty)::after {
            display: block;
            content: attr(aria-placeholder);
          }

          :host(:hover),
          :host(:focus-within) {
            opacity: 1;
            outline: var(--rich-text-editor-border-width, 1px) dotted
              var(--rich-text-editor-focus-color, currentColor);
          }
          :host([disabled]),
          :host([view-source]) {
            outline: none !important;
          }

          #source:hover,
          #source:focus-within {
            outline: var(--rich-text-editor-border-width, 1px) dotted
              var(--rich-text-editor-focus-color, currentColor);
          }
          :host([contenteditable="true"][view-source]) #container {
            display: flex;
            align-items: stretch;
            justify-content: space-between;
            width: 100%;
          }
          :host([contenteditable="true"][view-source]) #source,
          :host([contenteditable="true"][view-source]) #wysiwyg {
            resize: horizontal;
            overflow: auto;
            flex: 1 1 auto;
            width: 50%;
          }
          :host([contenteditable="true"][view-source]) #source {
            min-width: 300px;
          }
          :host([contenteditable="true"][view-source]) #wysiwyg {
            cursor: not-allowed;
            margin-right: 10px;
            width: calc(50% - 10px);
          }
          ::slotted(*:first-child) {
            margin-top: 0px;
          }
          ::slotted(*:last-child) {
            margin-bottom: 0px;
          }
        `]}render(){return e` <div
        id="container"
        @focus="${t=>this.__focused=!0}"
        @blur="${t=>this.__focused=!1}"
        @mouseover="${t=>this.__hovered=!0}"
        @mouseout="${t=>this.__hovered=!1}"
      >
        <slot></slot>
      </div>`}static get properties(){return{...super.properties,id:{name:"id",type:String,reflect:!0,attribute:"id"},contenteditable:{name:"contenteditable",type:String,reflect:!0,attribute:"contenteditable"},disabled:{name:"disabled",type:Boolean,attribute:"disabled",reflect:!0},disableHover:{name:"disableHover",type:Boolean,attribute:"disable-hover"},placeholder:{name:"placeholder",type:String,reflect:!1,attribute:"aria-placeholder"},toolbarId:{name:"toolbarId",type:String,reflect:!0,attribute:"toolbar-id"},range:{name:"range",type:Object,attribute:"range"},rawhtml:{type:String,attribute:"rawhtml"},type:{name:"type",type:String,reflect:!0,attribute:"type"},viewSource:{type:Boolean,attribute:"view-source",reflect:!0},__codeEditorValue:{type:String},__needsUpdate:{type:Boolean},__focused:{type:Boolean},__hovered:{type:Boolean}}}static get tag(){return"rich-text-editor"}constructor(){super(),this.placeholder="Click to edit",this.toolbarId="",this.type="rich-text-editor-toolbar",this.id="",this.range=void 0,this.disabled=!1,this.__focused=!1,this.__hovered=!1,this.editing=!1,this.setAttribute("tabindex",0),this.addEventListener("click",this._handleClick)}get editable(){return!!this.contenteditable&&"false"!==this.contenteditable}get isEmpty(){return!this.innerHTML||""==this.innerHTML.replace(/<!--[^(-->)]*-->/g,"").replace(/[\s\t\r\n]/gim,"")}firstUpdated(){super.firstUpdated&&super.firstUpdated(),this.isEmpty&&this.rawhtml?this.innerHTML=this.rawhtml.trim():this.isEmpty&&(this.innerHTML="")}updated(t){super.updated(t),t.forEach(((t,e)=>{"rawhtml"===e&&this.rawhtml&&(this.innerHTML=this.rawhtml.trim()),"contenteditable"===e&&this._contenteditableChange()})),this.innerHTML||(this.innerHTML="")}focus(){this.disabled||(this.contenteditable="true",this.__focused=!0),this.dispatchEvent(new CustomEvent("focus",{bubbles:!0,composed:!0,cancelable:!0,detail:this.querySelector("*")}))}makeSticky(t=!0){t?this.classList.remove("heightmax"):this.classList.add("heightmax")}_contenteditableChange(){this.dispatchEvent(new CustomEvent("contenteditable-change",{bubbles:!0,composed:!0,cancelable:!0,detail:this}))}_handleClick(t){if(t.preventDefault(),!this.disabled&&!this.editable&&!this.__toolbar){let t,e=this.toolbarId?(globalThis.RichTextEditorToolbars||[]).filter((t=>t.id===this.toolbarId)):[];0===e.length&&(e=this.type?(globalThis.RichTextEditorToolbars||[]).filter((t=>t.type===this.type)):[]),0===e.length&&(e=globalThis.RichTextEditorToolbars),e[0]?t=e[0]:0===e.length&&(t=globalThis.document.createElement(this.type||"rich-text-editor-toolbar")),this.__toolbar=t,!this.disabled&&this.__toolbar&&this.__toolbar.setTarget&&this.__toolbar.setTarget(this)}}}};class RichTextEditor extends(RichTextEditorBehaviors(t)){}customElements.define(RichTextEditor.tag,RichTextEditor);export{RichTextEditor,RichTextEditorBehaviors};