/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as r}from"../../../../lit/index.js";import{RichTextToolbarStyles as o}from"../buttons/rich-text-editor-button.js";import{RichTextEditorRangeBehaviors as i}from"../singletons/rich-text-editor-range-behaviors.js";class RichTextEditorBreadcrumbs extends(i(t)){static get tag(){return"rich-text-editor-breadcrumbs"}static get properties(){return{controls:{type:String},hidden:{type:Boolean,attribute:"hidden",reflect:!0},label:{type:String},sticky:{type:Boolean,reflect:!0},selectionAncestors:{type:Array}}}constructor(){super(),this.hidden=!0,this.sticky=!1,this.label="Select"}_handleClick(t){t.selectAll?this.selectNodeContents(t.selectAll):this.selectNode(t),this.editor&&this.editor.focus()}render(){return e`
      ${this.label}:
      ${this.selectionAncestors?(this.selectionAncestors||[]).map(((t,r)=>e`
              <button
                class="${t.selectAll?"":"selectnode"}"
                controls="${this.controls}"
                @click="${e=>this._handleClick(t)}"
                tabindex="0"
              >
                ${t.nodeName.toLowerCase()}
              </button>
              ${r+1>=(this.selectionAncestors||[]).length?"":e` <span class="divider"> &gt; </span> `}
            `)):""}
    `}static get styles(){return[...o,r`
        :host {
          display: block;
          background-color: var(--rich-text-editor-bg, #ffffff);
          color: var(--rich-text-editor-button-color #444);
          border: var(--rich-text-editor-border-width, 1px) solid var(--rich-text-editor-border-color, #ddd);
          padding: 3px 10px;
        }
        :host([sticky]) {
          position: sticky;
          bottom: 0;
        }
        .selectednode {
          background-color: var(--rich-text-editor-button-bg, #ffffff);
        }
        button {
          display: inline-block;
          text-align: center;
          min-width: 25px;
          margin: 0;
          padding: 2px 5px;
        }
        .selectNode {
          font-family: monospace;
        }
      `]}}customElements.define(RichTextEditorBreadcrumbs.tag,RichTextEditorBreadcrumbs);export{RichTextEditorBreadcrumbs};