/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../../../lit/index.js";class RichTextEditorSource extends e{static get styles(){return[i`
        :host {
          display: block;
        }
        :host([hidden]) {
          display: none;
        }

        :host([disabled]),
        :host([view-source]) {
          outline: none !important;
        }
        #container {
          display: flex;
          align-items: stretch;
          justify-content: space-between;
          width: 100%;
        }
        #source,
        #wysiwyg {
          margin: 0;
          padding: 0;
          min-height: var(--rich-text-editor-min-height, 20px);
          cursor: pointer;
          outline: none;
          overflow: auto;
          resize: horizontal;
        }
        #source {
          flex: 1 1 auto;
          min-width: 300px;
          padding-bottom: 20px;
        }
        #wysiwyg {
          flex: 0 1 auto;
          display: block;
          margin-left: 10px;
          max-height: 70vh;
          overflow-x: hidden;
          resize: auto;
        }
        #source:hover,
        #source:focus-within {
          outline: var(--rich-text-editor-border-width, 1px)
            var(--rich-text-editor-focus-border-style, 1px)
            var(--rich-text-editor-focus-color, blue);
        }
      `]}render(){return t` <div id="container">
      <div id="wysiwyg" part="wysiwyg">
        <slot></slot>
      </div>
      <code-editor
        id="source"
        font-size="13"
        language="html"
        @value-changed="${this._handleSourceChange}"
        word-wrap
        part="source"
      >
      </code-editor>
    </div>`}static get properties(){return{...super.properties,id:{name:"id",type:String,reflect:!0,attribute:"id"},disabled:{name:"disabled",type:Boolean,attribute:"disabled",reflect:!0},hidden:{name:"hidden",type:Boolean,attribute:"hidden",reflect:!0},__target:{type:Object},__toolbar:{type:Object},__codeEditorValue:{type:String},__needsUpdate:{type:Boolean}}}static get tag(){return"rich-text-editor-source"}constructor(){if(super(),this.id="",import("../../../code-editor/code-editor.js"),!globalThis.RichTextEditorSource.instance)return globalThis.RichTextEditorSource.instance=this,this}firstUpdated(){super.firstUpdated&&super.firstUpdated(),this.toggle()}updated(e){super.updated(e),e.forEach(((e,t)=>{}))}toggle(e){let t=this.shadowRoot?this.shadowRoot.querySelector("#source"):void 0;!t||!e||!e.target||this.__toolbar&&this.__toolbar===e?([...document.querySelectorAll("[data-rich-text-editor-view-source-mode]")].forEach((e=>e.removeAttribute("data-rich-text-editor-view-source-mode"))),this.__target&&this.__target.focus(),this.hidden=!0,this.__toolbar=void 0,this.__target=void 0,this.disabled=!0,this.__codeEditorValue="",this.innerHTML=this.__codeEditorValue,globalThis.document.body.append(this)):(this.__toolbar=e,this.__target=e.target,this.disabled=this.__target.disabled,this.__target.setAttribute("data-rich-text-editor-view-source-mode",!0),this.__target.parentNode.insertBefore(this,this.__target),this.__codeEditorValue=this.__toolbar.targetHTML,this.innerHTML=this.__codeEditorValue,t.editorValue=this.__codeEditorValue,this.hidden=!1,t.focus())}_handleSourceChange(e){if(this.__toolbar&&this.__target&&!this.__needsUpdate){this.__needsUpdate=!e.detail||!e.detail.value||this.__toolbar.htmlMatchesTarget(`${e.detail.value}`);let update=()=>{this.__needsUpdate=!1,this.__codeEditorValue=e.detail.value,this.innerHTML=e.detail.value,this.__target.innerHTML=e.detail.value};this.__needsUpdate&&setTimeout(update.bind(this),300)}}}customElements.define(RichTextEditorSource.tag,RichTextEditorSource);export{RichTextEditorSource};globalThis.RichTextEditorSource=globalThis.RichTextEditorSource||{},globalThis.RichTextEditorSource.requestAvailability=()=>(globalThis.RichTextEditorSource.instance||(globalThis.RichTextEditorSource.instance=globalThis.document.createElement("rich-text-editor-source"),globalThis.RichTextEditorSource.stylesheet=globalThis.document.createElement("style"),globalThis.RichTextEditorSource.stylesheet.innerHTML="rich-text-editor-source + [data-rich-text-editor-view-source-mode] { display: none }",globalThis.document.body.appendChild(globalThis.RichTextEditorSource.instance),globalThis.document.head.appendChild(globalThis.RichTextEditorSource.stylesheet)),globalThis.RichTextEditorSource.instance);