/**
 * Copyright 2018 Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../../../lit/index.js";import{RichTextToolbarStyles as o}from"../buttons/rich-text-editor-button.js";import"../../../simple-popover/simple-popover.js";import"../../../simple-fields/simple-fields.js";import"./rich-text-editor-highlight.js";import{RichTextEditorRangeBehaviors as s}from"./rich-text-editor-range-behaviors.js";class RichTextEditorPrompt extends(s(t)){static get styles(){return[...o,i`
        #prompt {
          display: block;
          width: 300px;
          max-width: 300px;
          --simple-popover-padding: 0px;
          --simple-popover-max-height: auto;
          z-index: 2;
        }
        #prompt[hidden] {
          display: none;
        }
        #prompt #form {
          display: flex;
          flex-direction: column;
          align-items: center;
          justify-content: space-between;
          z-index: 2;
        }
        #formfields {
          width: calc(100% - 20px);
          padding: 10px 10px 0;
          overflow: visible;
        }
        #prompt simple-fields-field {
          padding: 0;
        }
        #confirm,
        #cancel {
          min-width: unset;
        }
        #cancel {
          color: var(--rich-text-editor-button-color);
          background-color: var(--rich-text-editor-button-bg);
        }
        #cancel:focus,
        #cancel:hover {
          color: var(--rich-text-editor-button-hover-color);
          background-color: var(--rich-text-editor-button-hover-bg);
        }
        #confirm {
          color: var(--rich-text-editor-button-color);
          background-color: var(--rich-text-editor-button-bg);
        }
        #confirm:focus,
        #confirm:hover {
          color: var(--rich-text-editor-button-hover-color);
          background-color: var(--rich-text-editor-button-hover-bg);
        }
        .actions {
          width: calc(100% - 20px);
          padding: 0 10px 3px;
          display: flex;
          align-items: center;
          justify-content: flex-end;
          background-color: var(--rich-text-editor-button-bg);
        }
        .confirm-or-cancel {
          min-width: 40px;
        }
      `]}render(){return e`
      <simple-popover
        id="prompt"
        ?auto="${!this.hidden||!this.__highlight.hidden}"
        for="${this.__highlight?this.__highlight.id:""}"
        ?hidden="${this.hidden||this.__highlight.hidden}"
        position="bottom"
        sticky
        fit-to-visible-bounds
        position-align="center"
        .target="${this.__highlight}"
      >
        <form
          id="form"
          @blur="${this._handleBlur}"
          @focus="${this._handleFocus}"
        >
          <simple-fields
            id="formfields"
            hide-line-numbers
            .fields="${this.fields}"
            @fields-ready="${this._handleReady}"
            .value="${this.value}"
          ></simple-fields>
          <div class="actions">
            <simple-toolbar-button
              id="cancel"
              controls="${this.__highlight?this.__highlight.id:""}"
              label="Cancel"
              icon="clear"
              @click="${this._cancel}"
            >
            </simple-toolbar-button>
            <simple-toolbar-button
              id="confirm"
              controls="${this.__highlight?this.__highlight.id:""}"
              @click="${this._confirm}"
              icon="check"
              label="OK"
            >
            </simple-toolbar-button>
          </div>
        </form>
      </simple-popover>
    `}static get tag(){return"rich-text-editor-prompt"}static get properties(){return{fields:{type:Array},range:{type:Object},value:{type:Object},__focused:{type:Boolean},__hovered:{type:Boolean},__opened:{type:Boolean}}}constructor(){if(super(),this.haxUIElement=!0,globalThis.addEventListener("rich-text-editor-prompt-open",this.open.bind(this)),!globalThis.RichTextEditorPrompt.instance)return globalThis.RichTextEditorPrompt.instance=this,this}get hidden(){return!this.__opened}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.__highlight.addEventListener("change",(t=>setTimeout(this._handleChange(t),300))),this.addEventListener("mousedown",(t=>this.__retainFocus=!0)),this.addEventListener("mouseup",(t=>this.__retainFocus=!1)),this.addEventListener("focusin",(t=>this.__retainFocusIn=!0)),this.addEventListener("focusout",(t=>this.__retainFocusIn=!1)),this.addEventListener("focus",this._handleFocus),this.addEventListener("blur",this._handleBlur)}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{["__focused","__hovered","__opened"].includes(e)&&setTimeout(this._handleChange.bind(this),300)}))}_handleReady(t){t.detail.focus()}_handleFocus(t){this.__focused=!0}_handleBlur(t){this.__retainFocus||this.__retainFocusIn||(this.__focused=!1)}_handleChange(t){setTimeout((()=>{!this.__opened||this.__focused||this.__hovered||this._cancel()}),500)}open(t){t&&t.detail&&(this.__opened=!0,this.__focused=!0,this.button=t.detail,this.fields=[...t.detail.fields],this.value={...t.detail.value},1===t.detail.fields.length&&1===Object.keys(t.detail.value).length&&(t.detail.fields[0].attribute?(this.value[t.detail.fields[0].attribute]=t.detail.value[Object.keys(t.detail.value).pop()],this.value={...this.value}):t.detail.fields[0].property&&(this.value[t.detail.fields[0].property]=t.detail.value[Object.keys(t.detail.value).pop()],this.value={...this.value})),0===this.fields.length&&this._confirm(t),this.shadowRoot.querySelector("#formfields")&&this.shadowRoot.querySelector("#formfields").rebuildForm&&this.shadowRoot.querySelector("#formfields").rebuildForm(),this.shadowRoot.querySelector("#cancel")&&this.shadowRoot.querySelector("#cancel").focus())}close(){this.__opened=!1,this.__focused=!1,this.button=void 0,this.fields=[],this.value={}}_cancel(t){t&&t.preventDefault(),this.button&&this.button.cancel(),this.close()}_confirm(t){t.preventDefault(),this.value=this.shadowRoot.querySelector("#formfields").value,this.button.confirm(this.value),setTimeout((()=>{this.close()}),10)}}customElements.define(RichTextEditorPrompt.tag,RichTextEditorPrompt);export{RichTextEditorPrompt};globalThis.RichTextEditorPrompt=globalThis.RichTextEditorPrompt||{},globalThis.RichTextEditorPrompt.requestAvailability=()=>(globalThis.RichTextEditorPrompt.instance||(globalThis.RichTextEditorPrompt.instance=globalThis.document.createElement("rich-text-editor-prompt"),globalThis.document.body.appendChild(globalThis.RichTextEditorPrompt.instance)),globalThis.RichTextEditorPrompt.instance);