/**
 * Copyright 2019 Penn State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../../../lit/index.js";import{RichTextEditorButtonBehaviors as o}from"./rich-text-editor-button.js";import"../../../simple-picker/simple-picker.js";const RichTextEditorPickerBehaviors=function(e){return class extends(o(e)){static get tag(){return"rich-text-editor-picker"}static get styles(){return[super.styles,i`
          :host {
            align-items: center;
            --simple-picker-background-color: var(--simple-toolbar-button-bg);
            --simple-picker-color-active: var(
              --simple-toolbar-button-hover-color
            );
            --simple-picker-background-color-active: var(
              --simple-toolbar-button-hover-bg
            );
            --simple-picker-color-disabled: var(
              --simple-toolbar-button-disabled-color
            );
            --simple-picker-background-color-disabled: var(
              --simple-toolbar-button-disabled-bg
            );
            --simple-picker-border-radius: 0px;
            --simple-picker-border-width: 0px;
            --simple-picker-option-size: calc(
              24px - 2 * var(--simple-picker-sample-padding, 2px)
            );
            --simple-picker-icon-size: 16px;
            --simple-picker-options-border-width: 1px;
            --simple-picker-options-border: var(
                --simple-picker-options-border-width,
                1px
              )
              solid
              var(
                --simple-toolbar-border-color,
                var(--rich-text-editor-border-color, #ddd)
              );
          }
          #button {
            margin-top: 0;
            margin-bottom: 0;
          }
          #button.hide-label::part(label) {
            position: absolute;
            left: -999999px;
            top: 0;
            width: 0px;
            height: 0px;
            overflow: hidden;
          }
        `]}render(){return t`
        <simple-picker
          id="button"
          ?allow-null="${this.allowNull}"
          class="rtebutton ${this.labelVisibleClass}-label ${this.toggled?"toggled":""}"
          ?disabled="${this.disabled}"
          ?hide-null-option="${this.hideNullOption}"
          .controls="${super.controls}"
          .options="${this.options}"
          @mouseover="${this._pickerFocus}"
          @keydown="${this._pickerFocus}"
          .label="${this.currentLabel}"
          @value-changed="${this._pickerChange}"
          tabindex="0"
          ?title-as-html="${this.titleAsHtml}"
          .value="${this.value}"
        >
        </simple-picker>
        ${super.tooltipTemplate}
      `}static get properties(){return{...super.properties,allowNull:{type:Boolean},disabled:{type:Boolean,reflect:!0,attribute:"disabled"},command:{type:String},hideNullOption:{type:Boolean},icon:{type:String,reflect:!0},titleAsHtml:{type:Boolean},value:{type:Object}}}constructor(){super(),this.allowNull=!1,this.command="insertHTML",this.label="Insert link",this.titleAsHtml=!1,this.value=null}firstUpdated(e){super.firstUpdated(e),this._setOptions()}get isToggled(){return!1}get labelVisibleClass(){return this.icon?"hide":"show"}get picker(){return this.shadowRoot&&this.shadowRoot.querySelector("#button")?this.shadowRoot.querySelector("#button"):void 0}get expanded(){return this.picker&&this.picker.expanded}_pickerFocus(e){e.preventDefault()}_rangeChanged(){this._setRangeValue(),super._rangeChanged()}_setRangeValue(){let e=this._getSelection();this.shadowRoot&&(this.tagsArray.includes(e)?this.shadowRoot.querySelector("#button").value=e:this.range&&!this.range.collapsed||(this.shadowRoot.querySelector("#button").value=void 0))}_setOptions(){return this.options=this._setPickerOptions()}_setPickerOptions(e=this.options||[]){let t=[],i=Math.sqrt(e.length)<11?Math.ceil(Math.sqrt(e.length)):10;return e.forEach(((e,o)=>{let r=Math.floor(o/i),s=o-r*i;t[r]||(t[r]=[]),t[r][s]=e})),t}_pickerChange(e){let t=this._getSelectionType()||"";this.__highlight.parentNode;this.commandVal=e.detail.value||"",this.range&&t!==this.commandVal&&this.sendCommand()}}};class RichTextEditorPicker extends(RichTextEditorPickerBehaviors(e)){}customElements.define(RichTextEditorPicker.tag,RichTextEditorPicker);export{RichTextEditorPicker,RichTextEditorPickerBehaviors};