/**
 * Copyright 2019 Penn State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as i,css as t}from"../../../../lit/index.js";import{RichTextEditorPickerBehaviors as s}from"./rich-text-editor-picker.js";import{SimpleIconPicker as l}from"../../../simple-icon-picker/simple-icon-picker.js";class RichTextEditorIconPicker extends(s(e)){static get tag(){return"rich-text-editor-icon-picker"}static get styles(){return[super.styles,t`
        #button.show-label::part(label) {
          padding: 0;
          margin-right: 0;
          margin-left: 4px;
        }
        #button.show-label::part(sample) {
          min-height: var(--simple-picker-option-size, 24px);
          margin-left: calc(-0.125 * var(--simple-picker-icon-size, 16px));
        }
        #button.show-label::part(sample-option) {
          display: none;
        }
      `]}render(){return i`
      <simple-icon-picker
        id="button"
        ?allow-null="${this.allowNull}"
        class="rtebutton ${this.labelVisibleClass}-label ${this.toggled?"toggled":""}"
        .controls="${super.controls}"
        ?disabled="${this.disabled}"
        .icons="${this.icons}"
        .excludes="${this.excludes}"
        .includeSets="${this.includeSets}"
        .excludeSets="${this.excludeSets}"
        @keydown="${this._pickerFocus}"
        .label="${this.currentLabel}"
        @mouseover="${this._pickerFocus}"
        tabindex="0"
        ?toggled="${this.toggled}"
        @value-changed="${this._pickerChange}"
      >
      </simple-icon-picker>
      ${super.tooltipTemplate}
    `}static get properties(){return{...super.properties,...l.properties}}constructor(){super(),this.icon=void 0,this.icons=[],this.excludes=[],this.includeSets=[],this.excludeSets=[],this.label="Insert icon",this.command="insertHTML",this.tagsList="simple-icon-lite"}_pickerChange(e){let i=this._getSelectionType()||"";this.__highlight.parentNode;this.commandVal=e.detail.value?`<simple-icon-lite icon="${e.detail.value}"></simple-icon-lite>`:"",this.range&&i!==this.commandVal&&this.sendCommand()}_setOptions(){}}customElements.define(RichTextEditorIconPicker.tag,RichTextEditorIconPicker);export{RichTextEditorIconPicker};