/**
 * Copyright 2019 Penn State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../../../lit/index.js";import{RichTextEditorPickerBehaviors as s}from"./rich-text-editor-picker.js";import"../../../simple-picker/lib/simple-emoji-picker.js";class RichTextEditorEmojiPicker extends(s(e)){static get tag(){return"rich-text-editor-emoji-picker"}static get styles(){return[super.styles,i``]}render(){return t`
      <simple-emoji-picker
        id="button"
        ?allow-null="${this.allowNull}"
        class="rtebutton ${this.labelVisibleClass}-label ${this.toggled?"toggled":""}"
        .controls="${super.controls}"
        ?disabled="${this.disabled}"
        .emoji-types="${this.emojiTypes}"
        @keydown="${this._pickerFocus}"
        .label="${this.currentLabel}"
        @mouseover="${this._pickerFocus}"
        tabindex="0"
        title-as-html
        ?toggled="${this.toggled}"
        @value-changed="${this._pickerChange}"
      >
      </simple-emoji-picker>
      ${super.tooltipTemplate}
    `}static get properties(){return{...super.properties,emojiTypes:{name:"emojiTypes",type:Array,attribute:"emoji-types"}}}constructor(){super(),this.emojiTypes=["emotions","people","nature","food","travel","activities","objects","symbols","flags"],this.icon="editor:insert-emoticon",this.label="Insert emoji",this.command="insertHTML"}updated(e){super.updated(e),e.forEach(((e,t)=>{"titleAsHtml"!==t||this.titleAsHtml||(this.titleAsHtml=!0)}))}_setOptions(){}}customElements.define(RichTextEditorEmojiPicker.tag,RichTextEditorEmojiPicker);export{RichTextEditorEmojiPicker};