/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t}from"../../lit/index.js";import{SimpleColors as r}from"../simple-colors/simple-colors.js";class RetroCard extends r{static get styles(){return[super.styles,t`
        :host {
          display: block;
          --retro-card-level-2: var(
            --simple-colors-default-theme-accent-7,
            #b8a515
          );
          --retro-card-level-1: var(
            --simple-colors-default-theme-accent-6,
            #e5cd1b
          );
          --retro-card-level-3: var(
            --simple-colors-default-theme-accent-5,
            #ead749
          );
          --retro-card-shadow: var(
            --simple-colors-default-theme-accent-8,
            rgba(229, 205, 27, 0.2)
          );
          --retro-card-light-color: #f4f1d0;
          --retro-card-dark-color: #212121;
        }

        :host([dark]) {
          --retro-card-dark-color: #f4f1d0;
          --retro-card-light-color: #212121;
        }

        :host([hidden]) {
          display: none;
        }

        :host([hover-state]) .link:nth-child(1n + 0) {
          box-shadow: 16px 16px 0px 0px var(--retro-card-shadow);
          border: 16px solid var(--retro-card-level-2);
          background-color: var(--retro-card-level-1);
        }

        :host([hover-state]) .link {
          color: var(--retro-card-light-color);
          text-decoration: underline;
          padding: 1.25rem;
          border: 16px var(--retro-card-level-1) solid;
          box-shadow: 16px 16px 0px 0px var(--retro-card-shadow);
          transition:
            background-color 0.2s ease-in-out 0s,
            padding 0.4s ease-in-out 0s,
            border 0.4s ease-in-out 0s,
            box-shadow 0.2s ease-in-out 0s;
        }

        .link:nth-child(1n + 0) {
          background-color: var(--retro-card-level-3);
          box-shadow: 8px 8px 0px 0px var(--retro-card-level-1);
          border: 4px var(--retro-card-level-1) solid;
        }

        .link {
          display: block;
          background-color: var(--retro-card-level-3);
          border: 4px var(--retro-card-level-1) solid;
          padding: var(--retro-card-padding, 2rem);
          box-shadow: 8px 8px 0px 0px var(--retro-card-level-1);
          transition:
            padding 0.4s ease-in-out 0s,
            border 0.4s ease-in-out 0s,
            box-shadow 0.2s ease-in-out 0s;
          text-align: center;
          color: var(--retro-card-dark-color);
          text-decoration: none;
          line-height: inherit;
          cursor: pointer;
          font-family: "Roboto Mono", Consolas, Monospace;
        }

        .img {
          -webkit-filter: grayscale(1);
          filter: grayscale(1);
          mix-blend-mode: screen;
          border: 0;
          max-width: 100%;
          height: auto;
          -ms-interpolation-mode: bicubic;
          display: inline-block;
          vertical-align: middle;
          max-height: 200px;
        }

        .title {
          display: block;
          font-size: 1.5rem;
          padding: 2rem 0 0 0;
          text-transform: uppercase;
          font-weight: 700;
          text-align: center;
        }

        .description {
          display: block;
          font-size: 0.9rem;
          padding: 0.75rem 1rem 0;
        }

        .card-tags {
          line-height: 1.6;
          text-align: center;
          margin-bottom: 1rem;
          text-rendering: optimizeLegibility;
          font-weight: 300;
        }

        .project-tag {
          font-size: 0.7rem;
          padding: 0.25rem 0.5rem;
          font-style: italic;
          font-weight: 600;
          color: var(--retro-card-light-color);
          background: var(--retro-card-dark-color);
          word-wrap: break-word;
          padding: 0 0.5rem;
          text-transform: uppercase;
          margin-bottom: 2rem;
          margin: 0 0.25rem 2rem 0;
        }

        hr {
          border-bottom: 1px solid var(--retro-card-dark-color);
          max-width: 75rem;
          height: 0;
          border-right: 0;
          border-top: 0;
          border-left: 0;
          margin: 1.25rem auto;
          clear: both;
        }
      `]}render(){return e` ${this.nosource?e`
 <div class="link ${this.color}">
   ${this.__source?e`<img class="img" loading="lazy" src="${this.__source}" alt="" />`:""}
   <div class="title" part="title"><slot name="title"></slot>${this.title}</slot></div>
   <div class="subtitle" part="subtitle"><slot name="subtitle">${this.subtitle}</slot></div>
   <div class="description" part="description"><slot></slot></div>
   ${this.__cardTags?e`<hr />
           <div class="card-tags" part="card-tags">
             ${this.__cardTags.map((t=>e`<span class="project-tag" part="project-tag"
                   >${t.trim()}</span
                 >`))}
           </div>`:""}
 </div>`:e`
   <a tabindex="-1" class="link ${this.color}" href="${this.url}" @click="${this._clickCard}">
     ${this.__source?e`<img
             class="img"
             loading="lazy"
             src="${this.__source}"
             alt=""
           />`:""}
     <div class="title" part="title"><slot name="title"></slot>${this.title}</slot></div>
     <div class="subtitle" part="subtitle"><slot name="subtitle">${this.subtitle}</slot></div>
     <div class="description" part="description"><slot></slot></div>
     ${this.__cardTags?e`<hr />
             <div class="card-tags" part="card-tags">
               ${this.__cardTags.map((t=>e`<span class="project-tag" part="project-tag"
                     >${t.trim()}</span
                   >`))}
             </div>`:""}
 </a>
 `}`}static get haxProperties(){return{canScale:!1,canEditSource:!0,gizmo:{title:"Retro card",description:"Simple card in a cool retro design",icon:"icons:credit-card",color:"purple",tags:["Layout","card","layout"],handles:[],meta:{author:"HAXTheWeb core team",owner:"The Pennsylvania State University"}},settings:{configure:[{property:"title",title:"Title",description:"Main title of card",inputMethod:"textfield",required:!1},{property:"url",description:"Link to go to when clicking the card",inputMethod:"textfield",required:!1,validationType:"url"},{property:"subtitle",title:"Sub-title",description:"Sub heading",inputMethod:"textfield",required:!1},{property:"tags",title:"Tags",description:"Comma separated tags",inputMethod:"textfield",required:!1},{property:"mediaSource",title:"Media source",description:"Primary media source",inputMethod:"haxupload",noVoiceRecord:!0,required:!0,validationType:"url"},{property:"hoverSource",description:"When user hovers / activates the card",title:"Source on hover",inputMethod:"haxupload",noVoiceRecord:!0,required:!1,validationType:"url"},{property:"accentColor",description:"An accent to apply evenly to the card",title:"Accent Color",inputMethod:"colorpicker",required:!1},{property:"dark",title:"Dark",description:"Sets base color to be dark mode",inputMethod:"boolean",required:!1}],advanced:[]},saveOptions:{unsetAttributes:["colors"]},demoSchema:[{tag:"video-player",properties:{title:"HAX Camp",subtitle:"btopro dreaming reality",tags:"dreams, hax, camp",accentColor:"pink",url:"https://btopro.com","media-source":"https://btopro.com/files/IMG_20190716_102855.jpg"},content:""}]}}static get properties(){return{...super.properties,title:{type:String},subtitle:{type:String},tags:{type:String},mediaSource:{type:String,attribute:"media-source"},url:{type:String},hoverSource:{type:String,attribute:"hover-source"},hoverState:{type:Boolean,attribute:"hover-state",reflect:!0},__cardTags:{type:Array},nosource:{type:Boolean},__source:{type:String}}}static get tag(){return"retro-card"}constructor(){super(),this.__cardTags=[],this.hoverState=!1,this.nosource=!1}_keyPress(e){if("Enter"===e.key)this.shadowRoot.querySelector("a").click()}_hoverStateOff(e){this.hoverState=!1}_hoverStateOn(e){this.hoverState=!0}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),this.addEventListener("mouseover",this._hoverStateOn.bind(this)),this.addEventListener("mouseout",this._hoverStateOff.bind(this)),this.nosource||(this.setAttribute("tabindex",0),this.addEventListener("keypress",this._keyPress.bind(this)),this.addEventListener("focusin",this._hoverStateOn.bind(this)),this.addEventListener("focusout",this._hoverStateOff.bind(this))),this.hoverSource||(this.hoverSource=this.mediaSource)}haxHooks(){return{editModeChanged:"haxeditModeChanged",activeElementChanged:"haxactiveElementChanged"}}haxactiveElementChanged(e,t){t&&(this._haxstate=t)}haxeditModeChanged(e){this._haxstate=e}_clickCard(e){this._haxstate&&!this.nosource&&(e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation())}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"tags"==t&&this._tagsChanged(this[t]),"source"==t&&(this.__source=this.mediaSource),"hoverState"==t&&(this.__source=this[t]?this.hoverSource:this.mediaSource)}))}_tagsChanged(e){let t=e.split(",");this.__cardTags=[...t]}}customElements.define(RetroCard.tag,RetroCard);export{RetroCard};