/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../lit/index.js";import{RelativeHeadingLite as n}from"./lib/relative-heading-lite.js";import"../anchor-behaviors/anchor-behaviors.js";import"../simple-icon/lib/simple-icons.js";import"../simple-icon/lib/simple-icon-button-lite.js";class RelativeHeading extends n{static get styles(){return[i`
        :host {
          display: flex;
          flex-wrap: var(--relative-heading-wrap, wrap);
          align-items: var(--relative-heading-align, center);
          justify-content: flex-start;
        }

        :host([hidden]) {
          display: none;
        }

        ::slotted(*) {
          flex: 0 0 auto;
        }

        :host([link-align-right]) {
          justify-content: space-between;
        }

        :host([link-align-right]) ::slotted(*) {
          flex: 1 1 auto;
        }

        :host > simple-icon-button-lite:not(:defined) {
          opacity: 0;
        }

        :host > simple-icon-button-lite {
          flex: 0 0 auto;
        }

        simple-icon-button-lite {
          color: var(--relative-heading-button-color, #666);
          background: var(--relative-heading-button-bg);
          border: var(--relative-heading-button-border);
          outline: var(--relative-heading-button-outline);
          margin: var(--relative-heading-button-margin, 0 0 0 8px);
          padding: var(--relative-heading-button-padding, 8px);
          opacity: var(--relative-heading-button-opacity, 0);
          transition: var(--relative-heading-button-transition, all 0.5s);
        }

        :host([link-align-right]) simple-icon-button-lite,
        :host(:not([link-align-right]):focus) simple-icon-button-lite,
        :host(:not([link-align-right]):focus-within) simple-icon-button-lite,
        :host(:not([link-align-right]):hover) simple-icon-button-lite {
          opacity: var(--relative-heading-button-active-opacity, 1);
        }

        simple-icon-button-lite:focus-within,
        simple-icon-button-lite:focus,
        simple-icon-button-lite:hover {
          color: var(--relative-heading-button-focus-color, #000);
          background: var(--relative-heading-button-focus-bg);
          border: var(--relative-heading-button-focus-border);
          outline: var(--relative-heading-button-focus-outline);
          opacity: var(--relative-heading-button-focus-opacity, 1);
        }
      `]}render(){return t` ${this.template} ${this.button}`}static get haxProperties(){return{canScale:!0,canEditSource:!0,gizmo:{title:"Relative heading",description:"outputs the correct heading hierarchy based on parent's heading",icon:"icons:android",color:"green",tags:["Text","heading","header","h1","h2","h3","h4","h5","h6"],handles:[],meta:{author:"HAXTheWeb core team",owner:"The Pennsylvania State University"}},settings:{configure:[{property:"parent",description:"Parent Heading's Resource ID",inputMethod:"textfield",required:!1},{property:"disableLink",description:"Disables link button feature.",inputMethod:"boolean",required:!1},{property:"linkAlignRight",description:"Aligns copy link button to far right of heading.",inputMethod:"boolean",required:!1}],advanced:[{property:"defaultLevel",description:"Heading level if parent is not found.",inputMethod:"number",required:!1},{property:"copyMessage",description:"Overrides default text for copy link's toast message.",inputMethod:"textfield",required:!1},{property:"linkLabel",description:"Overrides default label copy link button.",inputMethod:"textfield",required:!1},{property:"linkIcon",description:"Overrides default icon copy link button.",inputMethod:"iconpicker",required:!1},{property:"closeLabel",description:"Overrides default label for copy link's toast's close button.",inputMethod:"textfield",required:!1},{property:"closeIcon",description:"Overrides default icon for copy link's toast's close button.",inputMethod:"iconpicker",required:!1}]}}}static get properties(){return{...super.properties,closeIcon:{type:String},closeLabel:{type:String},copyMessage:{type:String},disableLink:{type:Boolean,attribute:"disable-link"},linkAlignRight:{type:Boolean,attribute:"link-align-right",reflect:!0},linkIcon:{type:String},linkLabel:{type:String}}}static get tag(){return"relative-heading"}constructor(){super(),this.linkAlignRight=!1,this.disableLink=!1,this.linkIcon="link",this.linkLabel="Get link"}connectedCallback(){super.connectedCallback(),this.disableLink||this.manager.useCopyLink()}get anchored(){return!(!globalThis.AnchorBehaviors||!globalThis.AnchorBehaviors.getTarget)&&globalThis.AnchorBehaviors.getTarget(this)}get button(){return this.disableLink?t``:t`
          <simple-icon-button-lite
            controls="relative-heading-toast"
            .aria-describedby="${this.id}"
            .icon="${this.linkIcon}"
            .title="${this.linkLabel}"
            label="${this.linkLabel}"
            ?hidden="${this.disableLink}"
            ?disabled="${this.disableLink}"
            @click="${this._handleCopyClick}"
          >
          </simple-icon-button-lite>
        `}_handleCopyClick(){!this.disableLink&&this.manager&&this.manager.copyLink&&this.manager.copyLink(this)}}customElements.define(RelativeHeading.tag,RelativeHeading);export{RelativeHeading};