import{LitElement as e,html as t,css as a}from"../../../lit/index.js";
/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
globalThis.RelativeHeadingStateManager=globalThis.RelativeHeadingStateManager||{},globalThis.RelativeHeadingStateManager.requestAvailability=()=>(globalThis.RelativeHeadingStateManager.instance||(globalThis.RelativeHeadingStateManager.instance=globalThis.document.createElement("relative-heading-state-manager"),globalThis.document.body.appendChild(globalThis.RelativeHeadingStateManager.instance)),globalThis.RelativeHeadingStateManager.instance);class RelativeHeadingStateManager extends e{static get tag(){return"relative-heading-state-manager"}static get properties(){return{...super.properties,closeIcon:{type:String},closeLabel:{type:String},copyHeading:{type:Object},copyMessage:{type:String},headings:{type:Object},usesCopyLink:{type:Boolean}}}constructor(){super(),this.closeIcon="close",this.closeLabel="Close",this.copyMessage="Copied to Clipboard",this.headings=[],this.copyHeading={},this.usesCopyLink=!1,globalThis.RelativeHeadingStateManager.instance||(globalThis.RelativeHeadingStateManager.instance=this)}static get styles(){return[a`
        simple-toast:not(:defined) {
          display: none;
        }
      `]}render(){return t`
      <simple-toast
        id="relative-heading-toast"
        duration="5000"
        ?hidden="${!this.usesCopyLink}"
        ?disabled="${!this.usesCopyLink}"
        text="${this.copyHeading.copyMessage||this.copyMessage}: ${this.copyUrl}"
      >
        <simple-icon-button-lite
          icon="${this.copyHeading.closeIcon||this.closeIcon}"
          label="${this.copyHeading.closeLabel||this.closeLabel}"
          title="${this.copyHeading.closeLabel||this.closeLabel}"
          @click="${this.closeCopyLink}"
        ></simple-icon-button-lite>
      </simple-toast>
    `}get copyUrl(){return`${globalThis.location.href.replace(globalThis.location.hash,"")}#${this.copyHeading&&this.copyHeading.id?this.copyHeading.id:""}`}useCopyLink(){this.usesCopyLink||(this.usesCopyLink=!0,import("../../simple-icon/lib/simple-icons.js"),import("../../simple-icon/lib/simple-icon-button-lite.js"))}copyLink(e){this.copyHeading=e;let t=globalThis.document.createElement("textarea");t.value=this.copyUrl,globalThis.document.body.appendChild(t),t.select(),globalThis.document.execCommand("copy"),globalThis.document.body.removeChild(t),this.shadowRoot.querySelector("#relative-heading-toast")&&this.shadowRoot.querySelector("#relative-heading-toast").open&&this.shadowRoot.querySelector("#relative-heading-toast").open()}closeCopyLink(){this.shadowRoot.querySelector("#relative-heading-toast")&&this.shadowRoot.querySelector("#relative-heading-toast").close&&this.shadowRoot.querySelector("#relative-heading-toast").close()}addHeading(e){e&&(this.addSubhead(e),this.setHeading(e.id,e),this.updateLevel(e))}removeHeading(e){e&&(e.id&&this.headings[e.id]&&(this.headings[e.id].heading=null,this.headings[e.id].subheads.forEach((e=>this.updateLevel(e)))),this.removeSubhead(e.parent,e))}updateId(e,t=null){e&&(t&&this.setHeading(t,null),this.setHeading(e.id,e))}updateParent(e,t=null){e&&(t&&this.removeSubhead(t,e),this.addSubhead(e))}updateDefaultLevel(e,t=null){e&&this.updateLevel(e)}addSubhead(e){e&&(e.parent&&(this.headings[e.parent]||(this.headings[e.parent]={heading:null,subheads:[]}),this.headings[e.parent].subheads.includes(e)||this.headings[e.parent].subheads.push(e)),this.updateLevel(e))}removeSubhead(e,t){e&&this.headings[e]&&this.headings[e].subheads&&(this.headings[e].subheads=this.headings[e].subheads.filter((e=>e!=t)))}setHeading(e,t){e&&(this.headings[e]||(this.headings[e]={heading:null,subheads:[]}),this.headings[e].heading=t)}updateLevel(e){if(e){let t=e.parent&&this.headings[e.parent].heading?parseInt(this.headings[e.parent].heading.__level):null,a=t?Math.min(6,Math.max(t+1,1)):null,i=a||e.defaultLevel;e._setLevel(i),this.headings[e.id]&&this.headings[e.id].subheads.forEach((e=>this.updateLevel(e)))}}}customElements.define(RelativeHeadingStateManager.tag,RelativeHeadingStateManager);export{RelativeHeadingStateManager};