/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../../lit/index.js";import"./relative-heading-state-manager.js";class RelativeHeadingLite extends e{static get styles(){return[i`
        :host {
          display: block;
        }
        :host([hidden]) {
          display: none;
        }
      `]}render(){return this.template}static get properties(){return{...super.properties,defaultLevel:{type:Number,attribute:"default-level",reflect:!0},id:{type:String,attribute:"id",reflect:!0},parent:{type:String,attribute:"parent",reflect:!0},__level:{type:Number,attribute:"level",reflect:!0}}}static get tag(){return"relative-heading-lite"}get template(){return t` <slot></slot> `}constructor(){super(),this.parent=null,this.checkId(),this.__level=this.querySelector("h1,h2,h3,h4,h5,h6")?parseInt(this.querySelector("h1,h2,h3,h4,h5,h6").tagName.replace(/\D/,"")):1,this.defaultLevel=1}connectedCallback(){super.connectedCallback(),this.manager.addHeading(this),this.observer.observe(this,{childList:!0})}get observer(){return new MutationObserver((()=>this.updateContents()))}get manager(){return globalThis.RelativeHeadingStateManager.requestAvailability()}checkId(){this.id=this.id||`heading-${this._generateUUID()}`}updated(e){e.forEach(((e,t)=>{"defaultLevel"===t&&((!this.defaultLevel||this.defaultLevel<1||this.defaultLevel>6)&&(this.defaultLevel=Math.min(0,Math.max(this.defaultLevel,6))),this.manager.updateDefaultLevel(this,e)),"id"===t&&(this.id||this.checkId(),this.manager.updateId(this,e)),"parent"===t&&this.manager.updateParent(this,e),"__level"===t&&(this.observer.disconnect(),this.updateContents(),this.observer.observe(this,{childList:!0}))}))}_setLevel(e){this.__level!==e&&(this.__level=e)}updateContents(){(!this.querySelector(`h${this.__level}`)||this.children>0)&&(this.innerHTML=`<h${this.__level}>${this.children&&this.children[0]?this.children[0].innerHTML:this.textContent}</h${this.__level}>`)}_generateUUID(){return"ss-s-s-s-sss".replace(/s/g,Math.floor(65536*(1+Math.random())).toString(16).substring(1))}disconnectedCallback(){this.observer.disconnect(),this.manager.removeHeading(this),super.disconnectedCallback()}}customElements.define(RelativeHeadingLite.tag,RelativeHeadingLite);export{RelativeHeadingLite};