/**
 * Copyright 2022 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as s,css as e}from"../../../lit/index.js";export class PromiseProgressLite extends t{static get tag(){return"promise-progress-lite"}constructor(){super(),this.list=[],this.value=0,this.max=100,this.showCount=!1,this.canLoad=!1}static get styles(){let t=[];return super.styles&&(t=super.styles),[t,e`
        :host {
          display: block;
          position: relative;
        }
      `]}static get properties(){return{...super.properties,max:{type:Number},value:{type:Number,reflect:!0},list:{type:Array},showCount:{type:Boolean,attribute:"show-count"},canLoad:{type:Boolean}}}render(){return s`
      <progress
        part="progress"
        max="${this.max}"
        value="${this.value}"
      ></progress>
      ${this.list&&this.showCount?s`${this.value} / ${this.max}`:""}
      <slot></slot>
    `}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.loadingBar=this.shadowRoot.querySelector("progress")}updated(t){super.updated&&super.updated(t),t.forEach(((t,s)=>{["value","max"].includes(s)&&this.shadowRoot&&this.dispatchEvent(new CustomEvent(`${s}-changed`,{detail:{value:this[s]}})),"list"==s&&this[s]&&this[s].length>0&&this.max!==this.value&&(this.canLoad=!0)}))}async process(){const t=this.list;if(this.canLoad){var s=0;const e=await t.map((async t=>await t().then((t=>{s+=1,this.value=Math.round(s/this.list.length*100),this.loadingBar.textContent=`Loading ${this.value} of ${this.max}`,resolve(t)})).catch((t=>{reject(t)}))));await Promise.allSettled(e).then((()=>{this.loadingBar.textContent="Loading Finished",this.value=this.max,setTimeout((()=>{this.dispatchEvent(new CustomEvent("promise-progress-finished",{detail:{value:!0}}))}),100)}))}}}customElements.define(PromiseProgressLite.tag,PromiseProgressLite);