/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../lit/index.js";import"../simple-colors/simple-colors.js";import{LrndesignPie as r}from"../lrndesign-chart/lib/lrndesign-pie.js";class ProgressDonut extends r{static get styles(){return[super.styles,i`
        .ct-center-image {
          width: 100%;
          height: 100%;
          transform: translateX(25%) translateY(25%) scale(0.5);
          clip-path: circle(50% at 50% 50%);
        }

        .ct-center-ellipse {
          fill: var(--chartist-bg-color, #fff);
        }
      `]}render(){return e` ${super.render()}`}static get haxProperties(){return{canScale:!0,canEditSource:!0,gizmo:{title:"Progress Donut",description:"Progression donut",icon:"av:play-circle-filled",color:"grey",tags:["Other","Data"],handles:[],meta:{author:"HAXTheWeb core team"}},settings:{configure:[{property:"title",title:"Title",description:"The title of the element",inputMethod:"textfield",icon:"editor:title"},{property:"desc",title:"Description",description:"Accessible long description",inputMethod:"textfield"},{property:"imageSrc",title:"Image Source",description:"Source of image inside donut.",inputMethod:"haxupload",noVoiceRecord:!0,icon:"link",validationType:"url"},{property:"imageAlt",title:"Image Alt Text",description:"Alt text for image.",inputMethod:"alt"},{property:"animated",title:"Animated",description:"Whether progress animates on first load",inputMethod:"boolean"},{property:"complete",title:"Complete",description:"An array of completed values.",inputMethod:"array"},{property:"total",title:"Total",description:"Total when all items are complete.",inputMethod:"arrnumberay"},{property:"startAngle",title:"Start Angle",description:"Donut angle where progress starts",inputMethod:"number"}],advanced:[]}}}static get properties(){return{...super.properties,animation:{type:Number,attribute:"animation"},animationDelay:{type:Number,attribute:"animation-delay"},complete:{type:Array},desc:{type:String},imageSrc:{attribute:"image-src",type:String,reflect:!0},imageAlt:{attribute:"image-alt",type:String,reflect:!0}}}constructor(){super(),super.setProperties(),this.animation=-1,this.animationDelay=0,this.complete=[],this.desc="",this.imageSrc="",this.imageAlt="",this.donut=!1,this.showLabel=!1,this.showTable=!1,this.addEventListener("chartist-render-draw",this.addAnimation)}static get tag(){return"progress-donut"}disconnectedCallback(){this.removeEventListener("chartist-render-draw",this.addAnimation),super.disconnectedCallback()}addAnimation(t){let e=t&&t.detail?t.detail:void 0;if(this.animation>0&&e&&e.type&&"slice"===e.type){var i=e.value||this.donutTotal/this.donutData.length,r=this.animation*i/this.donutTotal;e.element.attr({c:1});var a={opacity:{id:"anim"+e.index,dur:r,from:-1,to:1,fill:"freeze"}};0!==e.index?a.opacity.begin="anim"+(e.index-1)+".end":a.opacity.begin=this.animationDelay,this.donutData.length>0&&(a.opacity.easing=Chartist.Svg.Easing.easeOutQuint),e.element.attr({opacity:-1}),e.element.animate(a,!1)}e&&e.index===this.complete.length-1&&this.chart&&(e.group.append(new Chartist.Svg("ellipse",{cx:"50%",cy:"50%",rx:"32%",ry:"32%"},"ct-center-ellipse")),e.group.append(new Chartist.Svg("image",{href:this.imageSrc,alt:this.imageAlt},"ct-center-image")))}get donutData(){return Array.isArray(this.complete)?this.complete:JSON.parse(this.complete||"[]")}get donutLabels(){return this.donutData.map(((t,e)=>`Item ${e+1}`))}get donutTotal(){return Math.max(this.donutData.reduce(((t,e)=>t+e)),this.total)}get options(){return super.options}updated(t){t.forEach(((t,e)=>{"complete"===e&&this.complete!==t&&(this.data=[this.donutLabels,this.donutData])})),super.updated(t)}}customElements.define(ProgressDonut.tag,ProgressDonut);export{ProgressDonut};