import{html as e,css as i}from"../../lit/index.js";import{SimpleColors as t}from"../simple-colors/simple-colors.js";import{IntersectionObserverMixin as r}from"../intersection-element/lib/IntersectionObserverMixin.js";import"../simple-icon/simple-icon.js";import"../simple-icon/lib/simple-icons.js";
/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */class ProductOffering extends(r(t)){constructor(){super(),this.alt="",this.accentColor="blue"}static get styles(){let e=[];return super.styles&&(e=super.styles),[e,i`
        :host {
          display: block;
          padding: var(--product-offering-padding, 25px);
          color: var(--product-offering-text-color, #000);
          font-family: var(--product-offering-font-family, Verdana, sans-serif);
        }
        .container {
          padding: 5%;
          display: grid;
          grid-template-columns: 25% 75%;
        }
        .image {
          height: var(--product-offering-image-height, 150px);
          width: var(--product-offering-image-width, 200px);
          border-radius: 2%;
        }
        simple-icon {
          padding: 8px;
          height: 30px;
          width: 30px;
        }
        .icon-background {
          background-color: var(
            --simple-colors-default-theme-accent-12,
            #eeeeee
          );
          border-radius: 50%;
          padding: 2px;
          margin: 5px;
          margin-right: 10px;
          box-shadow: 10px 10px 25px 0 rgb(0 0 0 / 10%);
        }
        .squareTitle {
          display: flex;
        }
        .underline {
          border-bottom: 5px solid orange;
          display: inline-block;
        }
        .sqaureDescription {
          color: var(--simple-colors-default-theme-accent-12, #eeeeee);
          font-size: 12pt;
          padding: 20px;
          padding-left: 60px;
          margin: 0;
        }
      `]}render(){return e`
      ${this.elementVisible?e` <!-- Container -->
            <div class="container">
              <img
                class="image"
                src="${this.source}"
                alt="${this.alt}"
                loading="lazy"
              />

              <div class="square">
                <!-- Icon, Header -->
                <div class="squareTitle">
                  <!-- icon -->
                  <div class="icon-background">
                    <simple-icon
                      accent-color="${this.accentColor}"
                      ?dark="${this.dark}"
                      .icon="${this.icon}"
                    ></simple-icon>
                  </div>
                  <!-- header -->
                  <h4>
                    <span class="underline">${this._titleOne}</span>&nbsp;<span
                      >${this._titleTwo}</span
                    >
                  </h4>
                </div>

                <!-- description -->
                <div class="sqaureDescription">
                  <slot name="description">${this.description}</slot>
                </div>
              </div>
            </div>`:""}
    `}static get tag(){return"product-offering"}static get properties(){return{...super.properties,alt:{type:String},source:{type:String},icon:{type:String},title:{type:String},_titleOne:{type:String},_titleTwo:{type:String},description:{type:String}}}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e)}updated(e){super.updated&&super.updated(e),e.forEach(((e,i)=>{if("title"===i)if(this.title.split(" ").length>1){const e=this.title.split(" ");this._titleOne=e.shift(),this._titleTwo=e.join(" ")}else this._titleOne=this.title}))}}customElements.define(ProductOffering.tag,ProductOffering);export{ProductOffering};