import{LitElement as e,html as t,css as a}from"../../../lit/index.js";import{haxElementToNode as s}from"../../utils/utils.js";import"../../simple-modal/simple-modal.js";import"../../hexagon-loader/hexagon-loader.js";import"../product-card.js";class HAXElementCardList extends e{constructor(){super(),this.showCardList=!1,this.list=[],this.filteredTags=[],this.value={},this.cols=2,this._layout="1-1-1",globalThis.SimpleModal.requestAvailability()}static get tag(){return"hax-element-card-list"}static get styles(){return[a`
        :host {
          display: block;
          min-height: 100px;
          --hexagon-color: var(--simple-colors-default-theme-light-blue-8);
        }
        :host([loading]) {
          border: 1px solid var(--simple-colors-default-theme-grey-6);
        }
        product-card {
          display: block;
          max-width: 100%;
          overflow-x: auto;
          --mdc-theme-on-primary: var(--simple-colors-default-theme-grey-1);
          --mdc-theme-primary: var(--simple-colors-default-theme-accent-8);
        }
        product-card[hidden] {
          display: none;
        }
        product-card div[slot="details-collapse-content"] {
          max-height: 125px;
          overflow-y: auto;
        }
        product-card label[slot="card-header"] {
          float: right;
          line-height: 1.5em;
        }
        button {
          text-transform: unset;
          margin-bottom: 5px;
        }
        .sr-only {
          position: absolute;
          left: -9999999999px;
          width: 0;
          overflow: hidden;
        }
        .grid {
          display: grid;
          align-items: stretch;
          grid-template-columns: var(--hax-element-card--cols, repeat(2, 1fr));
          grid-gap: var(--hax-element-card--gridGap, 15px);
          overflow-x: auto;
          padding: 2px;
        }
        hexagon-loader {
          margin: 0 auto;
          display: block;
        }
        .loaderText > strong {
          text-align: center;
          display: block;
        }
        .checkbox {
          height: 36px;
          width: 36px;
        }
      `]}static get properties(){return{list:{type:Array},enabled:{type:Object},filteredTags:{type:Object},cols:{type:Number},value:{type:Object},hidden:{type:Boolean},loading:{type:Boolean,reflect:!0},showCardList:{type:Boolean},_layout:{type:String}}}render(){return this.showCardList?t`
          <p class="loaderText" ?hidden="${!this.loading}">
            <strong
              >Scanning Web Component Registry for more HAX elements..</strong
            ><hexagon-loader
              item-count="4"
              ?loading="${this.loading}"
              size="small"
            ></hexagon-loader>
          </p>
          <div
            class="grid"
            style="--hax-element-card--cols: repeat(${this.cols}, 1fr)"
          >
            ${this.productList.map(((e,a)=>t`
                <product-card
                  .slot="col-${this.__getCol(a)}"
                  ?disabled="${!e.status}"
                  ?hidden="${!(this.filteredTags&&this.filteredTags.includes(e.tag))}"
                  ?has-demo="${e.schema.demoSchema}"
                  heading="${e.schema.gizmo.title}"
                  icon="${e.schema.gizmo.icon}"
                  subheading="${e.schema.gizmo.description}"
                  accent-color="${e.schema.gizmo.color}"
                  @product-card-demo-show="${e=>this.toggleShowDemo(e,a)}"
                  @product-card-demo-hide="${e=>this.toggleShowDemo(e,a)}"
                >
                  <label slot="card-header">
                    <span class="sr-only"
                      >${e.status?"Enabled":"Disabled"}</span
                    >
                    <input
                      class="checkbox"
                      type="checkbox"
                      ?checked="${e.status}"
                      @change="${t=>this.elementStatusChange(e)}"
                    />
                  </label>
                  <div slot="details-collapse-header">Details</div>
                  <div slot="details-collapse-content">
                    <ul>
                      <li>
                        <strong>Tags:</strong> ${e.schema.gizmo.tags.map((e=>t` ${e}, `))}
                      </li>
                      <li><strong>Tag name:</strong> <code>${e.tag}</code></li>
                      <li>
                        <strong>Developer usage:</strong>
                        <code>import "${e.file}";</code>
                      </li>
                      ${e.schema.gizmo.meta?t`
                            ${Object.keys(e.schema.gizmo.meta).map((a=>t`
                                <li>
                                  <strong>${this.capFirst(a)}:</strong>
                                  <span>${e.schema.gizmo.meta[a]}</span>
                                </li>
                              `))}
                          `:""}
                    </ul>
                  </div>
                  <div slot="demo-collapse-header">Demo</div>
                  <div slot="demo-collapse-content">
                    ${e.schema.demoSchema&&e.showDemo?t`
                          ${e.schema.demoSchema.map((e=>t`
                              <button
                                data-tag="${e.tag}"
                                outlined
                                @click="${this._viewDemo}"
                              >
                                Pop up demo
                              </button>
                              <div class="demo">
                                ${this._haxElementToNode(e)}
                              </div>
                              <code-sample copy-clipboard-button>
                                <template>
                                  ${this._haxElementToNode(e)}
                                </template>
                              </code-sample>
                            `))}
                        `:""}
                  </div>
                </product-card>
              `))}
          </div>
        `:""}get productList(){return this.list.map((e=>({tag:e.tag,file:e.file,schema:e.schema,showDemo:e.showDemo,status:!!this.value[e.tag]})))}_viewDemo(e){e.target&&e.target.nextElementSibling&&globalThis.dispatchEvent(new CustomEvent("simple-modal-show",{bubbles:!0,composed:!0,cancelable:!1,detail:{title:"Demo of "+e.target.getAttribute("data-tag"),styles:{"--simple-modal-width":"75vw","--simple-modal-max-width":"75vw","--simple-modal-z-index":"100000000","--simple-modal-min-height":"50vh"},elements:{content:e.target.nextElementSibling},invokedBy:e.target,clone:!0,modal:!0}}))}toggleShowDemo(e,t){this.list[t].showDemo=e.detail.expanded,this.requestUpdate()}_haxElementToNode(e){return e&&e.tag?(import("../../code-sample/code-sample.js"),s(e)):""}capFirst(e){return e.charAt(0).toUpperCase()+e.slice(1)}elementStatusChange(e,t){t||(t=!e.status),e.status=t,this._updateItem(e.tag,e.file,t),this.dispatchEvent(new CustomEvent("value-changed",{detail:this})),this.requestUpdate()}__getCol(e){for(e++;e>this.cols;)e-=this.cols;return e}_updateItem(e,t,a=!1){a?this.value[e]=t:delete this.value[e]}updated(e){e.forEach(((e,t)=>{if("list"==t&&this.dispatchEvent(new CustomEvent("hax-element-card-list-changed",{detail:{bubbles:!0,value:this[t]}})),"cols"==t)switch(this[t]){case 3:this._layout="1-1-1";break;case 4:this._layout="1-1-1-1";break;default:this._layout="1-1"}}))}}customElements.define(HAXElementCardList.tag,HAXElementCardList);export{HAXElementCardList};