/**
 * Copyright 2023
 * @license , see License.md for full text.
 */
import{LitElement as t,html as e,css as i,nothing as o}from"../../lit/index.js";import{unsafeHTML as s}from"../../lit/directives/unsafe-html.js";import"../../@shoelace-style/shoelace/dist/components/carousel/carousel.js";import"../../@shoelace-style/shoelace/dist/components/carousel-item/carousel-item.js";import"../simple-icon/lib/simple-icon-button-lite.js";import{generateStyleLinkEls as a}from"./lib/SLStyleManager.js";import{haxElementToNode as r,nodeToHaxElement as l,copyToClipboard as n}from"../utils/utils.js";class PlayList extends t{constructor(){super(),a(),this.items=[],this.loop=!1,this.edit=!1,this.navigation=!1,this.pagination=!1,this.aspectRatio="16:9",this.slide=0,this.orientation="horizontal",this._observer=new MutationObserver((t=>{clearTimeout(this._debounceMutations),this._debounceMutations=setTimeout((()=>{this.mirrorLightDomToItems()}),100)})),this._observer.observe(this,{childList:!0,subtree:!0})}async mirrorLightDomToItems(){let t=Array.from(this.children);1===t.length&&"TEMPLATE"===t[0].tagName&&(t=Array.from(t[0].children)),0!==t.length?await Promise.all(t.map((async t=>await l(t)))).then((t=>{this.items=t})):this.items=[]}renderHAXItem(t){return t.properties.innerHTML&&delete t.properties.innerHTML,e`${s(r(t).outerHTML)}`}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}disconnectedCallback(){this._linkEls&&(globalThis.document.head.removeChild(this._linkEls[0]),globalThis.document.head.removeChild(this._linkEls[1])),super.disconnectedCallback()}static get properties(){return{items:{type:Array},loop:{type:Boolean,reflect:!0},edit:{type:Boolean,reflect:!0},navigation:{type:Boolean,reflect:!0},pagination:{type:Boolean,reflect:!0},aspectRatio:{type:String,reflect:!0,attribute:"aspect-ratio"},orientation:{type:String,reflect:!0},slide:{type:Number,reflect:!0}}}static get styles(){let t=[];return super.styles&&(t=super.styles),[t,i`
        :host {
          display: block;
        }
        :host([orientation="vertical"]),
        :host([orientation="vertical"]) .carousel,
        :host([orientation="vertical"]) .carousel .item {
          max-height: 400px;
        }
        :host([orientation="vertical"]) .carousel .item video-player {
          max-height: 400px;
          width: 500px;
        }

        :host .carousel .item .play-list-item {
          width: 100%;
          min-height: 400px;
        }
        :host([orientation="vertical"]) .carousel::part(base) {
          grid-template-areas: "slides slides pagination";
        }
        :host([orientation="vertical"]) .carousel::part(pagination) {
          flex-direction: column;
        }
        :host([orientation="vertical"]) .carousel::part(navigation) {
          transform: rotate(90deg);
          display: flex;
        }
        sl-carousel-item {
          max-height: 400px;
          padding: 8px;
          overflow-y: auto;
          justify-content: unset;
        }
        simple-icon-button-lite {
          color: var(--play-list-icon-color, #999999);
          --simple-icon-width: 72px;
          --simple-icon-height: 72px;
          height: 72px;
          width: 72px;
        }

        /** edit mode, hax, etc */
        :host([edit]) .edit-wrapper {
          border: 2px dashed #999999;
          box-sizing: border-box;
          padding: 16px;
          background-color: #f5f5f5;
        }
        :host([edit]) .edit-wrapper::before {
          content: "Play list edit mode";
          display: block;
          font-size: 16px;
        }
        :host([edit]) .edit-wrapper ::slotted(*) {
          display: block;
          width: 100%;
          padding: 16px;
        }
      `]}render(){return e`
      ${this.items.length>0&&!this.edit?e`
            <sl-carousel
              ?navigation="${this.navigation&&"horizontal"===this.orientation}"
              ?pagination="${this.pagination}"
              ?loop="${this.loop}"
              orientation="${this.orientation}"
              @sl-slide-change="${this.slideIndexChanged}"
              class="carousel"
              style="--aspect-ratio: ${this.aspectRatio};"
            >
              <simple-icon-button-lite
                icon="hardware:keyboard-arrow-left"
                slot="previous-icon"
              ></simple-icon-button-lite>
              <simple-icon-button-lite
                icon="hardware:keyboard-arrow-right"
                slot="next-icon"
              ></simple-icon-button-lite>
              ${this.items.map(((t,i)=>e`
                  <sl-carousel-item class="item">
                    ${this.renderHAXItem(t)}
                  </sl-carousel-item>
                `))}
            </sl-carousel>
          `:e`<div class="edit-wrapper"><slot></slot></div>`}
    `}slideIndexChanged(t){this.slide=t.detail.index}static get tag(){return"play-list"}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.mirrorLightDomToItems()}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"edit"===e&&this[e],"slide"==e&&this.shadowRoot&&void 0!==t&&(this.dispatchEvent(new CustomEvent(`${e}-changed`,{detail:{value:this[e]}})),this.shadowRoot.querySelector(".carousel")&&(this.shadowRoot.querySelector(".carousel").activeSlide,this[e]))}))}haxHooks(){return{inlineContextMenu:"haxinlineContextMenu"}}haxClickSlideIndex(t){return n(this.slide),!0}haxinlineContextMenu(t){t.ceButtons=[{icon:"lrn:edit",callback:"haxToggleEdit",label:"Toggle edit mode"},{icon:"hax:anchor",callback:"haxClickSlideIndex",label:"Copy slide index"}]}haxToggleEdit(t){return this.edit=!this.edit,!0}}customElements.define(PlayList.tag,PlayList);export{PlayList};