import{SimpleColors as e}from"../simple-colors/simple-colors.js";import{html as t,css as r}from"../../lit/index.js";import"../simple-icon/simple-icon.js";import"../simple-icon/lib/simple-icons.js";class PlaceHolder extends e{static get styles(){return[super.styles,r`
        :host {
          display: block;
          border: none;
          transition: 0.3s all linear;
        }
        :host([drag-over]) {
          border: var(--place-holder-drag-over-border, 4px dashed #2196f3);
        }
        .wrapper {
          text-align: center;
          padding: 16px;
          color: var(--simple-colors-default-theme-accent-12, #222222);
          background-color: var(
            --simple-colors-default-theme-accent-1,
            #eeeeee
          );
        }
        simple-icon {
          margin: 0 auto;
          --simple-icon-width: 50%;
          --simple-icon-height: 50%;
          display: block;
        }
        .text {
          line-height: 24px;
          font-size: 24px;
        }
        .directions {
          line-height: 16px;
          font-size: 16px;
          font-style: italic;
        }
      `]}render(){return t`
      <div class="wrapper">
        <simple-icon
          ?dark="${this.dark}"
          icon="${this.iconFromType}"
          accent-color="${this.accentColor}"
        ></simple-icon>
        <div class="text">${this.calcText}</div>
        <div class="directions">${this.directions}</div>
      </div>
    `}static get tag(){return"place-holder"}static get properties(){return{...super.properties,iconFromType:{type:String},text:{type:String},directions:{type:String},calcText:{type:String},type:{type:String},dragOver:{type:Boolean,reflect:!0,attribute:"drag-over"}}}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{["type"].includes(t)&&(this.accentColor=this._getColorFromType(this.type)),["type","dragOver"].includes(t)&&(this.iconFromType=this._getIconFromType(this.type,this.dragOver)),["text","type","dragOver"].includes(t)&&(this.calcText=this._getCalcText(this.text,this.type,this.dragOver))}))}fireReplaceEvent(e){this.dispatchEvent(new CustomEvent("place-holder-replace",{bubbles:!0,cancelable:!0,composed:!0,detail:this.type}))}_getCalcText(e,t,r){return r?"Drop file to upload":""===e?"Placeholder for "+t:e}_getColorFromType(e){switch(e){case"document":return"green";case"audio":return"purple";case"video":return"red";case"image":return"orange";case"math":return"light-blue"}return"indigo"}_getIconFromType(e,t){if(t)return"icons:file-upload";switch(e){case"document":return"editor:insert-drive-file";case"audio":return"av:music-video";case"video":return"notification:ondemand-video";case"image":return"image:crop-original";case"math":return"editor:functions";default:return"editor:format-align-left"}}constructor(){super(),this.text="",this.iconFromType="editor:format-align-left",this.type="text",this.dragOver=!1,this.directions="Drag and drop file to replace",this.addEventListener("dragover",(function(e){this.dragOver=!0,e.preventDefault(),e.stopPropagation(),this.classList.add("dragover")})),this.addEventListener("dragleave",(function(e){this.dragOver=!1,e.preventDefault(),e.stopPropagation(),this.classList.remove("dragover")})),this.addEventListener("drop",(function(e){this.dragOver=!1,e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation(),this.classList.remove("dragover");try{"file"===e.dataTransfer.items[0].kind&&(e.placeHolderElement=this,this.dispatchEvent(new CustomEvent("place-holder-file-drop",{bubbles:!0,cancelable:!0,composed:!0,detail:e})))}catch(e){}}))}static get haxProperties(){return{canScale:!1,canEditSource:!1,gizmo:{title:"Placeholder",description:"A place holder that can be converted into the media type that's been selected",icon:"hax:placeholder-image",color:"grey",tags:["Authoring","development","authoring","media","image","video","audio","document","math","text"],handles:[],meta:{author:"HAXTheWeb core team"}},settings:{configure:[{property:"type",title:"Type",description:"Type of gizmo that this accepts for replacement.",inputMethod:"select",options:{text:"Text / content",document:"Document / file",audio:"Audio",video:"Video",image:"Image",math:"Math"}},{property:"text",title:"Text",description:"Identify the place holder desired in greater detail",inputMethod:"textfield"}],advanced:[]},saveOptions:{unsetAttributes:["icon-from-type","calc-text","colors"],wipeSlot:!0},demoSchema:[{tag:"place-holder",properties:{type:"image"},content:""}]}}}customElements.define(PlaceHolder.tag,PlaceHolder);export{PlaceHolder};