import{html as e,PolymerElement as t}from"../../@polymer/polymer/polymer-element.js";import"../../@polymer/polymer/lib/elements/dom-if.js";import"../simple-icon/simple-icon.js";import"../simple-icon/lib/simple-icons.js";
/**
@license
Copyright (c) 2016 The Ingresso Rápido Web Components Authors. All rights reserved.
This code may only be used under the BSD style license found at http://ingressorapidowebcomponents.github.io/LICENSE.txt
The complete set of authors may be found at http://ingressorapidowebcomponents.github.io/AUTHORS.txt
The complete set of contributors may be found at http://ingressorapidowebcomponents.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/class PdfBrowserViewer extends t{static get template(){return e`
      <style>
        :host {
          display: none;
        }
        :host([file]) {
          display: inherit;
        }
        div.card {
          box-shadow: 0 5px 5px rgba(0, 0, 0, 0.7);
        }
      </style>

      <template is="dom-if" if="[[card]]">
        <div heading="[[heading]]" elevation="[[elevation]]">
          <div class="card-content">
            <object
              data="[[file]]"
              type="application/pdf"
              width="[[width]]"
              height="[[height]]"
            >
              <p>
                {{notSupportedMessage}}
                <a href="[[file]]">{{notSupportedLinkMessage}}</a>
              </p>
            </object>
          </div>
          <div class="card-actions">
            <button on-click="_download">[[downloadLabel]]</button>
          </div>
        </div>
      </template>

      <template is="dom-if" if="[[!card]]">
        <object
          data="[[file]]"
          type="application/pdf"
          width="[[width]]"
          height="[[height]]"
        >
          <p>
            {{notSupportedMessage}}
            <a href="[[file]]">{{notSupportedLinkMessage}}</a>
          </p>
        </object>
      </template>
    `}static get tag(){return"pdf-browser-viewer"}static get properties(){return{file:{type:String,value:void 0,reflectToAttribute:!0},notSupportedMessage:{type:String,value:"It appears your Web browser is not configured to display PDF files. No worries, just"},notSupportedLinkMessage:{type:String,value:"click here to download the PDF file."},height:{type:String,value:"400px"},width:{type:String,value:"100%"},card:{type:Boolean,value:!1},downloadLabel:{type:String,value:"Download"},elevation:{type:String,value:"1"}}}clear(){this.file=void 0}_download(){globalThis.location=this.file}}customElements.define(PdfBrowserViewer.tag,PdfBrowserViewer);export{PdfBrowserViewer};