import{LitElement as a,html as e,css as t}from"../../lit/index.js";import{SchemaBehaviors as r}from"../schema-behaviors/schema-behaviors.js";class ParallaxImage extends(r(a)){static get styles(){return[t`
        :host {
          display: block;
          --parallax-image-background: "";
          --parallax-title-background: rgba(0, 0, 0, 0.3);
          --parallax-title-font: #fff;
        }

        .parallax_container {
          height: 400px;
          width: 100%;
          overflow: hidden;
          display: flex;
          justify-content: center;
        }

        .parallax {
          background-image: var(--parallax-image-background);
          background-attachment: fixed;
          background-position: top center;
          background-repeat: no-repeat;
          background-size: cover;
          width: 100%;
          height: 100%;
          justify-content: center;
        }

        #bgParallax {
          display: flex;
          align-items: center;
        }

        .title {
          background: var(--parallax-title-background);
          display: block;
          padding: 20px 15px;
          text-align: center;
          width: 40%;
          color: var(--parallax-title-font);
          font-size: 32px;
          position: absolute;
          margin-top: 120px;
        }

        @media screen and (max-width: 900px) {
          .title {
            font-size: 16px;
          }
        }
      `]}render(){return e`
      <div
        class="parallax_container"
        aria-describedby="${this.describedBy||""}"
      >
        <div id="bgParallax" class="parallax">
          <div class="title" id="titleParallax">
            <slot name="parallax_heading"></slot>
          </div>
        </div>
      </div>
    `}static get tag(){return"parallax-image"}static get properties(){return{...super.properties,imageBg:{type:String,attribute:"image-bg",reflect:!0},describedBy:{type:String,attribute:"described-by"}}}constructor(){super(),this.windowControllers=new AbortController,this.imageBg=""}updated(a){a.forEach(((a,e)=>{"imageBg"==e&&this.style.setProperty("--parallax-image-background",`url(${this.imageBg})`)}))}scrollBy(a){const e=this.shadowRoot.querySelector("#bgParallax"),t=this.shadowRoot.querySelector("#titleParallax"),r=-.2*globalThis.scrollY,i=1.4*r;e.style.backgroundPosition=`center ${r}px`,t.style.transform=`translate3D(0, ${i}px, 0)`}connectedCallback(){super.connectedCallback(),setTimeout((()=>{globalThis.addEventListener("scroll",this.scrollBy.bind(this),{signal:this.windowControllers.signal})}),0)}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback()}static get haxProperties(){return{canScale:!0,canEditSource:!0,gizmo:{title:"Parallax image",description:"Image scroll by",icon:"av:play-circle-filled",color:"grey",tags:["Images","Media","style"],handles:[{type:"image",url:"source"}],meta:{author:"HAXTheWeb core team"}},settings:{configure:[{property:"imageBg",title:"Image",description:"image to be involved in the background",inputMethod:"haxupload",noVoiceRecord:!0},{slot:"parallax_heading",title:"Heading area",description:"Heading text area",inputMethod:"textarea"}],advanced:[]}}}}customElements.define(ParallaxImage.tag,ParallaxImage);export{ParallaxImage};