/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as s}from"../../lit/index.js";import"../simple-icon/simple-icon.js";import"../simple-icon/lib/simple-icons.js";import"../simple-tooltip/simple-tooltip.js";import"../simple-fields/lib/simple-fields-field.js";class PaperInputFlagged extends e{static get styles(){return[s`
        :host {
          display: block;
        }
        simple-icon {
          transition: 0.6s all ease-in;
          width: 24px;
          height: 24px;
          margin-right: 4px;
        }
        simple-tooltip {
          --simple-tooltip-delay-in: 100;
          font-size: 11px;
        }
        #icon {
          color: var(--paper-grey-400);
          background-color: transparent;
        }
        :host([status="info"]) #icon {
          color: var(--paper-green-400);
        }
        :host([status="notice"]) #icon {
          color: var(--paper-grey-400);
        }
        :host([status="warning"]) #icon {
          color: var(--paper-yellow-700);
        }
        :host([status="error"]) #icon {
          color: var(--paper-red-900);
        }
        .element-invisible {
          position: absolute !important;
          clip: rect(1px, 1px, 1px, 1px);
          overflow: hidden;
          height: 1px;
        }
      `]}constructor(){super(),this.disabled=!1,this.label="",this.value="",this.inputSuccess={message:"You passed our simple accessibility checks.",status:"info"},this.flaggedInput=[{match:null,message:"Alt data is required for everything except decoration images.",status:"notice"},{match:"image",message:"Screenreaders will say the word image, don't put it in the descriptive text",status:"error"},{match:"photo",message:"Screenreaders will say the word image, don't put photo in the descriptive text",status:"error"},{match:"picture",message:"Screenreaders will say the word image, don't put picture in the descriptive text",status:"error"},{match:3,message:"Description not effective enough. This should be at least a sentance about what the image is.",status:"error"},{match:10,message:"Make sure your alt text is descriptive enough for those that can't see the media.",status:"warning"}]}updated(e){e.forEach(((e,t)=>{if(["value"].includes(t)){let e=`${t.replace(/([a-z0-9]|(?=[A-Z]))([A-Z])/g,"$1-$2").toLowerCase()}-changed`;this.dispatchEvent(new CustomEvent(e,{detail:{value:this[t]}}))}"status"==t&&(this.icon=this._iconFromStatus(this.status)),"flaggedInput"!=t&&"value"!=t||(this.status=this.testStatus(this.flaggedInput,this.value))}))}valueEvent(e){this.value=e.detail.value}render(){return t`
      <simple-fields-field
        label="${this.label}"
        value="${this.value}"
        @value-changed="${this.valueEvent}"
        ?char-counter="${this.charCounter}"
        ?disabled="${this.disabled}"
        minlength="${this.minlength}"
        maxlength="${this.maxlength}"
      >
        <simple-icon id="icon" icon="${this.icon}" slot="prefix"></simple-icon>
      </simple-fields-field>
      <div class="element-invisible">${this.__activeMessage}</div>
      <simple-tooltip
        for="icon"
        position="top"
        offset="20"
        fit-to-visible-bounds
      >
        ${this.__activeMessage}
      </simple-tooltip>
    `}static get tag(){return"paper-input-flagged"}static get properties(){return{label:{type:String},disabled:{type:Boolean},icon:{type:String},maxlength:{type:Number},minlength:{type:Number},status:{type:String,reflect:!0},value:{type:String},flaggedInput:{type:Array,attribute:"flagged-input"},inputSuccess:{type:Object,attribute:"input-success"},__activeMessage:{type:String}}}testStatus(e,t){for(var s in e){if(null===e[s].match&&(""===t||null===t))return this.__activeMessage=e[s].message,e[s].status;if(!isNaN(e[s].match)&&t.split(/\s+/g).length<parseInt(e[s].match))return this.__activeMessage=e[s].message,e[s].status;if(t.toLowerCase().includes(e[s].match))return this.__activeMessage=e[s].message,e[s].status}return this.__activeMessage=this.inputSuccess.message,this.inputSuccess.status}_iconFromStatus(e){switch(e){case"error":return"icons:error";case"warning":case"notice":return"icons:warning";case"info":return"icons:info-outline";default:return"icons:info"}}}customElements.define(PaperInputFlagged.tag,PaperInputFlagged);export{PaperInputFlagged};