import{LitElement as t,html as e,css as i}from"../../lit/index.js";import"../es-global-bridge/es-global-bridge.js";import"../simple-icon/lib/simple-icon-lite.js";import"../simple-icon/lib/simple-icons.js";import*as a from"./lib/md5.min.js";class PaperAvatar extends t{static get styles(){return[i`
        :host {
          display: inline-block;
          box-sizing: border-box;
          position: relative;
          width: var(--paper-avatar-width, 40px);
          height: var(--paper-avatar-width, 40px);
          border-radius: 50%;
          cursor: default;
          -webkit-user-select: none;
          -moz-user-select: none;
          -ms-user-select: none;
          user-select: none;
          color: var(--paper-avatar-text-color, #ffffff);
          background-color: var(
            --paper-avatar-color,
            var(--paper-avatar-calculated-bg, #000)
          );
        }

        :host > * {
          pointer-events: none;
        }
        img {
          width: var(--paper-avatar-width, 40px);
          height: var(--paper-avatar-width, 40px);
        }
        #label,
        #img,
        #jdenticon {
          position: absolute;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          width: 100%;
          height: 100%;
          border-radius: 50%;
        }
        #label {
          overflow: hidden;
          display: -ms-flexbox;
          display: -webkit-flex;
          display: flex;
          -webkit-flex-direction: row;
          -ms-flex-direction: row;
          flex-direction: row;
          -webkit-align-items: center;
          -ms-flex-align: center;
          align-items: center;
          --simple-icon-width: calc(var(--paper-avatar-width, 40px) * 0.9);
          --simple-icon-height: calc(var(--paper-avatar-width, 40px) * 0.9);
        }
        #label[hidden] {
          display: none;
        }
        #label span {
          display: block;
          width: 100%;
          font-weight: 400;
          color: var(--paper-avatar-text-color, #ffffff);
          text-transform: capitalize;
          font-family: "Roboto", "Noto", sans-serif;
          -webkit-font-smoothing: antialiased;
          text-align: center;
          font-size: calc(var(--paper-avatar-width, 40px) * 0.7);
          opacity: 0.8;
        }
        #label span[two-chars] {
          font-size: calc(var(--paper-avatar-width, 40px) * 0.5);
        }
        #label simple-icon-lite {
          margin: 0 auto;
          opacity: 0.8;
        }
        #jdenticon {
          width: var(--paper-avatar-width, 40px);
          height: var(--paper-avatar-width, 40px);
        }
        #jdenticon * {
          fill: var(--paper-avatar-text-color, #ffffff);
          opacity: 0.8;
        }
        :host #jdenticon ::slotted(*) {
          fill: var(--paper-avatar-text-color, #ffffff);
          opacity: 0.8;
        }
      `]}static get tag(){return"paper-avatar"}render(){return e`
      <svg id="jdenticon" width="40" height="40"><slot></slot></svg>
      <div
        id="label"
        title="${this.label}"
        ?hidden="${this.jdenticonExists&&this.jdenticon}"
      >
        ${this.icon?e` <simple-icon-lite icon="${this.icon}"></simple-icon-lite> `:e`
              <span ?two-chars="${this.twoChars}"
                >${this._label(this.label)}
              </span>
            `}
      </div>
      ${this.src?e`
            <img
              id="img"
              loading="lazy"
              .src="${this.src||""}"
              @load="${this._onImgLoad}"
              @error="${this._onImgError}"
              aria-hidden="true"
            />
          `:""}
    `}constructor(){super(),this.windowControllers=new AbortController,this.dark=!1,this.label=null,this.src=null,this.jdenticonExists=!1,this.twoChars=!1,this.jdenticon=!1}updated(t){t.forEach(((t,e)=>{"label"==e&&this._observerLabel(this[e])}))}static get properties(){return{accentColor:{type:String,attribute:"accent-color"},dark:{type:Boolean},icon:{type:String},src:{type:String},label:{type:String},jdenticonExists:{type:Boolean},twoChars:{type:Boolean,attribute:"two-chars"},colors:{type:Array},jdenticon:{type:Boolean}}}_observerLabel(t){t&&(this.jdenticonExists&&this.jdenticon&&(this.shadowRoot.querySelector("#label").hidden=!0,window.jdenticon.update(this.shadowRoot.querySelector("#jdenticon"),window.md5(t))),this.accentColor||this.style.setProperty("--paper-avatar-calculated-bg",this._parseColor(t)))}firstUpdated(t){const e=new URL("./lib/jdenticon-1.4.0.min.js",import.meta.url).href;window.addEventListener("es-bridge-jdenticon-loaded",this._jdenticonLoaded.bind(this),{signal:this.windowControllers.signal}),window.ESGlobalBridge.requestAvailability().load("jdenticon",e)}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback()}_jdenticonLoaded(t){this.jdenticonExists=!0,this._observerLabel(this.label)}_label(t){if(!t)return"";if(this.twoChars){if(this.label.indexOf(" ")>-1){var e=this.label.match(/\b(\w)/g);return e[0]+e[1]}return t.substring(0,2)}return t.charAt(0)}_onImgLoad(t){t.currentTarget.hidden=!1}_onImgError(t){t.currentTarget.hidden=!0}_parseColor(t){for(var e=this.colors?this.colors:["#F44336","#E91E63","#9C27B0","#673AB7","#3F51B5","#2196F3","#03A9F4","#00BCD4","#795548","#009688","#4CAF50","#8BC34A","#CDDC39","#FFEB3B","#FFC107","#FF9800","#FF5722","#9E9E9E","#607D8B"],i=0,a=0;a<t.length;a++)i+=t.charCodeAt(a)<<5;return i>=e.length?e[i%e.length]:e[i]}}customElements.define(PaperAvatar.tag,PaperAvatar);export{PaperAvatar};