/**
 * Copyright 2023 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t}from"../../lit/index.js";import{SimpleColors as a}from"../simple-colors/simple-colors.js";import"../absolute-position-behavior/absolute-position-behavior.js";import"./lib/page-flag-comment.js";class PageFlag extends a{constructor(){super(),this.label="note",this.opened=!1,this.accentColor="cyan",this.show=!1,this._haxState=!1}static get properties(){return{...super.properties,label:{type:String},opened:{type:Boolean,reflect:!0},show:{type:Boolean,reflect:!0}}}static get styles(){let e=[];return super.styles&&(e=super.styles),[e,t`
        :host {
          display: none;
          float: right;
          z-index: var(--simple-modal-z-index, 1000);
          margin-right: -80px;
          position: relative;
        }
        :host([show]) {
          display: block;
        }
        .arrow {
          border: 3px solid var(--simple-colors-default-theme-accent-4, #97d4e8);
          border-radius: 4px;
          background: var(--simple-colors-default-theme-accent-1, #c8e7f1);
          color: var(--simple-colors-default-theme-accent-8, #2d7187);
          padding: 8px;
          text-align: center;
          max-width: 100px;
          font-size: 11px;
          font-weight: bold;
          position: relative;
          cursor: pointer;
        }

        .arrow::after,
        .arrow::before {
          border: solid transparent;
          content: " ";
          display: block;
          height: 0;
          position: absolute;
          pointer-events: none;
          width: 0;
          right: 100%;
        }
        .arrow::before {
          border-color: rgba(255, 255, 255, 0);
          border-right-color: var(
            --simple-colors-default-theme-accent-4,
            #97d4e8
          );
          top: 50%;
          margin-top: -14px;
          border-width: 14px;
        }
        .arrow::after {
          border-color: rgba(255, 255, 255, 0);
          border-right-color: var(
            --simple-colors-default-theme-accent-1,
            #c8e7f1
          );
          top: 50%;
          margin-top: -10px;
          border-width: 10px;
        }
        absolute-position-behavior {
          z-index: var(--simple-modal-z-index, 1000);
          min-width: 280px;
        }
        absolute-position-behavior div {
          color: black;
          background-color: white;
          font-size: 12px;
          width: 300px;
          margin-left: 160px;
          padding-top: 8px;
        }
      `]}toggleOpen(e){this.opened=!this.opened,this.dark=this.opened,this.querySelectorAll("page-flag-comment").forEach((e=>{e.testCanUpdate(pageFlagManager.activeUser),e.readOnly=!this._haxState}))}render(){return e` <button class="arrow" @click="${this.toggleOpen}">
        ${this.label}
      </button>
      <absolute-position-behavior
        justify
        position="bottom"
        allow-overlap
        auto
        ?hidden="${!this.opened}"
      >
        <div
          @page-flag-comment-edit="${this.handleEdit}"
          @page-flag-comment-delete="${this.handleDelete}"
          @page-flag-comment-reply="${this.handleReply}"
        >
          <slot></slot>
        </div>
      </absolute-position-behavior>`}handleEdit(e){e.detail.editMode=!e.detail.editMode}handleDelete(e){e.detail.remove(),0===this.querySelectorAll("page-flag-comment").length&&this.remove()}handleReply(e){const t=globalThis.document.createElement("page-flag-comment");t.seed=pageFlagManager.activeUser,t.timestamp=Date.now()/1e3,t.canEdit=!0,t.readOnly=!1,t.reply=e.detail.reply+1<2?e.detail.reply+1:2,e.detail.insertAdjacentElement("afterend",t),setTimeout((()=>{t.editMode=!0}),0)}static get tag(){return"page-flag"}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}haxeditModeChanged(e){this.show=e,this._haxState=e}haxHooks(){return{editModeChanged:"haxeditModeChanged",inlineContextMenu:"haxinlineContextMenu"}}haxinlineContextMenu(e){e.ceButtons=[{icon:"lrn:discuss",callback:"haxResolveThread",label:"Resolve thread"}]}haxResolveThread(e){return this.remove(),!0}firstUpdated(e){if(super.firstUpdated&&super.firstUpdated(e),pageFlagManager.allFlags.push(this),pageFlagManager.activeUser?this.show=!0:this.remove(),this.shadowRoot.querySelector("absolute-position-behavior").target=this.shadowRoot.querySelector(".arrow"),!this.querySelector("page-flag-comment")){const e=globalThis.document.createElement("page-flag-comment");e.seed=pageFlagManager.activeUser,e.timestamp=Date.now()/1e3,e.canEdit=!0,e.readOnly=!1,this.appendChild(e),setTimeout((()=>{e.editMode=!0}),100)}}}customElements.define(PageFlag.tag,PageFlag);export{PageFlag};export class pageFlagManagerEl extends HTMLElement{static get tag(){return"page-flag-manager"}constructor(){super(),this.windowControllers=new AbortController,this.activeUser=null,this.allFlags=[]}connectedCallback(){globalThis.addEventListener("haxcms-user-data-updated",this.userDataUpdated.bind(this),{signal:this.windowControllers.signal})}disconnectedCallback(){this.windowControllers.abort()}userDataUpdated(e){this.activeUser=e.detail.userName,this.allFlags.forEach((e=>{e.show=!0}))}}customElements.define(pageFlagManagerEl.tag,pageFlagManagerEl),globalThis.pageFlagManager=globalThis.pageFlagManager||{},globalThis.pageFlagManager.requestAvailability=()=>(globalThis.pageFlagManager.instance||(globalThis.pageFlagManager.instance=globalThis.document.createElement(pageFlagManagerEl.tag),globalThis.document.body.appendChild(globalThis.pageFlagManager.instance)),globalThis.pageFlagManager.instance);export const pageFlagManager=globalThis.pageFlagManager.requestAvailability();