import{LitElement as e,css as t,html as i}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icon-button.js";import"../../simple-icon/lib/simple-icons.js";import"../../rpg-character/rpg-character.js";import"../../simple-datetime/simple-datetime.js";import"../../simple-fields/lib/simple-fields-field.js";import"../../simple-picker/lib/simple-emoji-picker.js";export class PageFlagComment extends e{static get tag(){return"page-flag-comment"}static get properties(){return{seed:{type:String},timestamp:{type:Number},mood:{type:String},editMode:{type:Boolean,reflect:!0,attribute:"edit-mode"},canEdit:{type:Boolean},reply:{type:Number,reflect:!0},readOnly:{type:Boolean}}}testCanUpdate(e){this.seed===e?this.canEdit=!0:this.canEdit=!1}constructor(){super(),this.mood=null,this.seed="abc123",this.timestamp=Date.now()/1e3,this.reply=0,this.editMode=!1,this.canEdit=!1,this.readOnly=!0,this.haxUIElement=!0}deleteOp(){this.dispatchEvent(new CustomEvent("page-flag-comment-delete",{bubbles:!0,cancelable:!0,detail:this}))}replyOp(){this.dispatchEvent(new CustomEvent("page-flag-comment-reply",{bubbles:!0,cancelable:!0,detail:this}))}editOp(){this.dispatchEvent(new CustomEvent("page-flag-comment-edit",{bubbles:!0,cancelable:!0,detail:this}))}render(){return i`
      <div class="comment">
        ${this.editMode?i`<simple-emoji-picker
              align-right
              label="Reaction"
              value="${this.mood}"
              @value-changed="${this.emojiChanged}"
            ></simple-emoji-picker>`:i`<div class="emoji" .innerHTML="${this.mood}"></div>`}
        <div class="comment__header">
          <div class="comment__header__avatar">
            <rpg-character
              seed="${this.seed}"
              width="40"
              height="40"
              hat="${this.editMode?"edit":"none"}"
            ></rpg-character>
          </div>
          <div class="comment__header__info">
            <div class="comment__header__info__name">${this.seed}</div>
            <div class="comment__header__info__date">
              <simple-datetime
                format="m/j/y h:i"
                .timestamp="${this.timestamp}"
                unix
              ></simple-datetime>
            </div>
          </div>
        </div>
        <div class="comment__body">
          <simple-fields-field type="textarea"></simple-fields-field>
          <slot></slot>
        </div>
        <div class="comment__footer">
          <div class="comment__footer__actions">
            ${this.readOnly?"":i`
                  ${this.canEdit?i`<simple-icon-button
                        icon="${this.editMode?"save":"editor:mode-edit"}"
                        title="${this.editMode?"Edit":"Update"}"
                        @click="${this.editOp}"
                      ></simple-icon-button> `:""}
                  <simple-icon-button
                    icon="reply"
                    title="Reply"
                    @click="${this.replyOp}"
                  ></simple-icon-button>
                  ${this.canEdit?i`<simple-icon-button
                        icon="delete"
                        title="Delete"
                        @click="${this.deleteOp}"
                      ></simple-icon-button>`:""}
                `}
          </div>
        </div>
      </div>
    `}emojiChanged(e){this.mood=e.detail.value}firstUpdated(e){super.firstUpdated(e),this.shadowRoot.querySelector("simple-fields-field").value=this.innerHTML}updated(e){super.updated(e),e.forEach(((e,t)=>{"editMode"==t&&void 0!==e&&(this[t]?(this.shadowRoot.querySelector("simple-fields-field").value=this.innerHTML,setTimeout((()=>{this.shadowRoot.querySelector("simple-fields-field").focus(),this.shadowRoot.querySelector("simple-fields-field").select()}),0)):this.innerHTML=this.shadowRoot.querySelector("simple-fields-field").value)}))}static get styles(){return[,t`
        :host {
          display: block;
        }
        :host slot {
          display: block;
        }
        :host simple-emoji-picker,
        :host simple-fields-field {
          display: none;
        }
        :host([edit-mode]) simple-emoji-picker,
        :host([edit-mode]) simple-fields-field {
          display: block;
        }
        simple-emoji-picker {
          float: right;
          width: 40px;
        }
        .emoji {
          float: right;
          width: 40px;
          height: 40px;
          font-size: 32px;
        }
        :host([edit-mode]) slot {
          display: none;
        }
        :host([reply="1"]) .comment {
          margin-left: 16px;
        }
        :host([reply="2"]) .comment {
          margin-left: 32px;
        }
        .comment {
          background-color: #fff;
          border-radius: 5px;
          box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
          padding: 10px;
          margin-bottom: 10px;
        }
        simple-icon-button {
          --simple-icon-height: 16px;
          --simple-icon-width: 16px;
          margin: 0 6px;
        }
        .comment__header {
          display: flex;
          align-items: center;
          margin-bottom: 10px;
        }
        .comment__header__avatar {
          width: 40px;
          height: 40px;
          border-radius: 50%;
          overflow: hidden;
          border: 2px solid black;
          margin-right: 8px;
        }
        .comment__header__info {
          display: flex;
          flex-direction: column;
        }
        .comment__header__info__name {
          font-weight: bold;
          font-size: 14px;
        }
        .comment__header__info__date {
          font-size: 12px;
          color: #999;
        }
        .comment__body {
          margin-bottom: 10px;
        }
        .comment__footer {
          display: flex;
          justify-content: flex-end;
        }
        .comment__footer__actions {
          display: flex;
        }
        .comment__footer__actions__button {
          background-color: transparent;
          border: none;
          color: #999;
          font-size: 12px;
          cursor: pointer;
          margin-left: 10px;
        }
      `]}}customElements.define(PageFlagComment.tag,PageFlagComment);