/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../lit/index.js";import{normalizeEventPath as i}from"../utils/utils.js";import{DDD as n}from"../d-d-d/d-d-d.js";class PageContentsMenu extends n{static get styles(){return[e`
        :host {
          display: block;
          font-family: var(--ddd-font-navigation);
          font-weight: var(--ddd-font-weight-light);
          --page-contents-menu-link-color-focus: light-dark(
            var(--ddd-theme-default-link),
            var(--ddd-theme-default-linkLight)
          );
          --page-contents-menu-link: light-dark(black, var(--ddd-accent-6));
          --page-contents-menu-link-font-size: var(--ddd-font-size-3xs);
          --page-contents-menu-link-font-size-active: var(--ddd-font-size-xxs);
          --page-contents-menu-link-font-size-focus: var(--ddd-font-size-3xs);
        }
        :host([is-empty][hide-if-empty]) {
          display: none;
        }
        :host([hidden]) {
          display: none;
        }
        [hidden] {
          display: none;
        }
        :host([mobile]) .wrapper,
        :host([mobile]) .header,
        :host([mobile]) .header .svg {
          padding: 0;
          margin: 0;
          width: unset;
        }
        .wrapper {
          display: block;
          margin-bottom: 16px;
        }
        .header {
          display: flex;
          padding: 0 24px 0 0;
          margin: 0 0 8px 0;
        }
        .header .svg {
          padding-right: 6px;
          display: inline-flex;
          color: var(--page-contents-menu-link, black);
        }
        svg {
          width: 32px;
          height: 32px;
          vertical-align: middle;
        }
        .header .label {
          align-items: center;
          display: inline-flex;
          font-size: var(
            --page-contents-menu-heading-font-size,
            var(--ddd-font-size-4xs)
          );
          font-weight: var(
            --page-contents-menu-heading-font-weight,
            var(--ddd-font-weight-bold)
          );
          padding: 0;
          margin: 0;
          line-height: 1;
          letter-spacing: 1.2px;
          text-transform: uppercase;
        }

        .contents {
          margin: 0;
          padding: 0;
          list-style-type: none;
          overflow-y: auto;
          max-height: 50vh;
        }
        .item {
          margin: 0;
          display: block;
          padding: 0;
          overflow: hidden;
          white-space: nowrap;
          text-overflow: ellipsis;
        }
        .link {
          display: flex;
          padding: 4px 16px 4px 24px;
          font-size: var(--page-contents-menu-link-font-size, 10px);
          text-decoration: none;
          font-weight: var(--page-contents-menu-link-font-weight, 500);
          color: var(--page-contents-menu-link, black);
          cursor: pointer;
          margin: 0px;
          align-items: center;
          vertical-align: middle;
          -webkit-box-align: center;
          overflow: hidden;
          white-space: nowrap;
          text-overflow: ellipsis;
          transition:
            font 0.3s ease-in-out,
            border 0.1s ease-in-out;
          border-left: rgba(0, 0, 0, 0.1) 1px solid;
        }
        .link:not(.active):hover {
          text-decoration: underline;
          color: var(--page-contents-menu-link-color-focus, rgb(56, 132, 255));
          font-size: var(--page-contents-menu-link-font-size-focus, 11px);
        }
        .link:not(.active):focus {
          color: var(--page-contents-menu-link-color-focus, rgb(56, 132, 255));
          font-size: var(--page-contents-menu-link-font-size-focus, 11px);
          outline: 1px solid var(--page-contents-menu-link, black);
          outline-offset: 4px;
        }
        .indent-1 {
          padding-left: var(--ddd-spacing-2);
        }
        .indent-2 {
          padding-left: var(--ddd-spacing-3);
        }
        .indent-3,
        .indent-4,
        .indent-5,
        .indent-6 {
          padding-left: var(--ddd-spacing-4);
        }
        .link:active,
        .active {
          font-weight: bold;
          border-left: var(--page-contents-menu-link, black) 3px solid;
          font-size: var(--page-contents-menu-link-font-size-active, 12px);
        }
        :host([mobile]) .link:active,
        :host([mobile]) .active {
          border-left: var(--page-contents-menu-link, black) 2px solid;
        }
      `]}render(){return t`
      <section class="wrapper" role="navigation">
        <div class="header">
          <a
            class="svg"
            @click="${this.toggleSettings}"
            @keypress="${this.keyToggle}"
            id="popovertarget"
            role="button"
            aria-label="${this.label}"
          >
            <svg
              preserveAspectRatio="xMidYMid meet"
              height="1em"
              width="1em"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
              viewBox="0 0 24 24"
              stroke-width="2"
              stroke-linecap="round"
              stroke-linejoin="round"
              stroke="currentColor"
              class="icon-7f6730be--text-3f89f380"
            >
              <g>
                <line x1="21" y1="10" x2="7" y2="10"></line>
                <line x1="21" y1="6" x2="3" y2="6"></line>
                <line x1="21" y1="14" x2="3" y2="14"></line>
                <line x1="21" y1="18" x2="7" y2="18"></line>
              </g>
            </svg>
          </a>
          <simple-tooltip
            for="popovertarget"
            offset="32"
            ?hidden="${!this.mobile||!this.hideSettings}"
          >
            ${this.label}
          </simple-tooltip>
          ${this.mobile?"":t` <div class="label">${this.label}</div> `}
        </div>
        ${this.mobile?t`
              <simple-popover
                class="dropdown pull-left font-settings js-toolbar-action settings-container"
                ?hidden="${this.hideSettings}"
                position="${this.position}"
                auto
              >
                <ol class="contents">
                  ${this.items.map(((t,e)=>this.renderItem(t,e)))}
                </ol>
              </simple-popover>
            `:t`
              <ol class="contents">
                ${this.items.map(((t,e)=>this.renderItem(t,e)))}
              </ol>
            `}
      </section>
    `}keyToggle(t){["Enter","Space"].includes(t.key)&&this.toggleSettings(t)}keyScroll(t){"Enter"==t.key&&this.scrollToObject(t)}toggleSettings(t){this.mobile&&(this.hideSettings=!this.hideSettings)}scrollToObject(t){var e=i(t)[0];if(this.items&&this.contentContainer&&e.getAttribute("data-index")&&this.items[parseInt(e.getAttribute("data-index"))]){let i;t.preventDefault(),t.stopPropagation(),t.stopImmediatePropagation(),i=this.contentContainer.querySelector("#"+this.items[parseInt(e.getAttribute("data-index"))].id);void 0!==globalThis.safari?i.scrollIntoView():i.scrollIntoView({behavior:"smooth",block:"start",inline:"start"}),globalThis.history.pushState({},null,e.getAttribute("href")),globalThis.dispatchEvent(new PopStateEvent("popstate")),this.hideSettings=!0}}renderItem(e,i){return null==e.link&&e.id?t`
        <li class="item">
          <a
            class="link indent-${e.indent} ${e.active}"
            tabindex="0"
            title="${e.title}"
            @click="${this.scrollToObject}"
            @keypress="${this.keyScroll}"
            data-index="${i}"
            >${e.title}</a
          >
        </li>
      `:t`
      <li class="item">
        <a
          class="link indent-${e.indent} ${e.active}"
          href="${e.link}"
          title="${e.title}"
          @click="${this.scrollToObject}"
          @keypress="${this.keyScroll}"
          data-index="${i}"
          >${e.title}</a
        >
      </li>
    `}static get properties(){return{contentContainer:{type:Object},relationship:{type:String},items:{type:Array},position:{type:String},mobile:{type:Boolean,reflect:!0},label:{type:String},hideSettings:{type:Boolean},hideIfEmpty:{type:Boolean,attribute:"hide-if-empty",reflect:!0},isEmpty:{type:Boolean,attribute:"is-empty",reflect:!0}}}static get tag(){return"page-contents-menu"}constructor(){super(),this.windowControllers=new AbortController,this.relationship=null,this.fallbackText={},this.items=[],this.isEmpty=!0,this.hideIfEmpty=!1,this.position="left",this.contentContainer=null,this.mobile=!1,this.scrollPolling=200,this.hideSettings=!0,this.label="Contents",this.hierarchyTags=["h1","h2","h3","h4","h5","h6"]}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),"parent"==this.relationship?this.contentContainer=this.parentElement:"next"==this.relationship?this.contentContainer=this.nextElementSibling:"previous"==this.relationship&&(this.contentContainer=this.previousElementSibling),setTimeout((()=>{this.updateMenu()}),1500)}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"items"==e&&this[e]&&this[e].length>0&&setTimeout((()=>{this.scrollFinished()}),0),"contentContainer"==e&&this._contentContainerChanged(this[e]),"mobile"==e&&(this[e]?(import("../simple-popover/simple-popover.js").then((t=>{setTimeout((()=>{this.__toggleTarget=this.shadowRoot.querySelector("#popovertarget"),this.__toggleTarget.setAttribute("tabindex","0"),this.shadowRoot.querySelector("simple-popover").target=this.__toggleTarget}),0)})),import("../simple-tooltip/simple-tooltip.js")):t&&!this[e]&&this.__toggleTarget.removeAttribute("tabindex"))}))}updateMenu(){const t=this.hierarchyTags;let e=[];for(var i=0;i<this.contentContainer.childNodes.length;i++){let n=this.contentContainer.childNodes[i];if(void 0!==n.tagName&&t.includes(n.tagName.toLowerCase())){let t=n.innerText;!t&&n.title&&(t=n.title),!t&&n.mediaTitle&&(t=n.mediaTitle),!t&&this.fallbackText[n.tagName.toLowerCase()]&&(t=this.fallbackText[n.tagName.toLowerCase()]),!n.id&&n.getAttribute("resource")?n.setAttribute("id",n.tagName.toLowerCase()+n.getAttribute("resource").replace(/[^a-zA-Z0-9]/g,"")):n.id||n.setAttribute("id",n.tagName.toLowerCase()+i);let s={title:t,link:n.id?globalThis.document.location.pathname+"#"+n.id:null,id:n.id,indent:parseInt(n.tagName.toLowerCase().replace("h",""))?parseInt(n.tagName.toLowerCase().replace("h","")):2,active:"",item:n};e.push(s)}}0===e.length?this.isEmpty=!0:this.isEmpty=!1,this.items=[...e]}_applyScrollDetect(){clearTimeout(this.__debounce),this.__debounce=setTimeout((()=>{this.scrollFinished()}),this.scrollPolling)}scrollFinished(){if(this.items){let t=!1,e=globalThis.innerHeight||globalThis.document.documentElement.clientHeight;if(this.items.forEach(((i,n)=>{if(this.contentContainer&&this.items&&this.items[n]&&this.items[n].id)try{let i=this.contentContainer.querySelector("#"+this.items[n].id);if(i){let s=i.getBoundingClientRect().top-100,o=0;o=n!==this.items.length-1&&this.items[n+1]&&this.items[n+1].id?this.contentContainer.querySelector("#"+this.items[n+1].id).getBoundingClientRect().top-100:e,s<=e&&o>0&&!t?(t=!0,this.items[n].active="active"):this.items[n].active=""}}catch(t){console.log(t)}})),!t&&this.items&&this.items.length>0&&this.contentContainer&&this.items[0]&&this.items[0].id)try{let t=this.contentContainer.querySelector("#"+this.items[0].id);t&&(t.getBoundingClientRect().top>=e?this.items[0].active="active":this.items[this.items.length-1].active="active")}catch(t){console.log(t)}this.requestUpdate()}}_contentContainerChanged(t){t&&t.childNodes&&t.childNodes.length>0&&setTimeout((()=>{this.updateMenu()}),50)}connectedCallback(){super.connectedCallback&&super.connectedCallback(),globalThis.addEventListener("scroll",this._applyScrollDetect.bind(this),{signal:this.windowControllers.signal})}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback&&super.disconnectedCallback()}}customElements.define(PageContentsMenu.tag,PageContentsMenu);export{PageContentsMenu};