/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t,LitElement as i}from"../../lit/index.js";import{SchemaBehaviors as a}from"../schema-behaviors/schema-behaviors.js";import{IntersectionObserverMixin as s}from"../intersection-element/lib/IntersectionObserverMixin.js";import{I18NMixin as n}from"../i18n-manager/lib/I18NMixin.js";import"../simple-icon/lib/simple-icon-button-lite.js";import"../simple-icon/lib/simple-icon-lite.js";import"../simple-icon/lib/simple-icons.js";import{pageBreakManager as r}from"./lib/page-break-manager.js";import{DDDExtra as l}from"../d-d-d/lib/DDDStyles.js";export class PageBreak extends(s(n(a(i)))){static get tag(){return"page-break"}constructor(){super(),this.relatedItems=null,this.icon=null,this.accentColor=null,this.entityType="page",this.status="",this.t={newPage:"New page",pageBreak:"Page break",selectToEditPageDetails:"Select to edit Page details",clickToUnlock:"Click to unlock",noParent:"No parent",toggleLock:"Toggle lock",togglePublished:"Toggle published"},this.registerLocalization({context:this,localesPath:new URL("./locales/page-break.es.json",import.meta.url).href+"/../",locales:["es"]}),this.description=null,this.hideInMenu=!1,this.noderefs=[],this.developerTheme=null,this.tags=null,this.title=this.t.newPage,this.pageType=null,this.slug="",this.published=!1,this.image=null,this.target=null,this.locked=!1,this.order=null,this.depth=0,this.itemId=null,this._haxState=!1,this.IORemoveOnVisible=!1,this.IODelay=250,this.remoteHeadingobserver=new MutationObserver((()=>{this.title!=this.target.innerText&&(this.__moUpdate=!0,this.title=this.target.innerText)})),this.iconType="editor:format-page-break",this.breakType="node"}static get properties(){return{...super.properties||{},iconType:{type:String},noderefs:{type:Array,attribute:!1},relatedItems:{type:String,attribute:"related-items"},icon:{type:String},accentColor:{type:String,attribute:"accent-color"},entityType:{type:String,attribute:"entity-type"},description:{type:String},order:{type:Number},hideInMenu:{type:Boolean,reflect:!0,attribute:"hide-in-menu"},tags:{type:String,reflect:!0},developerTheme:{type:String,attribute:"developer-theme"},title:{type:String,reflect:!0},slug:{type:String},image:{type:String},parent:{type:String,reflect:!0},published:{type:Boolean,reflect:!0},locked:{type:Boolean,reflect:!0},depth:{type:Number,reflect:!0},itemId:{type:String,attribute:"item-id",reflect:!0},breakType:{type:String,attribute:"break-type"},status:{type:String},pageType:{type:String,attribute:"page-type"},_haxState:{type:Boolean}}}connectedCallback(){super.connectedCallback(),"node"===this.breakType&&(this.nextElementSibling&&this.nextElementSibling.tagName&&["H1","H2","H3","H4","H5","H6"].includes(this.nextElementSibling.tagName)?(this.title=this.nextElementSibling.innerText,this.target=this.nextElementSibling,this.setupTargetData(this.target)):setTimeout((()=>{if(null===this.target)if(this.nextElementSibling&&this.nextElementSibling.tagName&&["H1","H2","H3","H4","H5","H6"].includes(this.nextElementSibling.tagName))this.title=this.nextElementSibling.innerText,this.target=this.nextElementSibling,this.setupTargetData(this.target);else{let e=0===this.depth?"h2":`h${this.depth+2}`,t=globalThis.document.createElement(e);t.setAttribute("data-original-level","H2"),t.innerText=this.title,this.parentNode.insertBefore(t,this.nextElementSibling),setTimeout((()=>{this.setupTargetData(this.nextElementSibling)}),100)}}),0)),globalThis.dispatchEvent(new CustomEvent("page-break-registration",{composed:!0,bubbles:!0,cancelable:!0,detail:{value:this,action:"add"}})),globalThis.dispatchEvent(new CustomEvent("page-break-change",{composed:!0,bubbles:!0,cancelable:!0,detail:{value:this}}))}disconnectedCallback(){globalThis.dispatchEvent(new CustomEvent("page-break-registration",{detail:{value:this,action:"remove"}})),globalThis.dispatchEvent(new CustomEvent("page-break-change",{composed:!0,bubbles:!0,cancelable:!0,detail:{value:this}})),this.remoteHeadingobserver.disconnect(),super.disconnectedCallback()}setupTargetData(e){this.target&&this.remoteHeadingobserver.disconnect(),this.target=e,this._haxSibling=this,this.remoteHeadingobserver.observe(this.target,{characterData:!0,childList:!0,subtree:!0})}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{if("noderefs"===t){let e=[];for(let t=0;t<this.noderefs.length;t++)e.push(this.noderefs[t].node);this.relatedItems=e.join(",")}"schemaResourceID"===t&&null==this.itemId&&void 0!==e&&(this.itemId=this.schemaResourceID.replace("#","item-")),this.locked&&"locked"===t?r.elementsBetween(this).forEach((e=>{e.setAttribute("data-hax-lock","data-hax-lock")})):!this.locked&&"locked"===t&&e&&r.elementsBetween(this).forEach((e=>{e.removeAttribute("data-hax-lock")})),this._ceMenu&&["locked","parent","published"].includes(t)&&this._updateHAXCEMenu(),["title","parent","slug"].includes(t)&&globalThis.dispatchEvent(new CustomEvent("page-break-change",{composed:!0,bubbles:!0,cancelable:!0,detail:{value:this}})),"node"===this.breakType&&this.target&&("title"===t&&this[t]&&(this.__moUpdate?this.__moUpdate=!1:this.title!=this.target.innerText&&(this.target.innerText=this.title)),!this._haxState&&"depth"===t&&this.depth>=0&&r.elementsBetween(this,"page-break","h1,h2,h3,h4,h5,h6").forEach((e=>{let t=(e.getAttribute("data-original-level")?new Number(e.getAttribute("data-original-level").replace("H","")):new Number(e.tagName.replace("H","")))+this.depth;t=t>6?6:t;const i=globalThis.document.createElement(`h${t}`);i.setAttribute("data-original-level",e.tagName);for(var a=0,s=e.attributes.length;a<s;++a)i.setAttribute(e.attributes.item(a).nodeName,e.attributes.item(a).nodeValue);i.innerHTML=e.innerHTML,this.setupTargetData(i),e.parentNode.replaceChild(i,e)})),"_haxState"===t&&void 0!==e&&(this._haxState?r.elementsBetween(this,"page-break","h1,h2,h3,h4,h5,h6").forEach((e=>{if(e.getAttribute("data-original-level")){let a=new Number(e.getAttribute("data-original-level").replace("H",""));const s=globalThis.document.createElement(`h${a}`);for(var t=0,i=e.attributes.length;t<i;++t)s.setAttribute(e.attributes.item(t).nodeName,e.attributes.item(t).nodeValue);s.innerHTML=e.innerHTML,e.parentNode.replaceChild(s,e),this.setupTargetData(s)}})):r.elementsBetween(this,"page-break","h1,h2,h3,h4,h5,h6").forEach((e=>{let t=(e.getAttribute("data-original-level")?new Number(e.getAttribute("data-original-level").replace("H","")):new Number(e.tagName.replace("H","")))+this.depth;t=t>6?6:t;const i=globalThis.document.createElement(`h${t}`);i.setAttribute("data-original-level",e.tagName);for(var a=0,s=e.attributes.length;a<s;++a)i.setAttribute(e.attributes.item(a).nodeName,e.attributes.item(a).nodeValue);i.innerHTML=e.innerHTML,e.parentNode.replaceChild(i,e),this.setupTargetData(i)})))),"breakType"===t&&("node"===this[t]?this.iconType="editor:format-page-break":this.iconType="hax:page-details")}))}static get styles(){return[l,t`
        :host {
          display: block;
          opacity: 0;
        }
        :host([data-hax-ray]) {
          display: block;
          margin: 0 0 var(--ddd-spacing-1) 0;
          opacity: 0.2;
          background-color: light-dark(black, white);
          transition:
            opacity 0.3s ease-in-out,
            visibility 0.3s ease-in-out;
        }
        :host([data-hax-ray]) .mid,
        :host([data-hax-ray]) .text {
          display: block;
        }
        .mid {
          display: none;
          border: none;
          border-top: var(--ddd-border-md);
          border-color: var(--ddd-primary-0);
          overflow: visible;
          margin: var(--ddd-spacing-1) 0 0 0;
          padding: 0;
          height: 0;
        }
        :host([data-hax-ray]:hover) {
          opacity: 1;
        }
        :host([data-hax-active]) {
          opacity: 1;
        }
        .text {
          display: none;
          font-weight: bold;
          color: light-dark(black, white);
          background-color: light-dark(white, black);
          font-size: var(--ddd-font-size-4xs);
          margin: 0 auto;
        }
        simple-icon-lite {
          margin-right: var(--ddd-spacing-2);
        }
        simple-icon-button-lite {
          float: right;
          color: light-dark(black, white);
          --simple-icon-width: var(--ddd-icon-sm);
          --simple-icon-height: var(--ddd-icon-sm);
          margin-top: -28px;
          margin-right: -46px;
        }
      `]}firstUpdated(e){if(super.firstUpdated&&super.firstUpdated(e),this.relatedItems){const e=this.relatedItems.split(",");for(let t=0;t<e.length;t++)this.noderefs.push({node:e[t]})}null!=this.itemId&&(this.schemaResourceID=this.itemId)}render(){return e`
      <style></style>
      <a .href="${this.slug}" .name="#${this.itemId}" class="sr-only"
        >${this.title}</a
      >
      <hr class="mid" />
      <div class="text">
        <simple-icon-lite icon="${this.iconType}"></simple-icon-lite>${this.t.selectToEditPageDetails}
      </div>
      ${this.locked?e`<simple-icon-button-lite
            @click="${this.haxClickLockInPage}"
            icon="icons:lock"
            title="${this.t.clickToUnlock}"
          ></simple-icon-button-lite>`:""}
    `}static get haxProperties(){return new URL("./lib/page-break.haxProperties.json",import.meta.url).href}haxHooks(){return{editModeChanged:"haxeditModeChanged",inlineContextMenu:"haxinlineContextMenu",activeElementChanged:"haxactiveElementChanged",setupActiveElementForm:"haxsetupActiveElementForm",preProcessInsertContent:"haxpreProcessInsertContent",trayDragNDropToNode:"haxtrayDragNDropToNode"}}async haxpreProcessInsertContent(e,t){let i=t;if(i&&i.parentNode){for(;"HAX-BODY"!==i.parentNode.tagName;)i=i.parentNode;const t=await r.associatedPageBreak(i);t&&(e.properties.parent=t.parent,e.properties.order=t.order+1,e.properties.published=t.published,e.properties.locked=t.locked)}return e}async haxtrayDragNDropToNode(e){let t=e;for(;"HAX-BODY"!==t.parentNode.tagName;)t=t.parentNode;const i=await r.associatedPageBreak(t);i&&(e.parent=i.parent,e.order=i.order+1,e.published=i.published,e.locked=i.locked)}haxsetupActiveElementForm(e){if(globalThis.HAXCMS){const i=globalThis.HAXCMS.requestAvailability().store.getManifestItems(!0);var t=[{text:`-- ${this.t.noParent} --`,value:null}];i.forEach((e=>{if(e.id!=this.itemId){let a=e,s="- ";for(;a&&null!=a.parent;)a=i.find((e=>e.id==a.parent)),a&&(s="--"+s);t.push({text:s+e.title,value:e.id})}})),e.settings.advanced.forEach(((i,a)=>{"parent"===i.property&&(e.settings.advanced[a].inputMethod="select",e.settings.advanced[a].itemsList=t),"noderefs"===i.property&&(e.settings.advanced[a].properties[0].inputMethod="select",e.settings.advanced[a].properties[0].itemsList=t)})),e.settings.developer.forEach(((t,i)=>{if("developerTheme"===t.property&&globalThis.appSettings&&globalThis.appSettings.themes){var a=[{text:"",value:null}];Object.keys(globalThis.appSettings.themes).map((e=>{a.push({text:globalThis.appSettings.themes[e].name,value:globalThis.appSettings.themes[e].element})})),e.settings.developer[i].inputMethod="select",e.settings.developer[i].itemsList=a}}))}}haxactiveElementChanged(e,t){!t&&this._ceMenu&&("site"===this.breakType?(this._ceMenu.disableOps=!1,this._ceMenu.canMoveElement=!0,this._ceMenu.insertAbove=!0):this._ceMenu.disableDuplicate=!1)}haxeditModeChanged(e){this._haxState=e}haxinlineContextMenu(e){this._ceMenu=e,this._updateHAXCEMenu(),"site"===this.breakType?(this._ceMenu.disableOps=!0,this._ceMenu.canMoveElement=!1,this._ceMenu.insertAbove=!1):this._ceMenu.disableDuplicate=!0}_updateHAXCEMenu(){this._ceMenu.ceButtons=[{icon:this.locked?"icons:lock":"icons:lock-open",callback:"haxClickInlineLock",label:this.t.toggleLock},{icon:this.published?"lrn:view":"lrn:view-off",callback:"haxClickInlinePublished",label:this.t.togglePublished}]}haxClickLockInPage(e){this.locked=!this.locked,globalThis.dispatchEvent(new CustomEvent("hax-refresh-tray-form",{}))}haxClickInlineLock(e){return this.locked=!this.locked,!0}haxClickInlinePublished(e){return this.published=!this.published,!0}}customElements.define(PageBreak.tag,PageBreak);