/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as i,html as e,css as t}from"../../lit/index.js";class MusicPlayer extends i{static get tag(){return"music-player"}constructor(){super(),this.noWaterfall=!1,this.noVisual=!1,this.visualizer="staff"}static get styles(){return[t`
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none;
        }
        midi-player {
          display: block;
          width: var(--music-player-midi-player-width, unset);
          margin: var(--music-player-midi-player-margin, 4px);
        }
        :host([no-visual]) midi-visualizer {
          display: none;
        }

        :host([no-waterfall]) midi-visualizer .waterfall-notes-container {
          display: none;
        }
        midi-visualizer .waterfall-visualizer {
          overflow: auto;
        }
      `]}render(){return e`
      <midi-visualizer
        type="${this.visualizer}"
        src="${this.source}"
      ></midi-visualizer>
      <midi-player src="${this.source}" sound-font></midi-player>
    `}static get properties(){return{source:{type:String},visualizer:{type:String},noWaterfall:{type:Boolean,attribute:"no-waterfall",reflect:!0},noVisual:{type:Boolean,attribute:"no-visual",reflect:!0}}}firstUpdated(){this.visualizerElement=this.shadowRoot.querySelector("midi-visualizer"),setTimeout((()=>{import("./lib/html-midi-player.js").then((i=>{this.shadowRoot.querySelector("midi-player").addVisualizer(this.visualizerElement)}))}),0)}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}customElements.define(MusicPlayer.tag,MusicPlayer);export{MusicPlayer};