/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../lit/index.js";class MemeMaker extends t{static get styles(){return[i`
        :host {
          display: block;
        }
        * {
          box-sizing: border-box;
        }
        figure {
          position: relative;
          width: 100%;
          margin: 0;
          padding: 0;
          font-size: 20px;
          overflow: hidden;
        }
        img {
          width: 100%;
          height: auto;
        }
        .top-text,
        .bottom-text {
          position: absolute;
          left: 0;
          width: 100%;
          padding: 3% 2%;
          text-align: center;
          text-transform: uppercase;
          font-weight: 900;
          font-family: "Impact", "Arial Black", "sans serif";
          line-height: 1.2;
          font-size: var(--meme-maker-font-size, 36px);
          color: white;
          text-shadow:
            -1px -1px 0 #000,
            1px -1px 0 #000,
            -1px 1px 0 #000,
            1px 1px 0 #000;
          letter-spacing: 2px;
        }
        .top-text {
          top: 0;
        }
        .bottom-text {
          bottom: 0;
        }
        @media (max-width: 800px) {
          .top-text,
          .bottom-text {
            font-size: var(--meme-maker-font-size-medium, 20px);
          }
        }
        @media (max-width: 600px) {
          .top-text,
          .bottom-text {
            font-size: var(--meme-maker-font-size-small, 20px);
          }
        }
      `]}render(){return e`
      <figure>
        <img
          loading="lazy"
          src="${this.imageUrl}"
          alt="${this.alt||""}"
          aria-describedby="${this.describedBy||""}"
          ?crossorigin="${this.crossorigin}"
        />
        <figcaption class="top-text">${this.topText}</figcaption>
        <figcaption class="bottom-text">${this.bottomText}</figcaption>
      </figure>
    `}static get tag(){return"meme-maker"}constructor(){super(),this.alt="",this.crossorigin=!1}static get properties(){return{alt:{type:String},crossorigin:{type:Boolean},describedBy:{type:String,attribute:"described-by"},imageUrl:{type:String,attribute:"image-url",reflect:!0},topText:{type:String,attribute:"top-text",reflect:!0},bottomText:{type:String,attribute:"bottom-text",reflect:!0}}}haxHooks(){return{progressiveEnhancement:"haxprogressiveEnhancement",gizmoRegistration:"haxgizmoRegistration"}}haxgizmoRegistration(t){globalThis.dispatchEvent(new CustomEvent("i18n-manager-register-element",{detail:{namespace:"meme-maker.haxProperties",localesPath:new URL("./locales",import.meta.url).href,locales:["es","fr"]}}))}haxprogressiveEnhancement(t){return`\n    ${this.topText?`<div>${this.topText}</div>`:""}\n      <img src="${this.imageUrl}" alt="${this.alt}" preload="lazy" aria-describedby="${this.describedBy||""}"/>\n    ${this.bottomText?`<div>${this.bottomText}</div>`:""}`}static get haxProperties(){return new URL("./lib/meme-maker.haxProperties.json",import.meta.url).href}}customElements.define(MemeMaker.tag,MemeMaker);export{MemeMaker};