/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../lit/index.js";import{SchemaBehaviors as a}from"../schema-behaviors/schema-behaviors.js";import{SimpleModalHandler as o}from"../simple-modal/lib/simple-modal-handler.js";import"../figure-label/figure-label.js";import{DDD as r}from"../d-d-d/d-d-d.js";class MediaImage extends r{static get styles(){return[super.styles,i`
        :host {
          display: block;
          width: auto;
          margin: auto;
          max-width: 600px;
          font-family: var(--ddd-font-secondary);
          font-weight: var(--ddd-font-secondary-light);
          font-size: var(--ddd-font-size-4xs);
        }

        :host([card]) {
          box-shadow: var(--ddd-boxShadow-sm);
          border: var(--ddd-border-xs);
          border-color: var(--ddd-theme-default-limestoneLight);
          padding: var(--ddd-spacing-5);
          background-color: var(
            --ddd-component-media-image-card-color,
            var(--card-background-color)
          );
        }

        :host([box]) {
          padding: var(--ddd-spacing-5);
          background-color: var(--ddd-theme-accent, var(--ddd-accent-2));
        }
        @media screen and (min-width: 650px) {
          :host([size="small"]) {
            max-width: 35%;
          }
        }

        @media screen and (min-width: 900px) {
          :host([size="small"]) {
            max-width: 25%;
          }
        }

        :host([offset="left"]) {
          float: left;
          margin: var(--media-image-offset-width, 1.5vw);
          margin-left: calc(-2 * var(--media-image-offset-width, 1.5vw));
          padding-left: calc(4 * var(--media-image-offset-width, 1.5vw));
          margin-top: 0;
          margin-bottom: calc(0.1 * var(--media-image-offset-width, 1.5vw));
        }

        :host([offset="right"]) {
          float: right;
          margin: var(--media-image-offset-width, 1.5vw);
          margin-right: calc(-2 * var(--media-image-offset-width, 1.5vw));
          padding-right: calc(4 * var(--media-image-offset-width, 1.5vw));
          margin-top: 0;
          margin-bottom: calc(0.1 * var(--media-image-offset-width, 1.5vw));
        }

        :host([offset="wide"]) {
          margin: 0 calc(-1 * var(--media-image-offset-wide-width, 3.5vw));
          max-width: 100vw;
        }

        :host([offset="narrow"]) {
          max-width: var(--media-image-offset-narrow-max-width, 500px);
          margin: auto;
        }

        media-image-caption {
          max-height: var(--ddd-icon-4xl);
          border: var(--ddd-border-sm);
          border-color: var(
            --ddd-component-figure-label-title,
            var(--ddd-theme-accent, var(--ddd-theme-default-limestoneLight))
          );
          background: var(
            --ddd-component-figure-label-description-background,
            transparent
          );
          padding: var(--ddd-spacing-2);
          margin-bottom: var(--ddd-spacing-5);
          line-height: var(--ddd-lh-140);
        }
        :host(:not([disable-zoom])) media-image-image:hover {
          cursor: pointer;
        }
      `]}constructor(){super(),this.link=null,this.disableZoom=!1,this.modalTitle="",this.source="",this.citation="",this.caption="",this.figureLabelTitle="",this.figureLabelDescription="",this.alt="",this.size="wide",this.round=!1,this.card=!1,this.box=!1,this.offset="none"}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"caption"==t&&this._computeHasCaption(this[t]),"link"===t&&this.link&&(this.disableZoom=!0),["figureLabelTitle","figureLabelDescription"].includes(t)&&(this.__figureLabel=this._hasFigureLabel(this.figureLabelTitle,this.figureLabelDescription)),["figureLabelTitle","caption"].includes(t)&&(this.modalTitle=this.figureLabelTitle?this.figureLabelTitle:this.caption,this.modalTitle+=this.figureLabelDescription?" - "+this.figureLabelDescription:"")}))}render(){return t`
      ${this.__figureLabel?t`
            <figure-label
              title="${this.figureLabelTitle}"
              description="${this.figureLabelDescription}"
            ></figure-label>
          `:""}
      ${this.link?t`<a href="${this.link}"
            ><media-image-image
              ?round="${this.round}"
              resource="${this.schemaResourceID}-image"
              source="${this.source}"
              modal-title="${this.modalTitle}"
              alt="${this.alt}"
              tabindex="${this.disableZoom?"-1":"0"}"
              @click="${this._handleClick}"
            ></media-image-image
          ></a>`:t`<media-image-image
            ?round="${this.round}"
            resource="${this.schemaResourceID}-image"
            source="${this.source}"
            modal-title="${this.modalTitle}"
            alt="${this.alt}"
            tabindex="${this.disableZoom?"-1":"0"}"
            @click="${this._handleClick}"
          ></media-image-image>`}
      <media-image-citation>
        <slot class="citation" name="citation">${this.citation}</slot>
      </media-image-citation>
      ${this._hasCaption?t`
            <media-image-caption tabindex="0">
              <slot name="caption">${this.caption}</slot>
            </media-image-caption>
          `:""}
    `}haxHooks(){return{editModeChanged:"haxEditModeChanged",activeElementChanged:"haxActiveElementChanged"}}_handleClick(e){(this._haxState||this.disableZoom)&&(e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation()),!this._haxState&&this.link&&this.disableZoom&&this.shadowRoot.querySelector("a").click()}haxEditModeChanged(e){this._haxState=e}haxActiveElementChanged(e,t){t&&(this._haxState=t)}static get tag(){return"media-image"}static get properties(){return{...super.properties,link:{type:String},__figureLabel:{type:Boolean},modalTitle:{type:String},disableZoom:{type:Boolean,attribute:"disable-zoom",reflect:!0},_hasCaption:{type:Boolean},source:{type:String},citation:{type:String},caption:{type:String},alt:{type:String},size:{type:String,reflect:!0},round:{type:Boolean},card:{type:Boolean,reflect:!0},box:{type:Boolean,reflect:!0},offset:{type:String,reflect:!0},figureLabelTitle:{type:String,attribute:"figure-label-title"},figureLabelDescription:{type:String,attribute:"figure-label-description"}}}_hasFigureLabel(e,t){return e&&e.length>0||t&&t.length>0}_computeHasCaption(){this._hasCaption=this.caption.length>0||null!==this.querySelector('[slot="caption"]')}connectedCallback(){super.connectedCallback(),this._observer=new MutationObserver((e=>{this._computeHasCaption()})),this._observer.observe(this,{childList:!0})}disconnectedCallback(){this._observer.disconnect(),super.disconnectedCallback()}static get haxProperties(){return{canScale:!0,canEditSource:!0,gizmo:{title:"Image",descrption:"A way of presenting images with various enhancements.",icon:"editor:insert-photo",color:"indigo",tags:["Images","media","core","figure","image","caption","presentation","design"],handles:[{type:"image",type_exclusive:!0,source:"source",title:"alt",alt:"alt",citation:"citation",caption:"caption"}],meta:{author:"HAXTheWeb core team",outlineDesigner:!0}},settings:{configure:[{property:"source",title:"Source",description:"The URL for the image.",inputMethod:"haxupload",noVoiceRecord:!0,required:!0},{property:"alt",title:"Alternative text",description:"Text to describe the image to non-sighted users.",inputMethod:"alt",required:!0},{property:"link",title:"Link",description:"Link the image to a URL",inputMethod:"haxupload",noVoiceRecord:!0,noCamera:!0,required:!1},{property:"card",title:"Card",description:"Apply a drop shadow to give the appearance of being a raised card.",inputMethod:"boolean",required:!1},{property:"box",title:"Box",description:"Apply a visual box around the image.",inputMethod:"boolean",required:!1},{property:"offset",title:"Offset",description:"Apply a left or right offset to the image.",inputMethod:"select",options:{none:"none",wide:"wide",narrow:"narrow"}},{property:"citation",title:"Citation",description:"Citation for the image.",inputMethod:"textfield",required:!1},{property:"caption",title:"Caption",description:"Caption for the image.",inputMethod:"textfield",required:!1},{property:"figureLabelTitle",title:"Figure Label Title",description:"Title for the figure label.",inputMethod:"textfield",required:!1},{property:"figureLabelDescription",title:"Figure Label Description",description:"Description for the figure label.",inputMethod:"textfield",required:!1}],advanced:[{property:"round",title:"Round image",description:"Crops the image appearance to be circle in shape.",inputMethod:"boolean",required:!1},{property:"disableZoom",title:"Disable image modal",description:"Disable clicks opening the image in an image inspector dialog.",inputMethod:"boolean",required:!1}]},demoSchema:[{tag:"media-image",properties:{source:"https://dummyimage.com/300x200/000/fff",card:!0,citation:"This is my citation."}}]}}}customElements.define(MediaImage.tag,MediaImage);class MediaImageImage extends(o(r)){static get styles(){return[super.styles,i`
        :host {
          display: block;
        }
        .image-wrap {
          overflow: hidden;
          height: fit-content;
        }
        :host([round]) .image-wrap {
          overflow: unset;
        }
        .image-wrap img {
          width: 100%;
        }
        :host([round]) .image-wrap img {
          border-radius: var(--ddd-radius-circle);
          height: fit-content;
          overflow: show;
          border: var(--ddd-border-sm);
          border-color: var(
            --ddd-component-figure-label-title,
            var(
              --ddd-theme-accent,
              var(
                --simple-colors-default-theme-accent-2,
                var(--ddd-theme-default-limestoneLight)
              )
            )
          );
        }
      `]}constructor(){super(),this.round=!1,globalThis.document&&(this.modalContent=globalThis.document.createElement("image-inspector"),this.modalContent.noLeft=!0),this.modalTitle="",this.addEventListener&&this.addEventListener("simple-modal-show",this.__modalShowEvent.bind(this))}__modalShowEvent(e){import("../image-inspector/image-inspector.js")}render(){return t`
      <div class="image-wrap">
        <img src="${this.source}" alt="${this.alt}" loading="lazy" />
      </div>
    `}updated(e){e.forEach(((e,t)=>{"source"==t&&(this.modalContent.src=this[t])}))}static get properties(){return{source:{type:String},alt:{type:String},round:{type:Boolean,reflect:!0},modalTitle:{type:String,attribute:"modal-title"}}}static get tag(){return"media-image-image"}}customElements.define(MediaImageImage.tag,MediaImageImage);class MediaImageCitation extends r{static get styles(){return[super.styles,i`
        :host {
          display: block;
          overflow: auto;
        }

        .citation {
          line-height: var(--ddd-lh-120);
          margin: var(--ddd-spacing-1) 0;
          font-size: var(--ddd-font-size-4xs);
          font-weight: var(--ddd-font-weight-bold);
          font-family: var(--ddd-font-navigation);
        }
      `]}render(){return t` <div class="citation"><slot></slot></div> `}static get tag(){return"media-image-citation"}}customElements.define(MediaImageCitation.tag,MediaImageCitation);class MediaImageCaption extends r{static get styles(){return[super.styles,i`
        :host {
          display: block;
          overflow: auto;
          margin-top: var(--ddd-spacing-1);
          font-size: var(--ddd-font-size-4xs);
          font-weight: var(--ddd-font-weight-regular);
          font-family: var(--ddd-font-primary);
        }

        .caption ::slotted(*) {
          margin-top: 0;
        }
        .caption ::slotted(*:last-child) {
          margin-bottom: 0;
        }
      `]}render(){return t`
      <div class="caption">
        ${this.__hasContent?"":t` <slot id="slot"></slot> `}
      </div>
    `}static get tag(){return"media-image-caption"}}customElements.define(MediaImageCaption.tag,MediaImageCaption);export{MediaImage};