/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as o}from"../../lit/index.js";import{DDD as r}from"../d-d-d/d-d-d.js";class MdBlock extends r{static get styles(){return[super.styles,o`
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none;
        }
      `]}render(){return t` <div>
      ${this.markdown&&""==this.source?t` <marked-element markdown="${this.markdown}">
            <div slot="markdown-html"></div>
          </marked-element>`:t` <marked-element>
            <div slot="markdown-html"></div>
            <script
              type="text/markdown"
              .src="${this.source?this.source:void 0}"
            ></script>
          </marked-element>`}
    </div>`}static get haxProperties(){return{canScale:!1,canEditSource:!0,gizmo:{title:"Markdown",description:"A block of markdown content directly or remote loaded",icon:"icons:code",color:"yellow",tags:["Resource","md","markdown","content","text","code","codeblock","code-block","code block","html"],handles:[],meta:{author:"HAXTheWeb",owner:"The Pennsylvania State University"}},settings:{configure:[{property:"markdown",title:"Markdown",description:"Raw markdown",inputMethod:"textarea"},{property:"source",title:"Source",description:"Source file for markdown",inputMethod:"haxupload",noVoiceRecord:!0,noCamera:!0}],advanced:[]},demoSchema:[{tag:"md-block",properties:{markdown:"- The first bulleted item in a long list.."},content:""}]}}static get properties(){return{source:{type:String},markdown:{type:String}}}constructor(){super(),this.markdown="",this.source="",import("../../@polymer/marked-element/marked-element.js"),this.innerHTML&&(this.markdown=this.innerHTML.trim(),this.innerHTML=null)}static get tag(){return"md-block"}}customElements.define(MdBlock.tag,MdBlock);export{MdBlock};