/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 * @demo demo/index.html
 */
import{html as e,css as t,nothing as s}from"../../lit/index.js";import"../simple-toolbar/lib/simple-toolbar-button.js";import{QuestionElement as r}from"../multiple-choice/lib/QuestionElement.js";export class MarkTheWords extends r{static get tag(){return"mark-the-words"}constructor(){super(),this.guessDataValue="displayedAnswers",this.displayedAnswers=[],this.wordList=[],this.question="Mark the words that are correct",this.statement="",this.numberCorrect=0,this.numberGuessed=0,this.isMarkTheWords=!0}getGuess(){return this.displayedAnswers.length>0}static get properties(){return{...super.properties,wordList:{type:Array},statement:{type:String},missedAnswers:{type:Array},numberCorrect:{type:Number},numberGuessed:{type:Number}}}updated(e){super.updated(e),this.isMarkTheWords&&this.shadowRoot&&this.statement&&(e.has("statement")||e.has("answers"))&&this.rebuildWordList(this.statement)}rebuildWordList(e){this.wordList=[];const t=e.trim().split(/\s+/g);for(var s in t){let e=this.displayedAnswers.find((e=>e.label&&t[s].toLowerCase()===e.label.toLowerCase()));this.wordList.push({text:t[s],selected:!1,correct:null,selectedFeedback:e?e.selectedFeedback:null,unselectedFeedback:e?e.unselectedFeedback:null})}this.requestUpdate()}static get styles(){return[super.styles,t`
        :host {
          display: block;
        }

        button.selected,
        button.selected:focus,
        button.selected:hover {
          outline: 2px solid
            light-dark(
              var(
                --lowContrast-override,
                var(--ddd-theme-primary, var(--ddd-theme-default-nittanyNavy))
              ),
              var(--ddd-theme-default-link)
            );
        }
        button:focus,
        button:hover {
          outline: 1px solid
            light-dark(
              var(
                --lowContrast-override,
                var(--ddd-theme-primary, var(--ddd-theme-default-nittanyNavy))
              ),
              var(--ddd-theme-default-link)
            );
        }

        button {
          outline: none;
          border: none;
          margin: 0 4px;
          padding: 0 4px;
        }

        .text {
          margin: var(--ddd-spacing-4);
          padding: var(--ddd-spacing-4);
          border: var(--ddd-border-sm);
          line-height: 2.2;
        }

        @media (max-width: 600px) {
          .text {
            margin: var(--ddd-spacing-1);
            padding: var(--ddd-spacing-1);
          }
        }

        .tag-option {
          font-size: var(--ddd-font-size-s);
          height: auto;
          display: inline-block;
          font-family: var(--ddd-font-navigation);
          border-radius: var(--ddd-radius-md);
          background-color: var(--simple-colors-default-theme-grey-2);
          margin: 0;
          cursor: pointer;
          user-select: none;
          transition: background-color 0.3s ease;
        }

        :host([show-answer]) .tag-option {
          cursor: unset;
          pointer-events: none;
        }

        :host(:not([show-answer])) .tag-option:hover,
        :host(:not([show-answer])) .tag-option:focus {
          background-color: var(--simple-colors-default-theme-grey-3);
        }
      `]}selectWord(e){let t=this.wordList.findIndex((t=>e.target.innerText===t.text));this.wordList[t].selected=!this.wordList[t].selected,this.requestUpdate()}isCorrect(){this.numberGuessed=0,this.numberCorrect=0;let e=!0;for(var t in this.wordList){for(var s in this.displayedAnswers)this.wordList[t].selected&&this.displayedAnswers[s].correct&&this.displayedAnswers[s].label.toLowerCase()===this.wordList[t].text.toLowerCase()&&(this.wordList[t].correct=!0,this.numberCorrect++);this.wordList[t].selected&&(this.wordList[t].correct||(e=!1),this.numberGuessed++)}return e&&this.numberCorrect!==this.numberGuessed&&(e=!1),this.numberCorrect!==this.displayedAnswers.filter((e=>e.correct)).length&&(e=!1),e}resetAnswer(e){this.isCorrect()&&(this.wordList=[],this.rebuildWordList(this.statement)),super.resetAnswer(e)}guessCount(){return this.wordList.filter((e=>e.selected)).length}renderInteraction(){return e`<div class="text-wrap">
      <div class="text">
        ${this.wordList.map((t=>e`
            <button
              ?disabled="${this.showAnswer}"
              class="tag-option ${t.selected?"selected":""} ${this.showAnswer&&t.selected?t.correct?"correct":"incorrect":""}"
              @click="${this.selectWord}"
            >
              ${t.text}
            </button>
          `))}
      </div>
    </div>`}renderDirections(){return e`<p>
      <strong>Select all</strong> the words that apply. Then press
      <strong>${this.t.checkAnswer}</strong> to test your answers. You will get
      feedback indicating correctness of your answer.
    </p>`}renderFeedback(){return e` ${this.edit?this.renderEditModeFeedbackAreas():e`
          ${this.showAnswer?e` <p class="feedback">
                  ${this.t.numCorrectLeft} ${this.numberCorrect} out of
                  ${this.displayedAnswers.filter((e=>e.correct)).length}
                  ${this.t.numCorrectRight} (${this.numberGuessed} guessed)
                </p>
                ${this.wordList.filter((e=>e.selected)).length>0?e`
                      <h4>Words selected feedback</h4>
                      <dl>
                        ${this.wordList.filter((e=>e.selected)).map((t=>e`
                              <dt
                                class="${t.correct?"correct":"incorrect"}"
                              >
                                ${t.text}
                              </dt>
                              <dd>${t.selectedFeedback}</dd>
                            `))}
                      </dl>
                    `:s}
                ${this.wordList.filter((e=>!e.selected&&e.unselectedFeedback)).length>0?e`
                      <h4>Words not selected feedback</h4>
                      <dl>
                        ${this.wordList.filter((e=>!e.selected&&e.unselectedFeedback)).map((t=>e`
                              <dd>${t.unselectedFeedback}</dd>
                            `))}
                      </dl>
                    `:s}
                ${this.querySelector&&this.querySelector('[slot="feedbackIncorrect"]')?e`<slot name="feedbackIncorrect"></slot>`:""}`:""}
          ${this.showAnswer&&this.numberCorrect===this.displayedAnswers.filter((e=>e.correct)).length?e` <p class="feedback">${this.correctText}</p>
                ${this.querySelector&&this.querySelector('[slot="feedbackCorrect"]')?e`<slot name="feedbackCorrect"></slot>`:""}`:""}
          ${this.querySelector&&this.querySelector('[slot="hint"]')&&this.showAnswer&&this.numberCorrect!==this.displayedAnswers.filter((e=>e.correct)).length?e`
                <h4>Need a hint?</h4>
                <div>
                  <slot name="hint"></slot>
                </div>
              `:""}
          ${this.querySelector&&this.querySelector('[slot="evidence"]')&&this.showAnswer&&this.numberCorrect===this.displayedAnswers.filter((e=>e.correct)).length?e`
                <h4>Evidence</h4>
                <div>
                  <slot name="evidence"></slot>
                </div>
              `:""}
          <simple-toolbar-button
            ?disabled="${this.disabled||!this.showAnswer}"
            @click="${this.resetAnswer}"
            label="${this.t.tryAgain}"
          >
          </simple-toolbar-button>
        `}`}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}customElements.define(MarkTheWords.tag,MarkTheWords);