/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as a,css as t}from"../../lit/index.js";import"./lib/map-menu-builder.js";import"./lib/map-menu-container.js";import{normalizeEventPath as i}from"../utils/utils.js";class MapMenu extends e{static get styles(){return[t`
        :host {
          --map-menu-item-icon-height: 18px;
          --map-menu-item-active-item-color: rgba(100, 100, 255, 0.1);
          --map-menu-item-button-height: 20px;
          --map-menu-item-height: 20px;
          --map-menu-gap: 10px;
          display: block;
          overflow-y: scroll;
          position: relative;
          height: 100%;
          transition: all 0.1s ease-in-out;
          opacity: 1;
          background-color: transparent;
        }
        :host([is-flex]){
          --map-menu-after-width: 0px;
          --map-menu-active-item-text-decoration: none;
          --a11y-collapse-transition-duration: var(--map-menu-flex-transition-duration, 0.15s);

          z-index: 100;
        }

        #itemslist {
          display: var(--map-menu-items-list-display);
          flex-direction: var(--map-menu-items-list-flex-direction);
          flex: var(--map-menu-items-list-flex);
        }
        #activeindicator {
          background: var(--map-menu-item-active-item-color);
          transition: all 0.1s ease-in-out;
          position: absolute;
          pointer-events: none;
          z-index: -1;
          width: calc(100% + (2 * var(--map-menu-gap)));
          margin-left: calc(-2 * var(--map-menu-gap));
        }

        /* Menu Conditions */
        /* Layer 1 */
        :host([is-flex]) map-menu-builder {
          width: 100%;
          position: absolute;
        }
        :host([is-flex][is-horizontal]) map-menu-builder {
          position: static;
        }
        :host([is-flex]) map-menu-builder .wrapper {
          background-color: var(--map-menu-parent-background-color);
          width: var(--map-menu-parent-width);
          padding: var(--map-menu-parent-padding);
          margin: var(--map-menu-parent-margin);
          position: relative;
          max-width: 100%;
        }
        :host([is-flex][is-horizontal]) map-menu-builder .wrapper {
          background-color: var(--map-menu-parent-background-color);
          width: var(--map-menu-parent-width, 100%);
          padding: var(--map-menu-parent-padding);
          margin: var(--map-menu-parent-margin);
          display: inline-flex;
          justify-content: center;
          align-items: center;
        }

        :host([is-flex]) map-menu-builder map-menu-item,
        :host([is-flex]) map-menu-builder map-menu-submenu {
          color: var(--map-menu-layer-1-font-color);
          padding: var(--map-menu-layer-1-padding);
          margin: var(--map-menu-layer-1-margin, 0 auto);
          --a11y-collapse-icon-position: var(--map-menu-layer-1-icon-position, static);
          --map-menu-text-transform: var(--map-menu-layer-1-text-transform, uppercase);
        }

        :host([is-flex][is-horizontal]) map-menu-builder map-menu-item,
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-submenu {
          border-left: 0;

          color: var(--map-menu-layer-1-font-color);
          --map-menu-font-weight: var(--map-menu-layer-1-font-weight, 500);
          border-bottom: var(--map-menu-layer-1-bottom-border, 4px transparent solid);
        }

        :host([is-flex][is-horizontal]) map-menu-builder map-menu-submenu:hover,
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-submenu:active,
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-submenu:focus {
          border-bottom: var(--map-menu-layer-1-bottom-border-active, 4px transparent solid);
        }

        /* Layer 2 */
        :host([is-flex]) map-menu-builder map-menu-builder {
          position: static;
        }

        :host([is-flex]) map-menu-builder map-menu-builder .wrapper{
          padding: 0;
          margin: 0 12px;
        }

        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder  {
          position: absolute;
          left: 0;
          width: 100%;

          margin: var(--map-menu-layer-2-vertical-margin, 2px 0px);
          padding: var(--map-menu-layer-2-vertical-padding, 28px 0px 40px);
          background-color: var(--map-menu-layer-2-background-color, white);
        }

        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder .wrapper{
          background-color: transparent;
          max-width: 100%;
          display: grid;
          width: fit-content;
          grid-template-columns: repeat(4, 232px);
          grid-template-rows: repeat(10, min-content) 1fr;
          align-items: start;

          margin: var(--map-menu-layer-2-horizontal-margin, 0 auto);
          padding: var(--map-menu-layer-2-horizontal-padding, 0 46px);
        }

        map-menu-builder map-menu-builder map-menu-item,
        map-menu-builder map-menu-builder map-menu-submenu {
          border-left: 2px solid
            var(--map-menu-item-a-active-background-color, black);
          margin-left: calc(var(--map-menu-gap) + 2px);
        }

        :host([is-flex]) map-menu-builder map-menu-builder map-menu-item,
        :host([is-flex]) map-menu-builder map-menu-builder map-menu-submenu {
          border: none;
          margin: 0;
          padding: 0;

          color: var(--map-menu-layer-2-font-color, #262626);
          --map-menu-header-button-padding: 10px 20px;
          --map-menu-header-title-margin: 0;
          --map-menu-item-a-active-color: var(--map-menu-layer-2-active-color, #262626);
          --map-menu-text-transform: var(--map-menu-layer-2-text-transform, uppercase);
        }

        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-item,
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-submenu {
          border: none;
          margin: none;
          display: flex;
          flex-direction: row;
          flex-wrap: nowrap;

          color: var(--map-menu-layer-2-font-color, #001e44);
          --map-menu-item-a-active-color: var(--map-menu-layer-2-active-color, #262626);
          --map-menu-text-transform: var(--map-menu-layer-2-text-transform, uppercase);
          --map-menu-font-weight: var(--map-menu-layer-2-font-weight, 700);
        }
         
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-submenu {
          order: 0;
          grid-row-end: span 20;
        }
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-builder map-menu-item:nth-child(n+10) {
          display: none;
        }
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-submenu ~ map-menu-item {
          align-self: start;
          order: 1;
          grid-auto-flow: row;
        }

        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-submenu:hover,
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-submenu:active,
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-submenu:focus {
          border-bottom: var(--map-menu-layer-2-bottom-border-active, var(--map-menu-layer-1-bottom-border-active, none));
        }

        /* Layer 3 */
        :host([is-flex]) map-menu-builder map-menu-builder map-menu-builder {
          position: relative;
          background-color: transparent;
        }

        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-builder  {
          position: relative;
          margin: 0;
          padding: 0;
        }

        :host([is-flex]) map-menu-builder map-menu-builder map-menu-builder .wrapper {          
          display: inline-flex;
          flex-direction: column;
          flex-wrap: wrap;
        }

        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-builder .wrapper {          
          border-left: none;
          margin: 0;
          padding: 0;
          display: inline-flex;
          flex-direction: column;
          flex-wrap: wrap;

          margin: var(--map-menu-layer-3-horizontal-margin, none);
          padding: var(--map-menu-layer-3-horizontal-padding, none);
        }

        map-menu-builder map-menu-builder map-menu-builder map-menu-item,
        map-menu-builder map-menu-builder map-menu-builder map-menu-submenu {
          border-left: 2px solid
            var(--map-menu-item-a-active-background-color, black);
          margin-left: calc(var(--map-menu-gap) + 2px);
        }

        :host([is-flex]) map-menu-builder map-menu-builder map-menu-builder map-menu-item,
        :host([is-flex]) map-menu-builder map-menu-builder map-menu-builder map-menu-submenu {
          border: none;
          --map-menu-header-button-padding: 10px 20px;
        }

        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-builder map-menu-item,
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-builder map-menu-submenu {
          --map-menu-text-transform: var(--map-menu-layer-3-text-transform, none);
          --map-menu-font-weight: var(--map-menu-layer-3-font-weight, 400);
          --map-menu-header-a-text-decoration-hover: var(--map-menu-layer-3-text-decoration, none);
          --map-menu-item-a-active-background-color: var(--map-menu-layer-3-active-background-color,#f2f2f4)
        }

        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-builder map-menu-submenu:hover,
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-builder map-menu-submenu:active,
        :host([is-flex][is-horizontal]) map-menu-builder map-menu-builder map-menu-builder map-menu-submenu:focus {
          border-bottom: var(--map-menu-layer-3-bottom-border-active, var(--map-menu-layer-2-bottom-border-active, none));
        }

        /* Layer 4 */
        map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-item,
        map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-submenu {
          border-left: 2px solid
            var(--map-menu-item-a-active-background-color, black);
          margin-left: calc(var(--map-menu-gap) + 2px);
        }
        :host([is-flex]) map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-item,
        :host([is-flex]) map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-submenu {
          border-left: none;
          margin-left: none;
        }

        /* Layer 5 */
        map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-item,
        map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-submenu {
          border-left: 2px solid
            var(--map-menu-item-a-active-background-color, black);
          margin-left: calc(var(--map-menu-gap) + 2px);
        }
        :host([is-flex]) map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-item,
        :host([is-flex]) map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-builder
          map-menu-submenu {
          border-left: none;
          margin-left: none;
        }

        map-menu-container {
          padding: var(--map-menu-container-padding, 0);
          display: var(--map-menu-container-display);
          flex-direction: var(--map-menu-container-flex-direction);
          flex: var(--map-menu-container-flex);
          background-color: var(--map-menu-container-background-color);
          color: var(--map-menu-container-color);
        }

        /* turn default active color if indicator is on */
        :host([active-indicator]) map-menu-builder {
          --map-menu-item-active-item-color: transparent;
        }
      `]}constructor(){super(),this.editControls=!1,this.isFlex=!1,this.isHorizontal=!1,this.maxDepth=5,this.disabled=!1,this.title="Content outline",this.data=null,this.items=[],this.autoScroll=!1,this.activeIndicator=!1,setTimeout((()=>{this.addEventListener("link-clicked",this.__linkClickedHandler.bind(this)),this.addEventListener("toggle-updated",this.__toggleUpdated.bind(this)),this.addEventListener("active-item",this.__activeItemHandler.bind(this)),this.addEventListener("opened-changed",this.__openChanged.bind(this)),this.addEventListener("map-meu-item-hidden-check",this._mapMeuItemHiddenCheckHandler.bind(this))}),0)}render(){return a`
      <div id="itemslist">
        <map-menu-container>
          <div id="activeindicator"></div>
          <map-menu-builder
            id="builder"
            ?edit-controls="${this.editControls}"
            ?is-flex="${this.isFlex}"
            ?is-horizontal="${this.isHorizontal}"
            max-depth="${this.maxDepth}"
            .items="${this.items}"
            .selected="${this.selected}"
          ></map-menu-builder>
        </map-menu-container>
      </div>
    `}static get tag(){return"map-menu"}static get properties(){return{disabled:{type:Boolean,reflect:!0},editControls:{type:Boolean,attribute:"edit-controls"},isFlex:{type:Boolean,attribute:"is-flex"},isHorizontal:{type:Boolean,attribute:"is-horizontal",reflect:!0},maxDepth:{type:Number,attribute:"max-depth"},title:{type:String},data:{type:Array},manifest:{type:Object},items:{type:Array},selected:{type:String},activeItem:{type:Object},autoScroll:{type:Boolean,attribute:"auto-scroll"},activeIndicator:{type:Boolean,reflect:!0,attribute:"active-indicator"}}}updated(e){e.forEach(((e,a)=>{"data"==a&&this._dataChanged(this[a]),"manifest"==a&&this._manifestChanged(this[a]),"activeItem"==a&&this.refreshActiveChildren(this[a],e),["manifest","items","selected"].includes(a)&&this.dispatchEvent(new CustomEvent(`${a}-changed`,{detail:{value:this[a]}}))}))}__openChanged(e){e.stopImmediatePropagation(),e.preventDefault(),e.stopPropagation(),this.shadowRoot&&this.isHorizontal&&this.shadowRoot.querySelectorAll("map-menu-submenu").forEach((e=>{0==e.isNested&&0==e.hovered&&(e.opened=!1)}))}__activeItemHandler(e){this.activeItem=e.detail}_mapMeuItemHiddenCheckHandler(e){const a=e.detail.action,t=e.detail.hiddenChild;"closed"===a&&!0===t?this.__updateActiveIndicator(this.activeItem,!0):this.__updateActiveIndicator(this.activeItem,!1)}refreshActiveChildren(e,a){e&&(e.setAttribute("active","active"),this.activeIndicator&&this.__updateActiveIndicator(e),this.autoScroll&&this.__scrollHandler(e,{duration:50,delay:0,scrollElement:this})),a&&(a.removeAttribute("active"),this.__updateActiveIndicator(e))}__scrollHandler(e,a){const t={align:"top",delay:0,duration:300,scrollElement:window},i=Object.assign({},t,a),n=e.getBoundingClientRect(),m=(i.scrollElement.getBoundingClientRect(),i.scrollElement.getBoundingClientRect().bottom-i.scrollElement.getBoundingClientRect().top),r=n.bottom-n.top,o=i.scrollElement.scrollTop;let u=e.getBoundingClientRect().top-i.scrollElement.getBoundingClientRect().top;switch(u-=m/2,i.align){case"center":u+=r/2;break;case"bottom":u+=r}let l=null;requestAnimationFrame((function animation(e){null===l&&(l=e);let a=e-l,t=function ease(e,a,t,i){return(e/=i/2)<1?t/2*e*e+a:-t/2*(--e*(e-2)-1)+a}(a,o,u,i.duration);i.scrollElement.scrollTop=t,a<i.duration&&requestAnimationFrame(animation)}))}_manifestChanged(e){e&&(this.data=e.items)}_dataChanged(e){const a=[];e&&(e.forEach((e=>{e.parent||a.push(e)})),a.forEach(((a,t)=>{this._setChildren(a,e)})),this.items=[...a])}_setChildren(e,a){const t=a.filter((a=>e.id===a.parent));e.children=t,e.children.length>0&&e.children.forEach((e=>{this._setChildren(e,a)}))}__hasChildren(e){return e.children.length>0}__linkClickedHandler(e){this.selected=e.detail.id,this.dispatchEvent(new CustomEvent("selected",{bubbles:!0,cancelable:!0,composed:!0,detail:e.detail.id}))}__toggleUpdated(e){const a=e.detail.opened?"opened":"closed",t=i(e)[0];void 0!==this.activeItem&&(this.__updateActiveIndicator(this.activeItem,!1),this.activeItem.dispatchEvent(new CustomEvent("map-menu-item-hidden-check",{bubbles:!0,cancelable:!0,composed:!0,detail:Object.assign({},{action:a,target:t})})))}__isInViewport(e){const a=this.__getScrollParent(e);if(!a)return!1;var t=e.offsetTop,i=t+e.offsetHeight,n=a.offsetTop,m=n+a.offsetHeight;return i>n&&t<m}__getScrollParent(e){return null==e?null:e.scrollHeight>e.clientHeight?e:this.__getScrollParent(e.parentNode)}__updateActiveIndicator(e,a=!1){setTimeout((()=>{const t=this.shadowRoot.querySelector("#activeindicator"),i=e.offsetTop,n=a?0:e.offsetHeight;t.setAttribute("style",`height:${n}px;top:${i}px;`)}),200)}__parentsHidden(e){const a=e.parentNode;return null==a?null:"MAP-MENU-SUBMENU"===a.tagName&&!a.opened||"MAP-MENU"!==a.tagName&&this.__parentsHidden(a)}}customElements.define(MapMenu.tag,MapMenu);export{MapMenu};