import{LitElement as e,html as t,css as i}from"../../../lit/index.js";import"./map-menu-header.js";import"../../a11y-collapse/a11y-collapse.js";class MapMenuSubmenu extends e{static get styles(){return[i`
        :host {
          display: block;
          overflow: hidden;
        }
        :host([collapsable]) > map-menu-builder {
          cursor: pointer;
          display: block;
        }
        :host([hide-in-menu]) {
          display: none;
        }
        #container {
          margin: 0 0 -2px 0;
        }
        #container ::slotted(map-menu-builder) {
          display: var(--map-menu-submenu-display, block);
        }
        a11y-collapse {
          --a11y-collapse-border: 0;
          --a11y-collapse-horizontal-padding: 0;
          --a11y-collapse-vertical-padding: 0;
          color: var(--map-menu-item-a-color, inherit);
          --simple-tooltip-margin: 0 -36px 0 0;
        }
        :host([is-flex]) a11y-collapse {
          --a11y-collapse-transition-duration: var(--a11y-collapse-transition-duration, 0.15s);
        }
        :host([is-flex][is-nested]) a11y-collapse {
          --a11y-collapse-transition-duration: 0s;
        }

        #container ::slotted(map-menu-builder)::after {
          transition: 0.3s ease-in-out all;
        }
        :host([opened]) #container ::slotted(map-menu-builder)::after {
          display: block;
          width: var(--map-menu-submenu-after-width, 12px);
          bottom: 2px;
          content: "";
          position: relative;
          border-bottom: 2px solid
            var(--map-menu-item-a-active-background-color, black);
        }
        a11y-collapse::before {
          transition: 0.3s ease-in-out all;
        }
        :host([opened]) a11y-collapse::before {
          display: block;
          width: 12px;
          height: 40px;
          content: "";
          position: absolute;
          border-bottom: 2px solid
            var(--map-menu-item-a-active-background-color, black);
        }

        :host([is-nested]) a11y-collapse::before, 
        :host([is-nested]) #container ::slotted(map-menu-builder)::after {
          border-bottom: 0;
        }

        :host([active]) a11y-collapse::part(icon),
        :host([hovered]) a11y-collapse::part(icon) {
          color: var(--map-menu-item-icon-active-color, black);
          background-color: var(--map-menu-container-background-color, white);
        }

        a11y-collapse::part(icon) {
          position: var(--a11y-collapse-icon-position, absolute);
          margin-left: 4px;
          --simple-icon-height: 18px;
          --simple-icon-width: 18px;
        }
        :host(:not([icon=""])) a11y-collapse::part(icon) {
          visibility: none;
          opacity: 0;
        }
        :host(:focus) a11y-collapse::part(icon),
        :host(:hover) a11y-collapse::part(icon) {
          visibility: visible;
          opacity: 1;
          color: var(--map-menu-item-icon-active-color, black);
          background-color: var(--map-menu-container-background-color, white);
        }
        :host([is-flex][is-nested]) a11y-collapse::part(icon){
          display: none;
        }
        :host([is-flex][is-nested]) map-menu-header::part(icon){
          display: none;
        }
      `]}constructor(){super(),this.editControls=!1,this.iconLabel=null,this.opened=!1,this.collapsable=!0,this.isFlex=!1,this.isNested=!1,this.isHorizontal=!1,this.expandChildren=!1,this.hovered=!1,this.active=!1,this.label="",this.status="",this.itemtitle="",this.locked=!1,this.published=!0,this.hideInMenu=!1,this.icon=null,this.__icon="",setTimeout((()=>{this.addEventListener("active-item",this.__activeChanged.bind(this)),this.addEventListener("toggle-header",this.__toggleHeader.bind(this)),this.addEventListener("link-clicked",this._headerClickHandler.bind(this)),this.addEventListener("map-menu-item-hidden-check",this._mapMenuItemHiddenCheckHandler.bind(this)),this.addEventListener("focusin",this.__active.bind(this)),this.addEventListener("focusout",this.__deactive.bind(this)),this.addEventListener("mouseover",this.__active.bind(this)),this.addEventListener("mouseleave",this.__deactive.bind(this))}),0)}__active(e){this.hovered=!0,"mouseover"==e.type&&this.isHorizontal&&!this.isNested&&0==this.opened&&(this.opened=!0)}__deactive(e){this.hovered=!1,"mouseleave"==e.type&&this.isHorizontal&&!this.isNested&&1==this.opened&&(this.opened=!1)}__alignCollapseState(e){e.stopImmediatePropagation(),e.preventDefault(),e.stopPropagation(),this.opened=e.detail.expanded,this.isHorizontal&&this.dispatchEvent(new CustomEvent("opened-changed",{bubbles:!0,cancelable:!0,composed:!0}))}render(){return t`
      <a11y-collapse
        id="container"
        ?expanded="${this.opened}"
        @a11y-collapse-click="${this.__alignCollapseState}"
      >
        <map-menu-header
          id="${this.id}"
          ?edit-controls="${this.editControls}"
          itemtitle="${this.itemtitle}"
          label="${this.label}"
          ?hovered="${this.hovered}"
          ?opened="${this.opened}"
          url="${this.url}"
          selected="${this.selected}"
          icon="${this.icon}"
          icon-label="${this.iconLabel}"
          slot="heading"
          ?published="${this.published}"
          ?hide-in-menu="${this.hideInMenu}"
          ?locked="${this.locked}"
          status="${this.status}"
        ></map-menu-header>
        <slot></slot>
      </a11y-collapse>
    `}static get tag(){return"map-menu-submenu"}static get properties(){return{id:{type:String},itemtitle:{type:String},iconLabel:{type:String,attribute:"icon-label"},editControls:{type:Boolean,attribute:"edit-controls"},hideInMenu:{type:Boolean,reflect:!0,attribute:"hide-in-menu"},label:{type:String},hovered:{type:Boolean,reflect:!0},active:{type:Boolean,reflect:!0},icon:{type:String,reflect:!0},url:{type:String},opened:{type:Boolean,attribute:"opened",reflect:!0},collapsable:{type:Boolean},isFlex:{type:Boolean,attribute:"is-flex"},isNested:{type:Boolean,attribute:"is-nested"},isHorizontal:{type:Boolean,attribute:"is-horizontal",reflect:!0},expandChildren:{type:Boolean,attribute:"expand-children"},selected:{type:String},published:{type:Boolean,reflect:!0},locked:{type:Boolean},status:{type:String,reflect:!0}}}_headerClickHandler(e){this.opened||(this.opened=!this.opened)}_mapMenuItemHiddenCheckHandler(e){const t=e.detail.hiddenChild;let i=Object.assign({},e.detail);i=!0!==t&&!1===this.opened?Object.assign({},i,{hiddenChild:!0}):Object.assign({},i,{hiddenChild:!1}),this.dispatchEvent(new CustomEvent("map-meu-item-hidden-check",{bubbles:!0,cancelable:!0,composed:!0,detail:i}))}__toggleHeader(e){e.stopPropagation(),this.opened=!this.opened,this.dispatchEvent(new CustomEvent("toggle-updated",{bubbles:!0,cancelable:!0,composed:!0,detail:{opened:this.opened}}))}__activeChanged(e){this.shadowRoot.querySelector("map-menu-header")===e.detail?this.active=!0:this.active=!1,this.isHorizontal&&!this.isNested?(this.blur(),this.opened=!1):this.opened=!0}}customElements.define(MapMenuSubmenu.tag,MapMenuSubmenu);export{MapMenuSubmenu};