import{LitElement as e,html as t,css as i}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";import{I18NMixin as o}from"../../i18n-manager/lib/I18NMixin.js";import"../../simple-tooltip/simple-tooltip.js";class MapMenuItem extends(o(e)){static get styles(){return[i`
        :host {
          display: block;
          position: relative;
          font-size: var(--map-menu-font-size);
          overflow: var(--map-menu-item-overflow, hidden);
        }
        simple-icon-lite {
          display: inline-flex;
          --simple-icon-height: var(--map-menu-item-icon-height);
          --simple-icon-width: var(--map-menu-item-icon-height);
          margin-right: 8px;
        }
        :host(:not([published])) {
          text-decoration: line-through;
          color: red;
          opacity: 0.5;
        }

        :host([hide-in-menu]) {
          display: none;
        }

        .title {
          text-transform: var(--map-menu-text-transform, none);
          font-size: var(--map-menu-font-size);
          font-weight: var(--map-menu-font-weight);
          text-overflow: ellipsis;
          vertical-align: middle;
          width: auto;
          white-space: nowrap;
          overflow: hidden;
          word-break: break-all;
        }
        a,
        a:visited {
          display: block;
          color: var(--map-menu-item-a-color, inherit);
          text-decoration: var(--map-menu-item-a-text-decoration, none);
        }
        :host([active]) button, :host([active]) a button {
          color: var(
            --map-menu-item-a-active-color,
            var(--map-menu-item-a-color, inherit)
          );
          font-weight: var(--map-menu-item-button-active-font-weight, bold);
          text-decoration: var(--map-menu-active-item-text-decoration, var(--map-menu-header-a-text-decoration-hover, none));
          background-color: var(
            --map-menu-item-a-active-background-color,
            black
          );
          border-radius: var(--map-menu-item-border-radius, 4px);
        }
        
        a:hover button,
        a:active button,
        a:focus button {
          color: var(
            --map-menu-item-a-active-color,
            var(--map-menu-item-a-color, inherit)
          );
          text-decoration: var(--map-menu-header-a-text-decoration-hover, none);
          background-color: var(
            --map-menu-item-a-active-background-color,
            black
          );
          border-radius: var(--map-menu-item-border-radius, 4px);
        }
        button {
          cursor: pointer;
          color: inherit;
          transition: 0.1s ease-in all;
          display: flex;
          font-family: inherit;
          background-color: transparent;
          text-transform: none;
          width: 100%;
          justify-content: left;
          margin: 0px;
          border: 0;
          line-height: var(
            --map-menu-item-button-height,
            var(--map-menu-item-height)
          );
          padding: 10px 0 10px 30px;
          text-align: left;
          border-radius: 0;
          vertical-align: middle;
        }
        :host([is-nested]) button {
          padding: 10px 20px;
          text-align: left;
        }
        :host(:not([icon=""])) button {
          padding: 10px 0 10px 4px;
        }
        :host([status="new"]) a::after {
          border-right: 8px solid green;
          content: "";
          margin-left: -8px;
        }
        :host([status="modified"]) a::after {
          border-right: 8px solid orange;
          content: "";
          margin-left: -8px;
        }
        :host([status="delete"]) a::after {
          border-right: 8px solid red;
          content: "";
          margin-left: -8px;
        }
        #unpublished {
          color: red;
        }
        .no-icon {
          display: inline-flex;
        }
        .ops {
          position: absolute;
          display: block;
          right: 0px;
          height: 40px;
          top: 0px;
          z-index: 2;
          margin: 0 4px 0 0;
        }
        .ops .op {
          --simple-icon-height: 16px;
          --simple-icon-width: 16px;
          margin: 4px;
          color: var(--map-menu-item-a-active-color, black);
        }
      `]}render(){return t` <a tabindex="-1" href="${this.url}" title="${this.itemtitle}">
        <button>
          ${this.published?"":t`<simple-icon-lite
                id="unpublished"
                title="${this.t.pageIsUnpublished}"
                icon="icons:visibility-off"
              ></simple-icon-lite>`}
          ${this.icon?t`
                <simple-icon-lite
                  icon="${this.icon}"
                  id="icon"
                ></simple-icon-lite>
                ${this.iconLabel?t`<simple-tooltip for="icon"
                      >${this.iconLabel}</simple-tooltip
                    >`:""}
              `:t`<div class="no-icon"></div>`}
          <span class="title">${this.itemtitle}</span>
        </button>
      </a>
      ${this.editControls&&this.active?t` <div class="ops">
            <haxcms-button-add
              class="op"
              type="child"
              label="Add child page"
              action-id="${this.id}"
            ></haxcms-button-add>
          </div>`:""}`}static get tag(){return"map-menu-item"}constructor(){super(),this.editControls=!1,this.isNested=!1,this.icon=null,this.iconLabel=null,this.itemtitle="",this.url="",this.active=!1,this.hovered=!1,this.hideInMenu=!1,this.published=!1,this.locked=!1,this.status="",this.t={pageIsUnpublished:"Page is unpublished"},this.registerLocalization({context:this,namespace:"map-menu",localesPath:new URL("../locales/map-menu.es.json",import.meta.url).href+"/../",locales:["es"]}),setTimeout((()=>{this.addEventListener("focusin",this.__active.bind(this)),this.addEventListener("focusout",this.__deactive.bind(this)),this.addEventListener("mouseover",this.__active.bind(this)),this.addEventListener("mouseleave",this.__deactive.bind(this))}),0)}__active(){this.hovered=!0}__deactive(){this.hovered=!1}static get properties(){return{...super.properties,icon:{type:String,reflect:!0},editControls:{type:Boolean,attribute:"edit-controls"},isNested:{type:Boolean,attribute:"is-nested"},hovered:{type:Boolean,reflect:!0},iconLabel:{type:String,attribute:"icon-label"},itemtitle:{type:String},url:{type:String},id:{type:String,reflect:!0},active:{type:Boolean,reflect:!0},selected:{type:String},published:{type:Boolean,reflect:!0},hideInMenu:{type:Boolean,reflect:!0,attribute:"hide-in-menu"},locked:{type:Boolean,reflect:!0},status:{type:String,reflect:!0}}}updated(e){e.forEach(((e,t)=>{["id","selected"].includes(t)&&this.__selectedChanged(this.selected,this.id)}))}__selectedChanged(e,t){e===t&&this.dispatchEvent(new CustomEvent("active-item",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}_click(){this.blur(),this.dispatchEvent(new CustomEvent("link-clicked",{bubbles:!0,cancelable:!0,composed:!0,detail:{id:this.id}}))}}customElements.define(MapMenuItem.tag,MapMenuItem);export{MapMenuItem};